/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.EventListener;
import java.util.Locale;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Debug Listener")
public class DebugListener
extends AbstractLifeCycle
implements ServletContextListener {
    private static final Logger LOG = Log.getLogger(DebugListener.class);
    private static final DateCache __date = new DateCache("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private final String _attr = String.format("__R%s@%x", ((Object)((Object)this)).getClass().getSimpleName(), System.identityHashCode((Object)this));
    private final PrintStream _out;
    private boolean _renameThread;
    private boolean _showHeaders;
    private boolean _dumpContext;
    final AsyncListener _asyncListener = new AsyncListener(this){
        final /* synthetic */ DebugListener this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void onTimeout(AsyncEvent event) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            String cname = this.this$0.findContextName(((AsyncContextEvent)event).getServletContext());
            String rname = this.this$0.findRequestName(event.getAsyncContext().getRequest());
            this.this$0.log("!  ctx=%s r=%s onTimeout %s", var2_2, var3_3, ((AsyncContextEvent)var1_1).getHttpChannelState());
        }

        /*
         * WARNING - void declaration
         */
        public void onStartAsync(AsyncEvent event) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            String cname = this.this$0.findContextName(((AsyncContextEvent)event).getServletContext());
            String rname = this.this$0.findRequestName(event.getAsyncContext().getRequest());
            this.this$0.log("!  ctx=%s r=%s onStartAsync %s", var2_2, var3_3, ((AsyncContextEvent)var1_1).getHttpChannelState());
        }

        /*
         * WARNING - void declaration
         */
        public void onError(AsyncEvent event) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            String cname = this.this$0.findContextName(((AsyncContextEvent)event).getServletContext());
            String rname = this.this$0.findRequestName(event.getAsyncContext().getRequest());
            this.this$0.log("!! ctx=%s r=%s onError %s %s", var2_2, var3_3, event.getThrowable(), ((AsyncContextEvent)var1_1).getHttpChannelState());
        }

        /*
         * WARNING - void declaration
         */
        public void onComplete(AsyncEvent event) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            AsyncContextEvent ace = (AsyncContextEvent)event;
            String cname = this.this$0.findContextName(ace.getServletContext());
            String rname = this.this$0.findRequestName(ace.getAsyncContext().getRequest());
            Request request = Request.getBaseRequest(ace.getAsyncContext().getRequest());
            Response response = request.getResponse();
            String headers = this.this$0._showHeaders ? "\n" + response.getHttpFields().toString() : "";
            this.this$0.log("!  ctx=%s r=%s onComplete %s %d%s", var2_2, var3_3, var1_1.getHttpChannelState(), response.getStatus(), headers);
        }
    };
    final ServletRequestListener _servletRequestListener = new ServletRequestListener(this){
        final /* synthetic */ DebugListener this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void requestInitialized(ServletRequestEvent sre) {
            void var3_3;
            void var2_2;
            String cname = this.this$0.findContextName(sre.getServletContext());
            HttpServletRequest r = (HttpServletRequest)sre.getServletRequest();
            String rname = this.this$0.findRequestName((ServletRequest)r);
            DispatcherType d = r.getDispatcherType();
            if (d == DispatcherType.REQUEST) {
                void var1_1;
                Request br = Request.getBaseRequest((ServletRequest)r);
                String headers = this.this$0._showHeaders ? "\n" + br.getMetaData().getFields().toString() : "";
                StringBuffer url = r.getRequestURL();
                if (r.getQueryString() != null) {
                    url.append('?').append(r.getQueryString());
                }
                this.this$0.log(">> %s ctx=%s r=%s %s %s %s %s %s%s", d, cname, rname, d, r.getMethod(), url.toString(), var1_1.getProtocol(), br.getHttpChannel(), headers);
                return;
            }
            this.this$0.log(">> %s ctx=%s r=%s", d, var2_2, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public void requestDestroyed(ServletRequestEvent sre) {
            void var1_1;
            void var3_3;
            void var2_2;
            String cname = this.this$0.findContextName(sre.getServletContext());
            HttpServletRequest r = (HttpServletRequest)sre.getServletRequest();
            String rname = this.this$0.findRequestName((ServletRequest)r);
            DispatcherType d = r.getDispatcherType();
            if (sre.getServletRequest().isAsyncStarted()) {
                sre.getServletRequest().getAsyncContext().addListener(this.this$0._asyncListener);
                this.this$0.log("<< %s ctx=%s r=%s async=true", d, cname, rname);
                return;
            }
            Request br = Request.getBaseRequest((ServletRequest)r);
            String headers = this.this$0._showHeaders ? "\n" + br.getResponse().getHttpFields().toString() : "";
            this.this$0.log("<< %s ctx=%s r=%s async=false %d%s", d, var2_2, rname, Request.getBaseRequest((ServletRequest)var3_3).getResponse().getStatus(), var1_1);
        }
    };
    final ContextHandler.ContextScopeListener _contextScopeListener = new ContextHandler.ContextScopeListener(this){
        final /* synthetic */ DebugListener this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void enterScope(ContextHandler.Context context, Request request, Object reason) {
            void var3_3;
            void var2_2;
            void var1_1;
            String cname = this.this$0.findContextName(context);
            if (request == null) {
                this.this$0.log(">  ctx=%s %s", cname, reason);
                return;
            }
            String rname = this.this$0.findRequestName((ServletRequest)request);
            if (this.this$0._renameThread) {
                Thread thread = Thread.currentThread();
                thread.setName(String.format("%s#%s", thread.getName(), rname));
            }
            this.this$0.log(">  ctx=%s r=%s %s", var1_1, var2_2, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void exitScope(ContextHandler.Context context, Request request) {
            Thread thread;
            String cname = this.this$0.findContextName(context);
            if (request == null) {
                this.this$0.log("<  ctx=%s", cname);
                return;
            }
            String rname = this.this$0.findRequestName((ServletRequest)request);
            this.this$0.log("<  ctx=%s r=%s", cname, rname);
            if (this.this$0._renameThread && (thread = Thread.currentThread()).getName().endsWith(rname)) {
                void var2_2;
                void var1_1;
                Thread thread2 = thread;
                thread2.setName(thread2.getName().substring(0, var1_1.getName().length() - var2_2.length() - 1));
            }
        }
    };

    public DebugListener() {
        this(null, false, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public DebugListener(@Name(value="renameThread") boolean renameThread, @Name(value="showHeaders") boolean showHeaders, @Name(value="dumpContext") boolean dumpContext) {
        this(null, (boolean)var1_1, (boolean)var2_2, (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DebugListener(@Name(value="outputStream") OutputStream out, @Name(value="renameThread") boolean renameThread, @Name(value="showHeaders") boolean showHeaders, @Name(value="dumpContext") boolean dumpContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._out = out == null ? null : new PrintStream((OutputStream)var1_1);
        this._renameThread = var2_2;
        this._showHeaders = var3_3;
        this._dumpContext = dumpContext;
    }

    @ManagedAttribute(value="Rename thread within context scope")
    public boolean isRenameThread() {
        return this._renameThread;
    }

    /*
     * WARNING - void declaration
     */
    public void setRenameThread(boolean renameThread) {
        void var1_1;
        this._renameThread = var1_1;
    }

    @ManagedAttribute(value="Show request headers")
    public boolean isShowHeaders() {
        return this._showHeaders;
    }

    /*
     * WARNING - void declaration
     */
    public void setShowHeaders(boolean showHeaders) {
        void var1_1;
        this._showHeaders = var1_1;
    }

    @ManagedAttribute(value="Dump contexts at start")
    public boolean isDumpContext() {
        return this._dumpContext;
    }

    /*
     * WARNING - void declaration
     */
    public void setDumpContext(boolean dumpContext) {
        void var1_1;
        this._dumpContext = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void contextInitialized(ServletContextEvent sce) {
        void var3_4;
        sce.getServletContext().addListener((EventListener)this._servletRequestListener);
        ContextHandler handler = ContextHandler.getContextHandler(sce.getServletContext());
        handler.addEventListener(this._contextScopeListener);
        String cname = this.findContextName(sce.getServletContext());
        this.log("^  ctx=%s %s", var3_4, sce.getServletContext());
        if (this._dumpContext) {
            if (this._out == null) {
                handler.dumpStdErr();
                System.err.println("key: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +@ map, +> undefined");
                return;
            }
            try {
                void var2_3;
                var2_3.dump((Appendable)this._out);
                this._out.println("key: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +@ map, +> undefined");
                return;
            }
            catch (Exception e) {
                void var1_2;
                LOG.warn((Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void contextDestroyed(ServletContextEvent sce) {
        void var1_1;
        void var2_2;
        String cname = this.findContextName(sce.getServletContext());
        this.log("v  ctx=%s %s", var2_2, var1_1.getServletContext());
    }

    /*
     * WARNING - void declaration
     */
    protected String findContextName(ServletContext context) {
        void var2_2;
        if (context == null) {
            return null;
        }
        String n = (String)context.getAttribute(this._attr);
        if (n == null) {
            void var1_1;
            n = String.format("%s@%x", context.getContextPath(), context.hashCode());
            var1_1.setAttribute(this._attr, (Object)n);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected String findRequestName(ServletRequest request) {
        void var3_3;
        if (request == null) {
            return null;
        }
        HttpServletRequest r = (HttpServletRequest)request;
        String n = (String)request.getAttribute(this._attr);
        if (n == null) {
            void var1_1;
            void var2_2;
            n = String.format("%s@%x", var2_2.getRequestURI(), request.hashCode());
            var1_1.setAttribute(this._attr, (Object)n);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void log(String format, Object ... arg) {
        void var2_2;
        if (!this.isRunning()) {
            return;
        }
        String s = String.format(format, (Object[])var2_2);
        long now = System.currentTimeMillis();
        long ms = now % 1000L;
        if (this._out != null) {
            this._out.printf("%s.%03d:%s%n", __date.formatNow(now), ms, s);
        }
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.info((String)var1_1, new Object[0]);
        }
    }
}

