/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.lang.constant.Constable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Custom format request log")
public class CustomRequestLog
extends ContainerLifeCycle
implements RequestLog {
    protected static final Logger LOG = Log.getLogger(CustomRequestLog.class);
    public static final String DEFAULT_DATE_FORMAT = "dd/MMM/yyyy:HH:mm:ss ZZZ";
    public static final String NCSA_FORMAT = "%{client}a - %u %t \"%r\" %s %O";
    public static final String EXTENDED_NCSA_FORMAT = "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"";
    private static final ThreadLocal<StringBuilder> _buffers = ThreadLocal.withInitial(() -> new StringBuilder(256));
    private final RequestLog.Writer _requestLogWriter;
    private final MethodHandle _logHandle;
    private final String _formatString;
    private transient PathMappings<String> _ignorePathMap;
    private String[] _ignorePaths;

    /*
     * WARNING - void declaration
     */
    public CustomRequestLog(RequestLog.Writer writer, String formatString) {
        this._formatString = formatString;
        this._requestLogWriter = writer;
        CustomRequestLog customRequestLog = this;
        customRequestLog.addBean(customRequestLog._requestLogWriter);
        try {
            void var2_3;
            this._logHandle = this.getLogHandle((String)var2_3);
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            void var1_2;
            throw new IllegalStateException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public CustomRequestLog(String file) {
        this((String)var1_1, EXTENDED_NCSA_FORMAT);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CustomRequestLog(String file, String format) {
        this(new RequestLogWriter((String)var1_1), (String)var2_2);
        void var2_2;
        void var1_1;
    }

    @ManagedAttribute(value="The RequestLogWriter")
    public RequestLog.Writer getWriter() {
        return this._requestLogWriter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Request request, Response response) {
        try {
            void var1_1;
            void var2_2;
            if (this._ignorePathMap != null && this._ignorePathMap.getMatched(request.getRequestURI()) != null) {
                return;
            }
            StringBuilder sb = _buffers.get();
            sb.setLength(0);
            this._logHandle.invoke(sb, request, (Response)var2_2);
            String log = sb.toString();
            this._requestLogWriter.write((String)var1_1);
            return;
        }
        catch (Throwable e) {
            void var3_4;
            LOG.warn((Throwable)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static String getAuthentication(Request request, boolean checkDeferred) {
        Object object;
        void var1_1;
        Authentication authentication = request.getAuthentication();
        if (var1_1 != false && authentication instanceof Authentication.Deferred) {
            authentication = ((Authentication.Deferred)authentication).authenticate((ServletRequest)request);
        }
        Object name = null;
        if (authentication instanceof Authentication.User) {
            void var2_2;
            name = ((Authentication.User)var2_2).getUserIdentity().getUserPrincipal().getName();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public void setIgnorePaths(String[] ignorePaths) {
        void var1_1;
        this._ignorePaths = var1_1;
    }

    public String[] getIgnorePaths() {
        return this._ignorePaths;
    }

    @ManagedAttribute(value="format string")
    public String getFormatString() {
        return this._formatString;
    }

    protected synchronized void doStart() throws Exception {
        if (this._ignorePaths != null && this._ignorePaths.length > 0) {
            this._ignorePathMap = new PathMappings();
            String[] stringArray = this._ignorePaths;
            int n = this._ignorePaths.length;
            for (int i = 0; i < n; ++i) {
                String ignorePath;
                String string = ignorePath = stringArray[i];
                this._ignorePathMap.put(string, (Object)string);
            }
        } else {
            this._ignorePathMap = null;
        }
        super.doStart();
    }

    /*
     * WARNING - void declaration
     */
    private static void append(StringBuilder buf, String s) {
        void var1_1;
        StringBuilder stringBuilder;
        if (s == null || s.length() == 0) {
            buf.append('-');
            return;
        }
        stringBuilder.append((String)var1_1);
    }

    private static void append(String s, StringBuilder buf) {
        String string;
        CustomRequestLog.append(buf, string);
    }

    private MethodHandle getLogHandle(String formatString) throws NoSuchMethodException, IllegalAccessException {
        Iterator iterator;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle append = lookup.findStatic(CustomRequestLog.class, "append", MethodType.methodType(Void.TYPE, String.class, StringBuilder.class));
        MethodHandle logHandle = lookup.findStatic(CustomRequestLog.class, "logNothing", MethodType.methodType(Void.TYPE, StringBuilder.class, Request.class, Response.class));
        List<Token> tokens = CustomRequestLog.getTokens(formatString);
        Collections.reverse(tokens);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Token t = (Token)iterator.next();
            if (t.isLiteralString()) {
                logHandle = this.updateLogHandle(logHandle, append, t.literal);
                continue;
            }
            if (t.isPercentCode()) {
                logHandle = this.updateLogHandle(logHandle, append, lookup, t.code, t.arg, t.modifiers, t.negated);
                continue;
            }
            throw new IllegalStateException("bad token " + t);
        }
        return logHandle;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Token> getTokens(String formatString) {
        void var2_2;
        Matcher remaining;
        Pattern PATTERN = Pattern.compile("^(?:%(?<MOD>!?[0-9,]+)?(?:\\{(?<ARG>[^}]+)})?(?<CODE>(?:(?:ti)|(?:to)|[a-zA-Z%]))|(?<LITERAL>[^%]+))(?<REMAINING>.*)", 40);
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (((String)((Object)remaining)).length() > 0) {
            Matcher m = PATTERN.matcher((CharSequence)((Object)remaining));
            if (m.matches()) {
                Matcher matcher;
                if (m.group("CODE") != null) {
                    String code = m.group("CODE");
                    String arg = m.group("ARG");
                    String modifierString = m.group("MOD");
                    List modifiers = null;
                    boolean negated = false;
                    if (modifierString != null) {
                        if (modifierString.startsWith("!")) {
                            modifierString = modifierString.substring(1);
                            negated = true;
                        }
                        modifiers = new QuotedCSV(new String[]{modifierString}).getValues().stream().map(Integer::parseInt).collect(Collectors.toList());
                    }
                    tokens.add(new Token(code, arg, modifiers, negated));
                } else if (m.group("LITERAL") != null) {
                    void var3_3;
                    String literal = m.group("LITERAL");
                    tokens.add(new Token((String)var3_3));
                } else {
                    throw new IllegalStateException("formatString parsing error");
                }
                matcher = matcher.group("REMAINING");
                continue;
            }
            throw new IllegalArgumentException("Invalid format string");
        }
        return var2_2;
    }

    private static boolean modify(List<Integer> modifiers, Boolean negated, StringBuilder b, Request request, Response response) {
        List<Integer> list;
        if (negated.booleanValue()) {
            return !modifiers.contains(response.getStatus());
        }
        return list.contains(response.getStatus());
    }

    /*
     * WARNING - void declaration
     */
    private MethodHandle updateLogHandle(MethodHandle logHandle, MethodHandle append, String literal) {
        void var3_3;
        void var2_2;
        return MethodHandles.foldArguments(logHandle, MethodHandles.dropArguments(MethodHandles.dropArguments(var2_2.bindTo(var3_3), 1, new Class[]{Request.class}), 2, new Class[]{Response.class}));
    }

    /*
     * WARNING - void declaration
     */
    private MethodHandle updateLogHandle(MethodHandle logHandle, MethodHandle append, MethodHandles.Lookup lookup, String code, String arg, List<Integer> modifiers, boolean negated) throws NoSuchMethodException, IllegalAccessException {
        void var1_1;
        MethodHandle specificHandle;
        MethodType logType = MethodType.methodType(Void.TYPE, StringBuilder.class, Request.class, Response.class);
        Object logTypeArg = MethodType.methodType(Void.TYPE, String.class, StringBuilder.class, Request.class, Response.class);
        switch (code) {
            case "%": {
                specificHandle = MethodHandles.dropArguments(MethodHandles.dropArguments(append.bindTo("%"), 1, new Class[]{Request.class}), 2, new Class[]{Response.class});
                break;
            }
            case "a": {
                String method;
                if (StringUtil.isEmpty((String)arg)) {
                    arg = "server";
                }
                switch (arg) {
                    case "server": {
                        method = "logServerHost";
                        break;
                    }
                    case "client": {
                        method = "logClientHost";
                        break;
                    }
                    case "local": {
                        method = "logLocalHost";
                        break;
                    }
                    case "remote": {
                        method = "logRemoteHost";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid arg for %a");
                    }
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "p": {
                String method;
                if (StringUtil.isEmpty((String)arg)) {
                    arg = "server";
                }
                switch (arg) {
                    case "server": {
                        method = "logServerPort";
                        break;
                    }
                    case "client": {
                        method = "logClientPort";
                        break;
                    }
                    case "local": {
                        method = "logLocalPort";
                        break;
                    }
                    case "remote": {
                        method = "logRemotePort";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid arg for %p");
                    }
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "I": {
                String method;
                if (StringUtil.isEmpty((String)arg)) {
                    method = "logBytesReceived";
                } else if (arg.equalsIgnoreCase("clf")) {
                    method = "logBytesReceivedCLF";
                } else {
                    throw new IllegalArgumentException("Invalid argument for %I");
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "O": {
                String method;
                if (StringUtil.isEmpty((String)arg)) {
                    method = "logBytesSent";
                } else if (arg.equalsIgnoreCase("clf")) {
                    method = "logBytesSentCLF";
                } else {
                    throw new IllegalArgumentException("Invalid argument for %O");
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "S": {
                String method;
                if (StringUtil.isEmpty((String)arg)) {
                    method = "logBytesTransferred";
                } else if (arg.equalsIgnoreCase("clf")) {
                    method = "logBytesTransferredCLF";
                } else {
                    throw new IllegalArgumentException("Invalid argument for %S");
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "C": {
                if (StringUtil.isEmpty((String)arg)) {
                    specificHandle = lookup.findStatic(CustomRequestLog.class, "logRequestCookies", logType);
                    break;
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logRequestCookie", (MethodType)logTypeArg);
                specificHandle = specificHandle.bindTo(arg);
                break;
            }
            case "D": {
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logLatencyMicroseconds", logType);
                break;
            }
            case "e": {
                if (StringUtil.isEmpty((String)arg)) {
                    throw new IllegalArgumentException("No arg for %e");
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logEnvironmentVar", (MethodType)logTypeArg);
                specificHandle = specificHandle.bindTo(arg);
                break;
            }
            case "f": {
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logFilename", logType);
                break;
            }
            case "H": {
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logRequestProtocol", logType);
                break;
            }
            case "i": {
                if (StringUtil.isEmpty((String)arg)) {
                    throw new IllegalArgumentException("No arg for %i");
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logRequestHeader", (MethodType)logTypeArg);
                specificHandle = specificHandle.bindTo(arg);
                break;
            }
            case "k": {
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logKeepAliveRequests", logType);
                break;
            }
            case "m": {
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logRequestMethod", logType);
                break;
            }
            case "o": {
                if (StringUtil.isEmpty((String)arg)) {
                    throw new IllegalArgumentException("No arg for %o");
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logResponseHeader", (MethodType)logTypeArg);
                specificHandle = specificHandle.bindTo(arg);
                break;
            }
            case "q": {
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logQueryString", logType);
                break;
            }
            case "r": {
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logRequestFirstLine", logType);
                break;
            }
            case "R": {
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logRequestHandler", logType);
                break;
            }
            case "s": {
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logResponseStatus", logType);
                break;
            }
            case "t": {
                String format = DEFAULT_DATE_FORMAT;
                TimeZone timeZone = TimeZone.getTimeZone("GMT");
                Locale locale = Locale.getDefault();
                if (arg != null && !arg.isEmpty()) {
                    String[] args = arg.split("\\|");
                    switch (args.length) {
                        case 1: {
                            format = args[0];
                            break;
                        }
                        case 2: {
                            format = args[0];
                            timeZone = TimeZone.getTimeZone(args[1]);
                            break;
                        }
                        case 3: {
                            format = args[0];
                            timeZone = TimeZone.getTimeZone(args[1]);
                            locale = Locale.forLanguageTag(args[2]);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Too many \"|\" characters in %t");
                        }
                    }
                }
                DateCache logDateCache = new DateCache(format, locale, timeZone);
                Constable logTypeDateCache = MethodType.methodType(Void.TYPE, DateCache.class, StringBuilder.class, Request.class, Response.class);
                logTypeDateCache = lookup.findStatic(CustomRequestLog.class, "logRequestTime", (MethodType)logTypeDateCache);
                specificHandle = ((MethodHandle)logTypeDateCache).bindTo(logDateCache);
                break;
            }
            case "T": {
                String string;
                String method;
                if (string == null) {
                    string = "s";
                }
                switch (string) {
                    case "s": {
                        method = "logLatencySeconds";
                        break;
                    }
                    case "us": {
                        method = "logLatencyMicroseconds";
                        break;
                    }
                    case "ms": {
                        method = "logLatencyMilliseconds";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid arg for %T");
                    }
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "u": {
                String string;
                String method;
                if (StringUtil.isEmpty((String)string)) {
                    method = "logRequestAuthentication";
                } else if ("d".equals(string)) {
                    method = "logRequestAuthenticationWithDeferred";
                } else {
                    throw new IllegalArgumentException("Invalid arg for %u: " + string);
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "U": {
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logUrlRequestPath", logType);
                break;
            }
            case "X": {
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logConnectionStatus", logType);
                break;
            }
            case "ti": {
                void var9_9;
                String string;
                if (StringUtil.isEmpty((String)string)) {
                    throw new IllegalArgumentException("No arg for %ti");
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logRequestTrailer", (MethodType)var9_9);
                specificHandle = specificHandle.bindTo(string);
                break;
            }
            case "to": {
                void var9_9;
                String string;
                if (StringUtil.isEmpty((String)string)) {
                    throw new IllegalArgumentException("No arg for %to");
                }
                specificHandle = lookup.findStatic(CustomRequestLog.class, "logResponseTrailer", (MethodType)var9_9);
                specificHandle = specificHandle.bindTo(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported code %" + (String)((Object)specificHandle));
            }
        }
        if (modifiers != null && !modifiers.isEmpty()) {
            void var3_3;
            void var2_2;
            MethodHandle dash = this.updateLogHandle(logHandle, (MethodHandle)var2_2, "-");
            MethodHandle log = MethodHandles.foldArguments(logHandle, specificHandle);
            specificHandle = var3_3.findStatic(CustomRequestLog.class, "modify", MethodType.methodType(Boolean.TYPE, List.class, Boolean.class, StringBuilder.class, Request.class, Response.class));
            specificHandle = specificHandle.bindTo(modifiers).bindTo(negated);
            return MethodHandles.guardWithTest(specificHandle, log, dash);
        }
        return MethodHandles.foldArguments((MethodHandle)var1_1, specificHandle);
    }

    private static void logNothing(StringBuilder b, Request request, Response response) {
    }

    /*
     * WARNING - void declaration
     */
    private static void logServerHost(StringBuilder b, Request request, Response response) {
        void var1_1;
        CustomRequestLog.append(b, var1_1.getServerName());
    }

    /*
     * WARNING - void declaration
     */
    private static void logClientHost(StringBuilder b, Request request, Response response) {
        void var1_1;
        CustomRequestLog.append(b, var1_1.getRemoteHost());
    }

    /*
     * WARNING - void declaration
     */
    private static void logLocalHost(StringBuilder b, Request request, Response response) {
        void var1_1;
        CustomRequestLog.append(b, var1_1.getHttpChannel().getEndPoint().getLocalAddress().getAddress().getHostAddress());
    }

    /*
     * WARNING - void declaration
     */
    private static void logRemoteHost(StringBuilder b, Request request, Response response) {
        void var1_1;
        CustomRequestLog.append(b, var1_1.getHttpChannel().getEndPoint().getRemoteAddress().getAddress().getHostAddress());
    }

    /*
     * WARNING - void declaration
     */
    private static void logServerPort(StringBuilder b, Request request, Response response) {
        void var1_1;
        b.append(var1_1.getServerPort());
    }

    /*
     * WARNING - void declaration
     */
    private static void logClientPort(StringBuilder b, Request request, Response response) {
        void var1_1;
        b.append(var1_1.getRemotePort());
    }

    /*
     * WARNING - void declaration
     */
    private static void logLocalPort(StringBuilder b, Request request, Response response) {
        void var1_1;
        b.append(var1_1.getHttpChannel().getEndPoint().getLocalAddress().getPort());
    }

    /*
     * WARNING - void declaration
     */
    private static void logRemotePort(StringBuilder b, Request request, Response response) {
        void var1_1;
        b.append(var1_1.getHttpChannel().getEndPoint().getRemoteAddress().getPort());
    }

    /*
     * WARNING - void declaration
     */
    private static void logResponseSize(StringBuilder b, Request request, Response response) {
        void var3_3;
        StringBuilder stringBuilder;
        long written = response.getHttpChannel().getBytesWritten();
        stringBuilder.append((long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void logResponseSizeCLF(StringBuilder b, Request request, Response response) {
        void var3_3;
        StringBuilder stringBuilder;
        long written = response.getHttpChannel().getBytesWritten();
        if (written == 0L) {
            b.append('-');
            return;
        }
        stringBuilder.append((long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void logBytesSent(StringBuilder b, Request request, Response response) {
        void var2_2;
        b.append(var2_2.getHttpChannel().getBytesWritten());
    }

    /*
     * WARNING - void declaration
     */
    private static void logBytesSentCLF(StringBuilder b, Request request, Response response) {
        void var3_3;
        StringBuilder stringBuilder;
        long sent = response.getHttpChannel().getBytesWritten();
        if (sent == 0L) {
            b.append('-');
            return;
        }
        stringBuilder.append((long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void logBytesReceived(StringBuilder b, Request request, Response response) {
        void var1_1;
        b.append(var1_1.getHttpInput().getContentReceived());
    }

    /*
     * WARNING - void declaration
     */
    private static void logBytesReceivedCLF(StringBuilder b, Request request, Response response) {
        void var3_3;
        StringBuilder stringBuilder;
        long received = request.getHttpInput().getContentReceived();
        if (received == 0L) {
            b.append('-');
            return;
        }
        stringBuilder.append((long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void logBytesTransferred(StringBuilder b, Request request, Response response) {
        void var2_2;
        void var1_1;
        b.append(var1_1.getHttpInput().getContentReceived() + var2_2.getHttpOutput().getWritten());
    }

    /*
     * WARNING - void declaration
     */
    private static void logBytesTransferredCLF(StringBuilder b, Request request, Response response) {
        void var3_3;
        StringBuilder stringBuilder;
        void var2_2;
        long transferred = request.getHttpInput().getContentReceived() + var2_2.getHttpOutput().getWritten();
        if (transferred == 0L) {
            b.append('-');
            return;
        }
        stringBuilder.append((long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void logRequestCookie(String arg, StringBuilder b, Request request, Response response) {
        void var1_1;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            void var2_2;
            for (void c : var2_2) {
                if (!arg.equals(c.getName())) continue;
                b.append(c.getValue());
                return;
            }
        }
        var1_1.append('-');
    }

    private static void logRequestCookies(StringBuilder b, Request request, Response response) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            b.append("-");
            return;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (i != 0) {
                b.append(';');
            }
            b.append(cookies[i].getName());
            b.append('=');
            b.append(cookies[i].getValue());
        }
    }

    private static void logEnvironmentVar(String arg, StringBuilder b, Request request, Response response) {
        String string;
        CustomRequestLog.append(b, System.getenv(string));
    }

    /*
     * WARNING - void declaration
     */
    private static void logFilename(StringBuilder b, Request request, Response response) {
        void var1_1;
        StringBuilder stringBuilder;
        void var2_3;
        void var3_4;
        UserIdentity.Scope scope = request.getUserIdentityScope();
        if (scope == null || scope.getContextHandler() == null) {
            b.append('-');
            return;
        }
        ContextHandler context = scope.getContextHandler();
        int lengthToStrip = scope.getContextPath().length() > 1 ? scope.getContextPath().length() : 0;
        String filename = ((ContextHandler.StaticContext)var3_4.getServletContext()).getRealPath(request.getPathInfo().substring((int)var2_3));
        CustomRequestLog.append(stringBuilder, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void logRequestProtocol(StringBuilder b, Request request, Response response) {
        void var1_1;
        CustomRequestLog.append(b, var1_1.getProtocol());
    }

    /*
     * WARNING - void declaration
     */
    private static void logRequestHeader(String arg, StringBuilder b, Request request, Response response) {
        String string;
        void var2_2;
        CustomRequestLog.append(b, var2_2.getHeader(string));
    }

    /*
     * WARNING - void declaration
     */
    private static void logKeepAliveRequests(StringBuilder b, Request request, Response response) {
        StringBuilder stringBuilder;
        long requests = request.getHttpChannel().getConnection().getMessagesIn();
        if (requests >= 0L) {
            void var3_3;
            b.append((long)var3_3);
            return;
        }
        stringBuilder.append('-');
    }

    /*
     * WARNING - void declaration
     */
    private static void logRequestMethod(StringBuilder b, Request request, Response response) {
        void var1_1;
        CustomRequestLog.append(b, var1_1.getMethod());
    }

    /*
     * WARNING - void declaration
     */
    private static void logResponseHeader(String arg, StringBuilder b, Request request, Response response) {
        String string;
        void var3_3;
        CustomRequestLog.append(b, var3_3.getHeader(string));
    }

    /*
     * WARNING - void declaration
     */
    private static void logQueryString(StringBuilder b, Request request, Response response) {
        void var1_1;
        CustomRequestLog.append(b, "?" + var1_1.getQueryString());
    }

    /*
     * WARNING - void declaration
     */
    private static void logRequestFirstLine(StringBuilder b, Request request, Response response) {
        void var1_1;
        StringBuilder stringBuilder;
        CustomRequestLog.append(b, request.getMethod());
        b.append(" ");
        CustomRequestLog.append(b, request.getOriginalURI());
        b.append(" ");
        CustomRequestLog.append(stringBuilder, var1_1.getProtocol());
    }

    /*
     * WARNING - void declaration
     */
    private static void logRequestHandler(StringBuilder b, Request request, Response response) {
        void var1_1;
        CustomRequestLog.append(b, var1_1.getServletName());
    }

    /*
     * WARNING - void declaration
     */
    private static void logResponseStatus(StringBuilder b, Request request, Response response) {
        void var2_2;
        b.append(var2_2.getCommittedMetaData().getStatus());
    }

    /*
     * WARNING - void declaration
     */
    private static void logRequestTime(DateCache dateCache, StringBuilder b, Request request, Response response) {
        void var1_1;
        void var2_2;
        DateCache dateCache2;
        b.append('[');
        CustomRequestLog.append(b, dateCache2.format(var2_2.getTimeStamp()));
        var1_1.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void logLatencyMicroseconds(StringBuilder b, Request request, Response response) {
        StringBuilder stringBuilder;
        void var3_3;
        void var1_1;
        long currentTime = System.currentTimeMillis();
        long requestTime = var1_1.getTimeStamp();
        void latencyMs = var3_3 - requestTime;
        long latencyUs = TimeUnit.MILLISECONDS.toMicros((long)latencyMs);
        stringBuilder.append(latencyUs);
    }

    /*
     * WARNING - void declaration
     */
    private static void logLatencyMilliseconds(StringBuilder b, Request request, Response response) {
        void var3_3;
        StringBuilder stringBuilder;
        void var1_1;
        long latency = System.currentTimeMillis() - var1_1.getTimeStamp();
        stringBuilder.append((long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void logLatencySeconds(StringBuilder b, Request request, Response response) {
        void var3_3;
        StringBuilder stringBuilder;
        void var1_1;
        long latency = System.currentTimeMillis() - var1_1.getTimeStamp();
        stringBuilder.append(TimeUnit.MILLISECONDS.toSeconds((long)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private static void logRequestAuthentication(StringBuilder b, Request request, Response response) {
        void var1_1;
        CustomRequestLog.append(b, CustomRequestLog.getAuthentication((Request)var1_1, false));
    }

    /*
     * WARNING - void declaration
     */
    private static void logRequestAuthenticationWithDeferred(StringBuilder b, Request request, Response response) {
        void var1_1;
        CustomRequestLog.append(b, CustomRequestLog.getAuthentication((Request)var1_1, true));
    }

    /*
     * WARNING - void declaration
     */
    private static void logUrlRequestPath(StringBuilder b, Request request, Response response) {
        void var1_1;
        CustomRequestLog.append(b, var1_1.getRequestURI());
    }

    /*
     * WARNING - void declaration
     */
    private static void logConnectionStatus(StringBuilder b, Request request, Response response) {
        void var1_1;
        b.append((char)(request.getHttpChannel().isResponseCompleted() ? (var1_1.getHttpChannel().isPersistent() ? 43 : 45) : 88));
    }

    /*
     * WARNING - void declaration
     */
    private static void logRequestTrailer(String arg, StringBuilder b, Request request, Response response) {
        void var1_1;
        HttpFields trailers = request.getTrailers();
        if (trailers != null) {
            String string;
            void var2_2;
            CustomRequestLog.append(b, var2_2.get(string));
            return;
        }
        var1_1.append('-');
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void logResponseTrailer(String arg, StringBuilder b, Request request, Response response) {
        Supplier<HttpFields> supplier = response.getTrailers();
        if (supplier == null) {
            void var1_1;
            var1_1.append("-");
            return;
        }
        HttpFields trailers = supplier.get();
        if (trailers != null) {
            String string;
            void var2_2;
            CustomRequestLog.append(b, var2_2.get(string));
            return;
        }
        b.append('-');
    }

    private static class Token {
        public final String code;
        public final String arg;
        public final List<Integer> modifiers;
        public final boolean negated;
        public final String literal;

        /*
         * WARNING - void declaration
         */
        public Token(String code, String arg, List<Integer> modifiers, boolean negated) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.code = var1_1;
            this.arg = var2_2;
            this.modifiers = var3_3;
            this.negated = negated;
            this.literal = null;
        }

        /*
         * WARNING - void declaration
         */
        public Token(String literal) {
            void var1_1;
            this.code = null;
            this.arg = null;
            this.modifiers = null;
            this.negated = false;
            this.literal = var1_1;
        }

        public boolean isLiteralString() {
            return this.literal != null;
        }

        public boolean isPercentCode() {
            return this.code != null;
        }
    }
}

