/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class CookieCutter {
    private static final Logger LOG = Log.getLogger(CookieCutter.class);
    private final CookieCompliance _compliance;
    private Cookie[] _cookies;
    private Cookie[] _lastCookies;
    private final List<String> _fieldList = new ArrayList<String>();
    int _fields;

    public CookieCutter() {
        this(CookieCompliance.RFC6265);
    }

    /*
     * WARNING - void declaration
     */
    public CookieCutter(CookieCompliance compliance) {
        void var1_1;
        this._compliance = var1_1;
    }

    public Cookie[] getCookies() {
        if (this._cookies != null) {
            return this._cookies;
        }
        if (this._lastCookies != null && this._fields == this._fieldList.size()) {
            this._cookies = this._lastCookies;
        } else {
            this.parseFields();
        }
        this._lastCookies = this._cookies;
        return this._cookies;
    }

    /*
     * WARNING - void declaration
     */
    public void setCookies(Cookie[] cookies) {
        void var1_1;
        this._cookies = var1_1;
        this._lastCookies = null;
        this._fieldList.clear();
        this._fields = 0;
    }

    public void reset() {
        this._cookies = null;
        this._fields = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void addCookieField(String f) {
        void var1_1;
        if (f == null) {
            return;
        }
        if ((f = f.trim()).length() == 0) {
            return;
        }
        if (this._fieldList.size() > this._fields) {
            if (f.equals(this._fieldList.get(this._fields))) {
                ++this._fields;
                return;
            }
            while (this._fieldList.size() > this._fields) {
                this._fieldList.remove(this._fields);
            }
        }
        this._cookies = null;
        this._lastCookies = null;
        this._fieldList.add(this._fields++, (String)var1_1);
    }

    /*
     * Unable to fully structure code
     */
    protected void parseFields() {
        this._lastCookies = null;
        this._cookies = null;
        cookies = new ArrayList<Cookie>();
        version = 0;
        while (this._fieldList.size() > this._fields) {
            this._fieldList.remove(this._fields);
        }
        unquoted = null;
        for (String hdr : this._fieldList) {
            name = null;
            cookie = null;
            invalue = false;
            inQuoted = false;
            quoted = false;
            escaped = false;
            reject = 0;
            tokenstart = -1;
            tokenend = -1;
            length = hdr.length();
            block33: for (i = 0; i <= length; ++i) {
                block59: {
                    v0 = c = i == length ? '\u0000' : hdr.charAt(i);
                    if (inQuoted) {
                        var18_20 = c == '\u0000' && i == hdr.length();
                        if (!var18_20 && this._compliance != CookieCompliance.RFC2965 && this.isRFC6265RejectedCharacter(inQuoted, c)) {
                            reject = 1;
                            continue;
                        }
                        if (escaped) {
                            escaped = false;
                            if (c > '\u0000') {
                                unquoted.append(c);
                                continue;
                            }
                            unquoted.setLength(0);
                            inQuoted = false;
                            --i;
                            continue;
                        }
                        switch (c) {
                            case '\"': {
                                inQuoted = false;
                                quoted = true;
                                tokenstart = i;
                                tokenend = -1;
                                break;
                            }
                            case '\\': {
                                escaped = true;
                                break;
                            }
                            case '\u0000': {
                                if (this._compliance == CookieCompliance.RFC6265) continue block33;
                                unquoted.setLength(0);
                                inQuoted = false;
                                --i;
                                break;
                            }
                            case ';': {
                                if (this._compliance == CookieCompliance.RFC6265) {
                                    reject = 1;
                                    break;
                                }
                                unquoted.append(c);
                                break;
                            }
                            default: {
                                unquoted.append(c);
                                break;
                            }
                        }
                        continue;
                    }
                    if (!invalue) break block59;
                    var18_20 = c == '\u0000' && i == hdr.length();
                    if (!var18_20 && this._compliance == CookieCompliance.RFC6265 && this.isRFC6265RejectedCharacter(inQuoted, c)) {
                        reject = 1;
                        continue;
                    }
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case ',': {
                            if (this._compliance != CookieCompliance.RFC2965) {
                                if (quoted) {
                                    unquoted.append(hdr, tokenstart, i--);
                                    inQuoted = true;
                                    quoted = false;
                                    break;
                                }
                                if (tokenstart < 0) {
                                    tokenstart = i;
                                }
                                tokenend = i;
                                break;
                            }
                        }
                        case '\u0000': 
                        case ';': {
                            if (quoted) {
                                value = unquoted.toString();
                                unquoted.setLength(0);
                                quoted = false;
                            } else {
                                value = tokenstart >= 0 ? (tokenend >= tokenstart ? hdr.substring(tokenstart, tokenend + 1) : hdr.substring(tokenstart)) : "";
                            }
                            try {
                                if (!name.startsWith("$")) ** GOTO lbl130
                                if (this._compliance != CookieCompliance.RFC2965) ** GOTO lbl139
                                name = name.toLowerCase(Locale.ENGLISH);
                                reject = -1;
                                switch (name.hashCode()) {
                                    case 36680265: {
                                        if (!name.equals("$path")) break;
                                        reject = 0;
                                        break;
                                    }
                                    case 559163880: {
                                        if (!name.equals("$domain")) break;
                                        reject = 1;
                                        break;
                                    }
                                    case 36693669: {
                                        if (!name.equals("$port")) break;
                                        reject = 2;
                                        break;
                                    }
                                    case -1331729356: {
                                        if (!name.equals("$version")) break;
                                        reject = 3;
                                    }
                                }
                                switch (reject) {
                                    case 0: {
                                        if (cookie == null) ** GOTO lbl139
                                        cookie.setPath(value);
                                        ** GOTO lbl139
                                    }
                                    case 1: {
                                        if (cookie == null) ** GOTO lbl139
                                        cookie.setDomain(value);
                                        ** GOTO lbl139
                                    }
                                    case 2: {
                                        if (cookie == null) ** GOTO lbl139
                                        cookie.setComment("$port=" + value);
                                        ** GOTO lbl139
                                    }
                                    case 3: {
                                        version = Integer.parseInt(value);
                                    }
                                }
                                ** GOTO lbl139
lbl130:
                                // 1 sources

                                cookie = new Cookie(name, value);
                                if (version > 0) {
                                    cookie.setVersion(version);
                                }
                                if (reject == 0) {
                                    cookies.add(cookie);
                                }
                            }
                            catch (Exception e) {
                                CookieCutter.LOG.debug((Throwable)e);
                            }
lbl139:
                            // 10 sources

                            var6_6 = null;
                            tokenstart = -1;
                            var8_9 = false;
                            reject = 0;
                            break;
                        }
                        case '\"': {
                            if (tokenstart < 0) {
                                tokenstart = i;
                                inQuoted = true;
                                if (unquoted != null) continue block33;
                                unquoted = new StringBuilder();
                                break;
                            }
                            if (this._compliance == CookieCompliance.RFC6265) {
                                reject = 1;
                                break;
                            }
                        }
                        default: {
                            if (this._compliance == CookieCompliance.RFC6265 && quoted) {
                                reject = 1;
                                break;
                            }
                            if (quoted) {
                                unquoted.append(hdr, tokenstart, i--);
                                inQuoted = true;
                                quoted = false;
                                break;
                            }
                            if (this._compliance == CookieCompliance.RFC6265_LEGACY && this.isRFC6265RejectedCharacter(inQuoted, c)) {
                                reject = 1;
                            }
                            if (tokenstart < 0) {
                                tokenstart = i;
                            }
                            tokenend = i;
                            break;
                        }
                    }
                    continue;
                }
                switch (c) {
                    case '\t': 
                    case ' ': {
                        continue block33;
                    }
                    case ';': {
                        tokenstart = -1;
                        var8_9 = false;
                        reject = 0;
                        continue block33;
                    }
                    case '=': {
                        if (quoted) {
                            var6_6 = unquoted.toString();
                            unquoted.setLength(0);
                            quoted = false;
                        } else if (tokenstart >= 0) {
                            var6_6 = tokenend >= tokenstart ? hdr.substring(tokenstart, tokenend + 1) : hdr.substring(tokenstart);
                        }
                        tokenstart = -1;
                        var8_9 = true;
                        continue block33;
                    }
                    default: {
                        if (quoted) {
                            unquoted.append(hdr, tokenstart, i--);
                            inQuoted = true;
                            quoted = false;
                            continue block33;
                        }
                        if (this._compliance != CookieCompliance.RFC2965 && this.isRFC6265RejectedCharacter(inQuoted, c)) {
                            reject = 1;
                        }
                        if (tokenstart < 0) {
                            tokenstart = i;
                        }
                        tokenend = i;
                    }
                }
            }
        }
        this._cookies = var1_1.toArray(new Cookie[0]);
        this._lastCookies = this._cookies;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isRFC6265RejectedCharacter(boolean inQuoted, char c) {
        void var2_2;
        if (this._compliance == CookieCompliance.RFC6265_LEGACY) {
            void var1_1;
            if (var1_1 != false) {
                return Character.isISOControl(c);
            }
            return Character.isISOControl(c) || c > '\u007f' || c == ',' || c == ';';
        }
        return c > '\u007f' || Character.isISOControl(c) || c == ',' || var2_2 == 92;
    }
}

