/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

@Deprecated
@ManagedObject(value="Connector Statistics")
public class ConnectorStatistics
extends AbstractLifeCycle
implements Connection.Listener,
Dumpable {
    private static final Sample ZERO = new Sample();
    private final AtomicLong _startMillis = new AtomicLong(-1L);
    private final CounterStatistic _connectionStats = new CounterStatistic();
    private final SampleStatistic _messagesIn = new SampleStatistic();
    private final SampleStatistic _messagesOut = new SampleStatistic();
    private final SampleStatistic _connectionDurationStats = new SampleStatistic();
    private final ConcurrentMap<Connection, Sample> _samples = new ConcurrentHashMap<Connection, Sample>();
    private final LongAdder _closedIn = new LongAdder();
    private final LongAdder _closedOut = new LongAdder();
    private AtomicLong _nanoStamp = new AtomicLong();
    private volatile int _messagesInPerSecond;
    private volatile int _messagesOutPerSecond;
    private static final long SECOND_NANOS = TimeUnit.SECONDS.toNanos(1L);

    /*
     * WARNING - void declaration
     */
    public void onOpened(Connection connection) {
        if (this.isStarted()) {
            void var1_1;
            this._connectionStats.increment();
            this._samples.put((Connection)var1_1, ZERO);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onClosed(Connection connection) {
        if (this.isStarted()) {
            long msgsIn = connection.getMessagesIn();
            long msgsOut = connection.getMessagesOut();
            this._messagesIn.record(msgsIn);
            this._messagesOut.record(msgsOut);
            this._connectionStats.decrement();
            this._connectionDurationStats.record(System.currentTimeMillis() - connection.getCreatedTimeStamp());
            Sample sample = (Sample)this._samples.remove(connection);
            if (sample != null) {
                void var1_1;
                void var2_2;
                this._closedIn.add((long)(var2_2 - sample._messagesIn));
                this._closedOut.add(msgsOut - var1_1._messagesOut);
            }
        }
    }

    @ManagedAttribute(value="Total number of bytes received by this connector")
    public int getBytesIn() {
        return -1;
    }

    @ManagedAttribute(value="Total number of bytes sent by this connector")
    public int getBytesOut() {
        return -1;
    }

    @ManagedAttribute(value="Total number of connections seen by this connector")
    public int getConnections() {
        return (int)this._connectionStats.getTotal();
    }

    @ManagedAttribute(value="Connection duration maximum in ms")
    public long getConnectionDurationMax() {
        return this._connectionDurationStats.getMax();
    }

    @ManagedAttribute(value="Connection duration mean in ms")
    public double getConnectionDurationMean() {
        return this._connectionDurationStats.getMean();
    }

    @ManagedAttribute(value="Connection duration standard deviation")
    public double getConnectionDurationStdDev() {
        return this._connectionDurationStats.getStdDev();
    }

    @ManagedAttribute(value="Messages In for all connections")
    public int getMessagesIn() {
        return (int)this._messagesIn.getTotal();
    }

    @ManagedAttribute(value="Messages In per connection maximum")
    public int getMessagesInPerConnectionMax() {
        return (int)this._messagesIn.getMax();
    }

    @ManagedAttribute(value="Messages In per connection mean")
    public double getMessagesInPerConnectionMean() {
        return this._messagesIn.getMean();
    }

    @ManagedAttribute(value="Messages In per connection standard deviation")
    public double getMessagesInPerConnectionStdDev() {
        return this._messagesIn.getStdDev();
    }

    @ManagedAttribute(value="Connections open")
    public int getConnectionsOpen() {
        return (int)this._connectionStats.getCurrent();
    }

    @ManagedAttribute(value="Connections open maximum")
    public int getConnectionsOpenMax() {
        return (int)this._connectionStats.getMax();
    }

    @ManagedAttribute(value="Messages Out for all connections")
    public int getMessagesOut() {
        return (int)this._messagesIn.getTotal();
    }

    @ManagedAttribute(value="Messages In per connection maximum")
    public int getMessagesOutPerConnectionMax() {
        return (int)this._messagesIn.getMax();
    }

    @ManagedAttribute(value="Messages In per connection mean")
    public double getMessagesOutPerConnectionMean() {
        return this._messagesIn.getMean();
    }

    @ManagedAttribute(value="Messages In per connection standard deviation")
    public double getMessagesOutPerConnectionStdDev() {
        return this._messagesIn.getStdDev();
    }

    /*
     * WARNING - void declaration
     */
    @ManagedAttribute(value="Connection statistics started ms since epoch")
    public long getStartedMillis() {
        void var1_1;
        long start = this._startMillis.get();
        if (start < 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - var1_1;
    }

    @ManagedAttribute(value="Messages in per second calculated over period since last called")
    public int getMessagesInPerSecond() {
        this.update();
        return this._messagesInPerSecond;
    }

    @ManagedAttribute(value="Messages out per second calculated over period since last called")
    public int getMessagesOutPerSecond() {
        this.update();
        return this._messagesOutPerSecond;
    }

    public void doStart() {
        this.reset();
    }

    public void doStop() {
        this._samples.clear();
    }

    @ManagedOperation(value="Reset the statistics")
    public void reset() {
        this._startMillis.set(System.currentTimeMillis());
        this._messagesIn.reset();
        this._messagesOut.reset();
        this._connectionStats.reset();
        this._connectionDurationStats.reset();
        this._samples.clear();
    }

    @ManagedOperation(value="dump thread state")
    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        Dumpable.dumpObjects((Appendable)out, (String)var2_2, (Object)((Object)this), (Object[])new Object[]{"connections=" + this._connectionStats, "duration=" + this._connectionDurationStats, "in=" + this._messagesIn, "out=" + this._messagesOut});
    }

    /*
     * WARNING - void declaration
     */
    public static void addToAllConnectors(Server server) {
        for (Connector connector : server.getConnectors()) {
            void var3_3;
            if (!(connector instanceof Container)) continue;
            var3_3.addBean((Object)new ConnectorStatistics());
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void update() {
        void var1_1;
        long then;
        long now = System.nanoTime();
        long duration = now - (then = this._nanoStamp.get());
        if (duration > SECOND_NANOS / 2L && this._nanoStamp.compareAndSet(then, (long)var1_1)) {
            long msgsIn = this._closedIn.sumThenReset();
            long msgsOut = this._closedOut.sumThenReset();
            for (Map.Entry entry : this._samples.entrySet()) {
                void var2_8;
                Sample next;
                void var3_4;
                Connection connection = (Connection)entry.getKey();
                Sample sample = (Sample)entry.getValue();
                if (!this._samples.replace((Connection)var3_4, sample, next = new Sample(connection))) continue;
                msgsIn += next._messagesIn - sample._messagesIn;
                msgsOut += next._messagesOut - var2_8._messagesOut;
            }
            this._messagesInPerSecond = (int)(msgsIn * SECOND_NANOS / duration);
            this._messagesOutPerSecond = (int)(msgsOut * SECOND_NANOS / duration);
        }
    }

    private static class Sample {
        final long _messagesIn;
        final long _messagesOut;

        Sample() {
            this._messagesIn = 0L;
            this._messagesOut = 0L;
        }

        /*
         * WARNING - void declaration
         */
        Sample(Connection connection) {
            void var1_1;
            this._messagesIn = connection.getMessagesIn();
            this._messagesOut = var1_1.getMessagesOut();
        }
    }
}

