/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class ConnectionLimit
extends AbstractLifeCycle
implements Connection.Listener,
SelectorManager.AcceptListener {
    private static final Logger LOG = Log.getLogger(ConnectionLimit.class);
    private final Server _server;
    private final List<AbstractConnector> _connectors = new ArrayList<AbstractConnector>();
    private final Set<SelectableChannel> _accepting = new HashSet<SelectableChannel>();
    private int _connections;
    private int _maxConnections;
    private long _idleTimeout;
    private boolean _limiting = false;

    /*
     * WARNING - void declaration
     */
    public ConnectionLimit(@Name(value="maxConnections") int maxConnections, @Name(value="server") Server server) {
        void var2_2;
        void var1_1;
        this._maxConnections = var1_1;
        this._server = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionLimit(@Name(value="maxConnections") int maxConnections, Connector ... connectors) {
        this((int)var1_1, (Server)null);
        void var2_3;
        void var1_1;
        for (void c : var2_3) {
            if (c instanceof AbstractConnector) {
                this._connectors.add((AbstractConnector)c);
                continue;
            }
            LOG.warn("Connector {} is not an AbstractConnection. Connections not limited", new Object[]{c});
        }
    }

    @ManagedAttribute(value="The endpoint idle timeout in ms to apply when the connection limit is reached")
    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setIdleTimeout(long idleTimeout) {
        void var1_1;
        this._idleTimeout = var1_1;
    }

    @ManagedAttribute(value="The maximum number of connections allowed")
    public int getMaxConnections() {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            return this._maxConnections;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxConnections(int max) {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            void var1_1;
            this._maxConnections = var1_1;
            return;
        }
    }

    @ManagedAttribute(value="The current number of connections ")
    public int getConnections() {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            return this._connections;
        }
    }

    protected void doStart() throws Exception {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            if (this._server != null) {
                for (Connector c : this._server.getConnectors()) {
                    if (c instanceof AbstractConnector) {
                        this._connectors.add((AbstractConnector)c);
                        continue;
                    }
                    LOG.warn("Connector {} is not an AbstractConnector. Connections not limited", new Object[]{c});
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("ConnectionLimit {} for {}", new Object[]{this._maxConnections, this._connectors});
            }
            this._connections = 0;
            this._limiting = false;
            for (AbstractConnector abstractConnector : this._connectors) {
                abstractConnector.addBean((Object)this);
            }
            return;
        }
    }

    protected void doStop() throws Exception {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            for (AbstractConnector abstractConnector : this._connectors) {
                abstractConnector.removeBean((Object)this);
            }
            this._connections = 0;
            if (this._server != null) {
                this._connectors.clear();
            }
            return;
        }
    }

    protected void check() {
        if (this._accepting.size() + this._connections >= this._maxConnections) {
            if (!this._limiting) {
                this._limiting = true;
                LOG.info("Connection Limit({}) reached for {}", new Object[]{this._maxConnections, this._connectors});
                this.limit();
                return;
            }
        } else if (this._limiting) {
            this._limiting = false;
            LOG.info("Connection Limit({}) cleared for {}", new Object[]{this._maxConnections, this._connectors});
            this.unlimit();
        }
    }

    protected void limit() {
        for (AbstractConnector c : this._connectors) {
            Iterator<EndPoint> iterator;
            c.setAccepting(false);
            if (this._idleTimeout <= 0L) continue;
            for (EndPoint endPoint : ((AbstractConnector)((Object)iterator)).getConnectedEndPoints()) {
                endPoint.setIdleTimeout(this._idleTimeout);
            }
        }
    }

    protected void unlimit() {
        for (AbstractConnector c : this._connectors) {
            c.setAccepting(true);
            if (this._idleTimeout <= 0L) continue;
            for (EndPoint endPoint : c.getConnectedEndPoints()) {
                endPoint.setIdleTimeout(c.getIdleTimeout());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onAccepting(SelectableChannel channel) {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            this._accepting.add(channel);
            if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug("onAccepting ({}+{}) < {} {}", new Object[]{this._accepting.size(), this._connections, this._maxConnections, var1_1});
            }
            this.check();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onAcceptFailed(SelectableChannel channel, Throwable cause) {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            this._accepting.remove(channel);
            if (LOG.isDebugEnabled()) {
                void var2_3;
                void var1_1;
                LOG.debug("onAcceptFailed ({}+{}) < {} {} {}", new Object[]{this._accepting.size(), this._connections, this._maxConnections, var1_1, var2_3});
            }
            this.check();
            return;
        }
    }

    public void onAccepted(SelectableChannel channel) {
    }

    /*
     * WARNING - void declaration
     */
    public void onOpened(Connection connection) {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            this._accepting.remove(connection.getEndPoint().getTransport());
            ++this._connections;
            if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug("onOpened ({}+{}) < {} {}", new Object[]{this._accepting.size(), this._connections, this._maxConnections, var1_1});
            }
            this.check();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onClosed(Connection connection) {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            --this._connections;
            if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug("onClosed ({}+{}) < {} {}", new Object[]{this._accepting.size(), this._connections, this._maxConnections, var1_1});
            }
            this.check();
            return;
        }
    }
}

