/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.URLClassLoader;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;

public class ClassLoaderDump
implements Dumpable {
    final ClassLoader _loader;

    /*
     * WARNING - void declaration
     */
    public ClassLoaderDump(ClassLoader loader) {
        void var1_1;
        this._loader = var1_1;
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var3_4;
        void var2_2;
        void var1_1;
        if (this._loader == null) {
            out.append("No ClassLoader\n");
            return;
        }
        if (this._loader instanceof Dumpable) {
            ((Dumpable)this._loader).dump(out, indent);
            return;
        }
        if (this._loader instanceof URLClassLoader) {
            String loader = this._loader.toString();
            DumpableCollection urls = DumpableCollection.fromArray((String)"URLs", (Object[])((URLClassLoader)this._loader).getURLs());
            ClassLoader parent = this._loader.getParent();
            if (parent == null) {
                Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{urls});
                return;
            }
            if (parent == Server.class.getClassLoader()) {
                Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{urls, parent.toString()});
                return;
            }
            if (parent instanceof Dumpable) {
                Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{urls, parent});
                return;
            }
            Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{urls, new ClassLoaderDump(parent)});
            return;
        }
        String loader = this._loader.toString();
        ClassLoader parent = this._loader.getParent();
        if (parent == null) {
            Dumpable.dumpObject((Appendable)out, (Object)loader);
        }
        if (parent == Server.class.getClassLoader()) {
            Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{parent.toString()});
            return;
        }
        if (parent instanceof Dumpable) {
            Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{parent});
            return;
        }
        if (parent == null) return;
        Dumpable.dumpObjects((Appendable)var1_1, (String)var2_2, (Object)var3_4, (Object[])new Object[]{new ClassLoaderDump(parent)});
    }
}

