/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.PrecompressedHttpContent;
import org.eclipse.jetty.http.ResourceHttpContent;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class CachedContentFactory
implements HttpContent.ContentFactory {
    private static final Logger LOG = Log.getLogger(CachedContentFactory.class);
    private static final Map<CompressedContentFormat, CachedPrecompressedHttpContent> NO_PRECOMPRESSED = Collections.unmodifiableMap(Collections.emptyMap());
    private final ConcurrentMap<String, CachedHttpContent> _cache;
    private final AtomicInteger _cachedSize;
    private final AtomicInteger _cachedFiles;
    private final ResourceFactory _factory;
    private final CachedContentFactory _parent;
    private final MimeTypes _mimeTypes;
    private final boolean _etags;
    private final CompressedContentFormat[] _precompressedFormats;
    private final boolean _useFileMappedBuffer;
    private int _maxCachedFileSize = 0x8000000;
    private int _maxCachedFiles = 2048;
    private int _maxCacheSize = 0x10000000;

    /*
     * WARNING - void declaration
     */
    public CachedContentFactory(CachedContentFactory parent, ResourceFactory factory, MimeTypes mimeTypes, boolean useFileMappedBuffer, boolean etags, CompressedContentFormat[] precompressedFormats) {
        void var1_1;
        void var3_3;
        void var2_2;
        this._factory = var2_2;
        this._cache = new ConcurrentHashMap<String, CachedHttpContent>();
        this._cachedSize = new AtomicInteger();
        this._cachedFiles = new AtomicInteger();
        this._mimeTypes = var3_3;
        this._parent = var1_1;
        this._useFileMappedBuffer = useFileMappedBuffer;
        this._etags = etags;
        this._precompressedFormats = precompressedFormats;
    }

    public int getCachedSize() {
        return this._cachedSize.get();
    }

    public int getCachedFiles() {
        return this._cachedFiles.get();
    }

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxCachedFileSize(int maxCachedFileSize) {
        void var1_1;
        this._maxCachedFileSize = var1_1;
        this.shrinkCache();
    }

    public int getMaxCacheSize() {
        return this._maxCacheSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxCacheSize(int maxCacheSize) {
        void var1_1;
        this._maxCacheSize = var1_1;
        this.shrinkCache();
    }

    public int getMaxCachedFiles() {
        return this._maxCachedFiles;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxCachedFiles(int maxCachedFiles) {
        void var1_1;
        this._maxCachedFiles = var1_1;
        this.shrinkCache();
    }

    public boolean isUseFileMappedBuffer() {
        return this._useFileMappedBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public void flushCache() {
        while (this._cache.size() > 0) {
            for (String path : this._cache.keySet()) {
                void var2_2;
                CachedHttpContent content = (CachedHttpContent)this._cache.remove(path);
                if (content == null) continue;
                var2_2.invalidate();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpContent lookup(String pathInContext) throws IOException {
        void var1_1;
        return this.getContent((String)var1_1, this._maxCachedFileSize);
    }

    /*
     * WARNING - void declaration
     */
    public HttpContent getContent(String pathInContext, int maxBufferSize) throws IOException {
        void var2_2;
        HttpContent httpContent;
        CachedHttpContent content = (CachedHttpContent)this._cache.get(pathInContext);
        if (content != null && content.isValid()) {
            return content;
        }
        Resource resource = this._factory.getResource(pathInContext);
        HttpContent loaded = this.load(pathInContext, resource, maxBufferSize);
        if (loaded != null) {
            void var3_3;
            return var3_3;
        }
        if (this._parent != null && (httpContent = this._parent.getContent(pathInContext, (int)var2_2)) != null) {
            void var1_1;
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isCacheable(Resource resource) {
        void var2_2;
        void var1_1;
        if (this._maxCachedFiles <= 0) {
            return false;
        }
        long len = var1_1.length();
        return len > 0L && (this._useFileMappedBuffer || len < (long)this._maxCachedFileSize && var2_2 < (long)this._maxCacheSize);
    }

    /*
     * WARNING - void declaration
     */
    private HttpContent load(String pathInContext, Resource resource, int maxBufferSize) {
        void var2_2;
        void var3_3;
        if (resource == null || !resource.exists()) {
            return null;
        }
        if (resource.isDirectory()) {
            return new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()), this.getMaxCachedFileSize());
        }
        if (this.isCacheable(resource)) {
            CachedHttpContent content;
            if (this._precompressedFormats.length > 0) {
                HashMap<CompressedContentFormat, CachedHttpContent> precompresssedContents = new HashMap<CompressedContentFormat, CachedHttpContent>(this._precompressedFormats.length);
                CompressedContentFormat[] compressedContentFormatArray = this._precompressedFormats;
                int n = this._precompressedFormats.length;
                for (int i = 0; i < n; ++i) {
                    CompressedContentFormat format = compressedContentFormatArray[i];
                    String compressedPathInContext = pathInContext + format.getExtension();
                    CachedHttpContent compressedContent = (CachedHttpContent)this._cache.get(compressedPathInContext);
                    if (compressedContent == null || compressedContent.isValid()) {
                        CachedHttpContent added;
                        compressedContent = null;
                        Resource compressedResource = this._factory.getResource(compressedPathInContext);
                        if (compressedResource.exists() && compressedResource.lastModified() >= resource.lastModified() && compressedResource.length() < resource.length() && (added = this._cache.putIfAbsent(compressedPathInContext, compressedContent = new CachedHttpContent(compressedPathInContext, compressedResource, null))) != null) {
                            void var3_4;
                            compressedContent.invalidate();
                            compressedContent = var3_4;
                        }
                    }
                    if (compressedContent == null) continue;
                    precompresssedContents.put(format, compressedContent);
                }
                content = new CachedHttpContent(pathInContext, resource, precompresssedContents);
            } else {
                content = new CachedHttpContent(pathInContext, resource, null);
            }
            CachedHttpContent added = this._cache.putIfAbsent(pathInContext, content);
            if (added != null) {
                content.invalidate();
                content = added;
            }
            return content;
        }
        String mt = this._mimeTypes.getMimeByExtension(pathInContext);
        if (this._precompressedFormats.length > 0) {
            HashMap<CompressedContentFormat, CachedHttpContent> compressedContents = new HashMap<CompressedContentFormat, CachedHttpContent>();
            CompressedContentFormat[] compressedContentFormatArray = this._precompressedFormats;
            int n = this._precompressedFormats.length;
            for (int i = 0; i < n; ++i) {
                Resource compressedResource;
                CompressedContentFormat format = compressedContentFormatArray[i];
                String compressedPathInContext = pathInContext + format.getExtension();
                CachedHttpContent compressedContent = (CachedHttpContent)this._cache.get(compressedPathInContext);
                if (compressedContent != null && compressedContent.isValid() && compressedContent.getResource().lastModified() >= resource.lastModified()) {
                    compressedContents.put(format, compressedContent);
                }
                if (!(compressedResource = this._factory.getResource(compressedPathInContext)).exists() || compressedResource.lastModified() < resource.lastModified() || compressedResource.length() >= resource.length()) continue;
                compressedContents.put(format, (CachedHttpContent)new ResourceHttpContent(compressedResource, this._mimeTypes.getMimeByExtension(compressedPathInContext), (int)var3_3));
            }
            if (!compressedContents.isEmpty()) {
                return new ResourceHttpContent(resource, mt, (int)var3_3, compressedContents);
            }
        }
        return new ResourceHttpContent((Resource)var2_2, mt, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void shrinkCache() {
        block0: while (this._cache.size() > 0 && (this._cachedFiles.get() > this._maxCachedFiles || this._cachedSize.get() > this._maxCacheSize)) {
            Iterator iterator;
            TreeSet sorted = new TreeSet((c1, c2) -> {
                void var1_1;
                CachedHttpContent cachedHttpContent;
                if (((CachedHttpContent)c1)._lastAccessed < ((CachedHttpContent)c2)._lastAccessed) {
                    return -1;
                }
                if (((CachedHttpContent)c1)._lastAccessed > ((CachedHttpContent)c2)._lastAccessed) {
                    return 1;
                }
                if (((CachedHttpContent)c1)._contentLengthValue < ((CachedHttpContent)c2)._contentLengthValue) {
                    return -1;
                }
                return cachedHttpContent._key.compareTo(((CachedHttpContent)var1_1)._key);
            });
            sorted.addAll(this._cache.values());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                CachedHttpContent content = (CachedHttpContent)iterator.next();
                if (this._cachedFiles.get() <= this._maxCachedFiles && this._cachedSize.get() <= this._maxCacheSize) continue block0;
                if (content != this._cache.remove(content.getKey())) continue;
                var2_2.invalidate();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuffer getIndirectBuffer(Resource resource) {
        try {
            return BufferUtil.toBuffer((Resource)resource, (boolean)false);
        }
        catch (IOException | IllegalArgumentException e) {
            if (LOG.isDebugEnabled()) {
                void var1_2;
                LOG.debug((Throwable)var1_2);
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuffer getMappedBuffer(Resource resource) {
        block3: {
            try {
                if (this._useFileMappedBuffer && resource.getFile() != null && resource.length() < Integer.MAX_VALUE) {
                    return BufferUtil.toMappedBuffer((File)resource.getFile());
                }
            }
            catch (IOException | IllegalArgumentException e) {
                void var1_2;
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Throwable)var1_2);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuffer getDirectBuffer(Resource resource) {
        try {
            return BufferUtil.toBuffer((Resource)resource, (boolean)true);
        }
        catch (IOException | IllegalArgumentException e) {
            if (LOG.isDebugEnabled()) {
                void var1_2;
                LOG.debug((Throwable)var1_2);
            }
            return null;
        }
    }

    public String toString() {
        return "ResourceCache[" + this._parent + "," + this._factory + "]@" + this.hashCode();
    }

    public class CachedPrecompressedHttpContent
    extends PrecompressedHttpContent {
        private final CachedHttpContent _content;
        private final CachedHttpContent _precompressedContent;
        private final HttpField _etag;

        /*
         * WARNING - void declaration
         */
        CachedPrecompressedHttpContent(CachedHttpContent content, CachedHttpContent precompressedContent, CompressedContentFormat format) {
            void var1_1;
            void var3_3;
            void var2_2;
            super((HttpContent)content, (HttpContent)precompressedContent, format);
            this._content = var2_2;
            this._precompressedContent = var3_3;
            this._etag = ((CachedContentFactory)var1_1)._etags ? new PreEncodedHttpField(HttpHeader.ETAG, this._content.getResource().getWeakETag(format.getEtagSuffix())) : null;
        }

        public boolean isValid() {
            return this._precompressedContent.isValid() && this._content.isValid() && this._content.getResource().lastModified() <= this._precompressedContent.getResource().lastModified();
        }

        public HttpField getETag() {
            if (this._etag != null) {
                return this._etag;
            }
            return super.getETag();
        }

        public String getETagValue() {
            if (this._etag != null) {
                return this._etag.getValue();
            }
            return super.getETagValue();
        }

        public String toString() {
            return "Cached" + super.toString();
        }
    }

    public class CachedHttpContent
    implements HttpContent {
        private final String _key;
        private final Resource _resource;
        private final long _contentLengthValue;
        private final HttpField _contentType;
        private final String _characterEncoding;
        private final MimeTypes.Type _mimeType;
        private final HttpField _contentLength;
        private final HttpField _lastModified;
        private final long _lastModifiedValue;
        private final HttpField _etag;
        private final Map<CompressedContentFormat, CachedPrecompressedHttpContent> _precompressed;
        private final AtomicReference<ByteBuffer> _indirectBuffer = new AtomicReference();
        private final AtomicReference<ByteBuffer> _directBuffer = new AtomicReference();
        private final AtomicReference<ByteBuffer> _mappedBuffer = new AtomicReference();
        private volatile long _lastAccessed;

        /*
         * WARNING - void declaration
         */
        CachedHttpContent(String pathInContext, Resource resource, Map<CompressedContentFormat, CachedHttpContent> precompressedResources) {
            void var2_3;
            this._key = pathInContext;
            this._resource = resource;
            String contentType = CachedContentFactory.this._mimeTypes.getMimeByExtension(this._resource.toString());
            this._contentType = contentType == null ? null : new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, contentType);
            this._characterEncoding = this._contentType == null ? null : MimeTypes.getCharsetFromContentType((String)contentType);
            this._mimeType = this._contentType == null ? null : (MimeTypes.Type)MimeTypes.CACHE.get(MimeTypes.getContentTypeWithoutCharset((String)contentType));
            boolean exists = resource.exists();
            this._lastModifiedValue = exists ? resource.lastModified() : -1L;
            this._lastModified = this._lastModifiedValue == -1L ? null : new PreEncodedHttpField(HttpHeader.LAST_MODIFIED, DateGenerator.formatDate((long)this._lastModifiedValue));
            this._contentLengthValue = var2_3 != false ? resource.length() : 0L;
            this._contentLength = new PreEncodedHttpField(HttpHeader.CONTENT_LENGTH, Long.toString(this._contentLengthValue));
            if (CachedContentFactory.this._cachedFiles.incrementAndGet() > CachedContentFactory.this._maxCachedFiles) {
                CachedContentFactory.this.shrinkCache();
            }
            this._lastAccessed = System.currentTimeMillis();
            PreEncodedHttpField preEncodedHttpField = this._etag = CachedContentFactory.this._etags ? new PreEncodedHttpField(HttpHeader.ETAG, resource.getWeakETag()) : null;
            if (precompressedResources != null) {
                this._precompressed = new HashMap<CompressedContentFormat, CachedPrecompressedHttpContent>(precompressedResources.size());
                for (Map.Entry<CompressedContentFormat, CachedHttpContent> entry : precompressedResources.entrySet()) {
                    void var3_5;
                    this._precompressed.put(entry.getKey(), new CachedPrecompressedHttpContent(this, entry.getValue(), (CompressedContentFormat)var3_5.getKey()));
                }
                return;
            }
            this._precompressed = NO_PRECOMPRESSED;
        }

        public String getKey() {
            return this._key;
        }

        public boolean isCached() {
            return this._key != null;
        }

        public Resource getResource() {
            return this._resource;
        }

        public HttpField getETag() {
            return this._etag;
        }

        public String getETagValue() {
            return this._etag.getValue();
        }

        boolean isValid() {
            if (this._lastModifiedValue == this._resource.lastModified() && this._contentLengthValue == this._resource.length()) {
                this._lastAccessed = System.currentTimeMillis();
                return true;
            }
            CachedHttpContent cachedHttpContent = this;
            if (cachedHttpContent == cachedHttpContent.CachedContentFactory.this._cache.remove(this._key)) {
                this.invalidate();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        protected void invalidate() {
            ByteBuffer direct;
            ByteBuffer indirect = this._indirectBuffer.getAndSet(null);
            if (indirect != null) {
                CachedContentFactory.this._cachedSize.addAndGet(-BufferUtil.length((ByteBuffer)indirect));
            }
            if ((direct = (ByteBuffer)this._directBuffer.getAndSet(null)) != null) {
                void var1_1;
                CachedContentFactory.this._cachedSize.addAndGet(-BufferUtil.length((ByteBuffer)var1_1));
            }
            this._mappedBuffer.getAndSet(null);
            CachedContentFactory.this._cachedFiles.decrementAndGet();
            this._resource.close();
        }

        public HttpField getLastModified() {
            return this._lastModified;
        }

        public String getLastModifiedValue() {
            if (this._lastModified == null) {
                return null;
            }
            return this._lastModified.getValue();
        }

        public HttpField getContentType() {
            return this._contentType;
        }

        public String getContentTypeValue() {
            if (this._contentType == null) {
                return null;
            }
            return this._contentType.getValue();
        }

        public HttpField getContentEncoding() {
            return null;
        }

        public String getContentEncodingValue() {
            return null;
        }

        public String getCharacterEncoding() {
            return this._characterEncoding;
        }

        public MimeTypes.Type getMimeType() {
            return this._mimeType;
        }

        public void release() {
        }

        public ByteBuffer getIndirectBuffer() {
            ByteBuffer byteBuffer;
            if (this._resource.length() > (long)CachedContentFactory.this._maxCachedFileSize) {
                return null;
            }
            ByteBuffer buffer = this._indirectBuffer.get();
            if (buffer == null) {
                ByteBuffer buffer2 = CachedContentFactory.this.getIndirectBuffer(this._resource);
                if (buffer2 == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not load indirect buffer from " + this, new Object[0]);
                    }
                    return null;
                }
                if (this._indirectBuffer.compareAndSet(null, buffer2)) {
                    if (CachedContentFactory.this._cachedSize.addAndGet(BufferUtil.length((ByteBuffer)byteBuffer)) > CachedContentFactory.this._maxCacheSize) {
                        CachedContentFactory.this.shrinkCache();
                    }
                } else {
                    byteBuffer = this._indirectBuffer.get();
                }
            }
            if (byteBuffer == null) {
                return null;
            }
            return byteBuffer.asReadOnlyBuffer();
        }

        /*
         * WARNING - void declaration
         */
        public ByteBuffer getDirectBuffer() {
            void var1_1;
            ByteBuffer buffer = this._mappedBuffer.get();
            if (buffer == null) {
                buffer = this._directBuffer.get();
            }
            if (buffer == null) {
                ByteBuffer mapped = CachedContentFactory.this.getMappedBuffer(this._resource);
                if (mapped != null) {
                    buffer = this._mappedBuffer.compareAndSet(null, mapped) ? mapped : this._mappedBuffer.get();
                } else if (this._resource.length() < (long)CachedContentFactory.this._maxCachedFileSize) {
                    ByteBuffer direct = CachedContentFactory.this.getDirectBuffer(this._resource);
                    if (direct != null) {
                        if (this._directBuffer.compareAndSet(null, direct)) {
                            void var2_2;
                            buffer = var2_2;
                            if (CachedContentFactory.this._cachedSize.addAndGet(BufferUtil.length((ByteBuffer)buffer)) > CachedContentFactory.this._maxCacheSize) {
                                CachedContentFactory.this.shrinkCache();
                            }
                        } else {
                            buffer = this._directBuffer.get();
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not load " + this, new Object[0]);
                    }
                }
            }
            if (buffer == null) {
                return null;
            }
            return var1_1.asReadOnlyBuffer();
        }

        public HttpField getContentLength() {
            return this._contentLength;
        }

        public long getContentLengthValue() {
            return this._contentLengthValue;
        }

        /*
         * WARNING - void declaration
         */
        public InputStream getInputStream() throws IOException {
            ByteBuffer indirect = this.getIndirectBuffer();
            if (indirect != null && indirect.hasArray()) {
                void var1_1;
                return new ByteArrayInputStream(indirect.array(), indirect.arrayOffset() + indirect.position(), var1_1.remaining());
            }
            return this._resource.getInputStream();
        }

        public ReadableByteChannel getReadableByteChannel() throws IOException {
            return this._resource.getReadableByteChannel();
        }

        public String toString() {
            return String.format("CachedContent@%x{r=%s,e=%b,lm=%s,ct=%s,c=%d}", this.hashCode(), this._resource, this._resource.exists(), this._lastModified, this._contentType, this._precompressed.size());
        }

        /*
         * WARNING - void declaration
         */
        public Map<CompressedContentFormat, ? extends HttpContent> getPrecompressedContents() {
            void var1_1;
            if (this._precompressed.size() == 0) {
                return null;
            }
            Map<CompressedContentFormat, CachedPrecompressedHttpContent> ret = this._precompressed;
            for (Map.Entry<CompressedContentFormat, CachedPrecompressedHttpContent> entry : this._precompressed.entrySet()) {
                void var3_3;
                if (entry.getValue().isValid()) continue;
                if (ret == this._precompressed) {
                    ret = new HashMap<CompressedContentFormat, CachedPrecompressedHttpContent>(this._precompressed);
                }
                ret.remove(var3_3.getKey());
            }
            return var1_1;
        }
    }
}

