/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AsyncRequestLogWriter
extends RequestLogWriter {
    private static final Logger LOG = Log.getLogger(AsyncRequestLogWriter.class);
    private final BlockingQueue<String> _queue;
    private transient WriterThread _thread;
    private boolean _warnedFull;

    public AsyncRequestLogWriter() {
        this(null, null);
    }

    /*
     * WARNING - void declaration
     */
    public AsyncRequestLogWriter(String filename) {
        this((String)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsyncRequestLogWriter(String filename, BlockingQueue<String> queue) {
        super((String)var1_1);
        void var2_2;
        void var1_1;
        if (queue == null) {
            queue = new BlockingArrayQueue(1024);
        }
        this._queue = var2_2;
    }

    @Override
    protected synchronized void doStart() throws Exception {
        super.doStart();
        this._thread = new WriterThread();
        this._thread.start();
    }

    @Override
    protected void doStop() throws Exception {
        this._thread.interrupt();
        this._thread.join();
        super.doStop();
        this._thread = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(String log) throws IOException {
        void var1_1;
        if (!this._queue.offer((String)var1_1)) {
            if (this._warnedFull) {
                LOG.warn("Log Queue overflow", new Object[0]);
            }
            this._warnedFull = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$101(AsyncRequestLogWriter x0, String x1) throws IOException {
        void var1_1;
        super.write((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$201(AsyncRequestLogWriter x0, String x1) throws IOException {
        void var1_1;
        super.write((String)var1_1);
    }

    private class WriterThread
    extends Thread {
        WriterThread() {
            this.setName("AsyncRequestLogWriter@" + Integer.toString(AsyncRequestLogWriter.this.hashCode(), 16));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            while (AsyncRequestLogWriter.this.isRunning()) {
                try {
                    String log = (String)AsyncRequestLogWriter.this._queue.poll(10L, TimeUnit.SECONDS);
                    if (log != null) {
                        AsyncRequestLogWriter.access$101(AsyncRequestLogWriter.this, log);
                    }
                    while (!AsyncRequestLogWriter.this._queue.isEmpty()) {
                        log = (String)AsyncRequestLogWriter.this._queue.poll();
                        if (log == null) continue;
                        AsyncRequestLogWriter.access$201(AsyncRequestLogWriter.this, log);
                    }
                }
                catch (InterruptedException e) {
                    LOG.ignore((Throwable)e);
                }
                catch (Throwable t) {
                    void var1_3;
                    LOG.warn((Throwable)var1_3);
                }
            }
        }
    }
}

