/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.handler.ContextHandler;

public class AsyncContextState
implements AsyncContext {
    private final HttpChannel _channel;
    volatile HttpChannelState _state;

    /*
     * WARNING - void declaration
     */
    public AsyncContextState(HttpChannelState state) {
        void var1_1;
        this._state = var1_1;
        this._channel = this._state.getHttpChannel();
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    /*
     * WARNING - void declaration
     */
    HttpChannelState state() {
        void var1_1;
        HttpChannelState state = this._state;
        if (state == null) {
            throw new IllegalStateException("AsyncContext completed and/or Request lifecycle recycled");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        void var1_1;
        void var3_3;
        void var2_2;
        WrappedAsyncListener wrap = new WrappedAsyncListener(listener, (ServletRequest)var2_2, (ServletResponse)var3_3);
        this.state().addListener((AsyncListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(AsyncListener listener) {
        void var1_1;
        this.state().addListener((AsyncListener)var1_1);
    }

    public void complete() {
        this.state().complete();
    }

    /*
     * WARNING - void declaration
     */
    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        ContextHandler contextHandler = this.state().getContextHandler();
        if (contextHandler != null) {
            void var2_3;
            return (T)((AsyncListener)var2_3.getServletContext().createListener(clazz));
        }
        try {
            return (T)((AsyncListener)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            void var1_2;
            throw new ServletException((Throwable)var1_2);
        }
    }

    public void dispatch() {
        this.state().dispatch(null, null);
    }

    /*
     * WARNING - void declaration
     */
    public void dispatch(String path) {
        void var1_1;
        this.state().dispatch(null, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void dispatch(ServletContext context, String path) {
        void var2_2;
        void var1_1;
        this.state().dispatch((ServletContext)var1_1, (String)var2_2);
    }

    public ServletRequest getRequest() {
        return this.state().getAsyncContextEvent().getSuppliedRequest();
    }

    public ServletResponse getResponse() {
        return this.state().getAsyncContextEvent().getSuppliedResponse();
    }

    public long getTimeout() {
        return this.state().getTimeout();
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasOriginalRequestAndResponse() {
        void var1_1;
        HttpChannel channel = this.state().getHttpChannel();
        return channel.getRequest() == this.getRequest() && var1_1.getResponse() == this.getResponse();
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeout(long arg0) {
        void var1_1;
        this.state().setTimeout((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void start(Runnable task) {
        void var2_2;
        void var1_1;
        HttpChannel channel = this.state().getHttpChannel();
        channel.execute(new Runnable(this, (Runnable)var1_1, (HttpChannel)var2_2){
            final /* synthetic */ Runnable val$task;
            final /* synthetic */ HttpChannel val$channel;
            final /* synthetic */ AsyncContextState this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$task = runnable;
                this.val$channel = httpChannel;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                void var1_1;
                ContextHandler.Context context = this.this$0.state().getAsyncContextEvent().getContext();
                if (context == null) {
                    this.val$task.run();
                    return;
                }
                var1_1.getContextHandler().handle(this.val$channel.getRequest(), this.val$task);
            }
        });
    }

    public void reset() {
        this._state = null;
    }

    public HttpChannelState getHttpChannelState() {
        return this.state();
    }

    public static class WrappedAsyncListener
    implements AsyncListener {
        private final AsyncListener _listener;
        private final ServletRequest _request;
        private final ServletResponse _response;

        /*
         * WARNING - void declaration
         */
        public WrappedAsyncListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
            void var3_3;
            void var2_2;
            void var1_1;
            this._listener = var1_1;
            this._request = var2_2;
            this._response = var3_3;
        }

        public AsyncListener getListener() {
            return this._listener;
        }

        /*
         * WARNING - void declaration
         */
        public void onTimeout(AsyncEvent event) throws IOException {
            void var1_1;
            this._listener.onTimeout(new AsyncEvent(event.getAsyncContext(), this._request, this._response, var1_1.getThrowable()));
        }

        /*
         * WARNING - void declaration
         */
        public void onStartAsync(AsyncEvent event) throws IOException {
            void var1_1;
            this._listener.onStartAsync(new AsyncEvent(event.getAsyncContext(), this._request, this._response, var1_1.getThrowable()));
        }

        /*
         * WARNING - void declaration
         */
        public void onError(AsyncEvent event) throws IOException {
            void var1_1;
            this._listener.onError(new AsyncEvent(event.getAsyncContext(), this._request, this._response, var1_1.getThrowable()));
        }

        /*
         * WARNING - void declaration
         */
        public void onComplete(AsyncEvent event) throws IOException {
            void var1_1;
            this._listener.onComplete(new AsyncEvent(event.getAsyncContext(), this._request, this._response, var1_1.getThrowable()));
        }
    }
}

