/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.thread.Scheduler;

public class AsyncContextEvent
extends AsyncEvent
implements Runnable {
    private final ContextHandler.Context _context;
    private final AsyncContextState _asyncContext;
    private final HttpChannelState _state;
    private ServletContext _dispatchContext;
    private String _dispatchPath;
    private volatile Scheduler.Task _timeoutTask;
    private Throwable _throwable;

    /*
     * WARNING - void declaration
     */
    public AsyncContextEvent(ContextHandler.Context context, AsyncContextState asyncContext, HttpChannelState state, Request baseRequest, ServletRequest request, ServletResponse response) {
        super(null, request, response, null);
        void var3_3;
        void var2_2;
        void var1_1;
        this._context = var1_1;
        this._asyncContext = var2_2;
        this._state = var3_3;
        baseRequest.setAsyncAttributes();
    }

    public ServletContext getSuspendedContext() {
        return this._context;
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    public ServletContext getDispatchContext() {
        return this._dispatchContext;
    }

    public ServletContext getServletContext() {
        if (this._dispatchContext == null) {
            return this._context;
        }
        return this._dispatchContext;
    }

    public String getPath() {
        return this._dispatchPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeoutTask(Scheduler.Task task) {
        void var1_1;
        this._timeoutTask = var1_1;
    }

    public boolean hasTimeoutTask() {
        return this._timeoutTask != null;
    }

    /*
     * WARNING - void declaration
     */
    public void cancelTimeoutTask() {
        Scheduler.Task task = this._timeoutTask;
        this._timeoutTask = null;
        if (task != null) {
            void var1_1;
            var1_1.cancel();
        }
    }

    public AsyncContext getAsyncContext() {
        return this._asyncContext;
    }

    public Throwable getThrowable() {
        return this._throwable;
    }

    /*
     * WARNING - void declaration
     */
    public void setDispatchContext(ServletContext context) {
        void var1_1;
        this._dispatchContext = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setDispatchPath(String path) {
        void var1_1;
        this._dispatchPath = var1_1;
    }

    public void completed() {
        this._timeoutTask = null;
        this._asyncContext.reset();
    }

    public HttpChannelState getHttpChannelState() {
        return this._state;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void var1_1;
        Scheduler.Task task = this._timeoutTask;
        this._timeoutTask = null;
        if (var1_1 != null) {
            this._state.timeout();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addThrowable(Throwable e) {
        if (this._throwable == null) {
            this._throwable = e;
            return;
        }
        if (e != this._throwable) {
            void var1_1;
            this._throwable.addSuppressed((Throwable)var1_1);
        }
    }
}

