/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;

public class AllowedResourceAliasChecker
extends AbstractLifeCycle
implements ContextHandler.AliasCheck {
    private static final Logger LOG = Log.getLogger(AllowedResourceAliasChecker.class);
    protected static final LinkOption[] FOLLOW_LINKS = new LinkOption[0];
    protected static final LinkOption[] NO_FOLLOW_LINKS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    private final ContextHandler _contextHandler;
    private final List<Path> _protected = new ArrayList<Path>();
    private final AllowedResourceAliasCheckListener _listener = new AllowedResourceAliasCheckListener();
    protected Path _base;

    /*
     * WARNING - void declaration
     */
    public AllowedResourceAliasChecker(ContextHandler contextHandler) {
        void var1_1;
        this._contextHandler = (ContextHandler)Objects.requireNonNull(var1_1);
    }

    protected ContextHandler getContextHandler() {
        return this._contextHandler;
    }

    /*
     * WARNING - void declaration
     */
    protected void initialize() {
        this._base = this.getPath(this._contextHandler.getBaseResource());
        if (this._base == null) {
            return;
        }
        try {
            String[] protectedTargets;
            if (Files.exists(this._base, NO_FOLLOW_LINKS)) {
                this._base = this._base.toRealPath(FOLLOW_LINKS);
            }
            if ((protectedTargets = this._contextHandler.getProtectedTargets()) != null) {
                for (String s : protectedTargets) {
                    this._protected.add(this._base.getFileSystem().getPath(this._base.toString(), s));
                }
            }
            return;
        }
        catch (IOException e) {
            void var1_2;
            LOG.warn("Base resource failure ({} is disabled): {}", new Object[]{this.getClass().getName(), this._base, var1_2});
            this._base = null;
            return;
        }
    }

    protected void doStart() throws Exception {
        if (this._contextHandler.isStarted()) {
            this.initialize();
            return;
        }
        this._contextHandler.addLifeCycleListener(this._listener);
    }

    protected void doStop() throws Exception {
        this._contextHandler.removeLifeCycleListener(this._listener);
        this._base = null;
        this._protected.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean check(String pathInContext, Resource resource) {
        if (this._base == null) {
            return false;
        }
        try {
            void var1_1;
            if (!resource.exists()) {
                return false;
            }
            Path path = this.getPath(resource);
            if (path == null) {
                return false;
            }
            return this.check((String)var1_1, path);
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                void var2_3;
                LOG.debug("Failed to check alias", (Throwable)var2_3);
            }
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean check(String pathInContext, Path path) {
        void var2_2;
        return this.isAllowed(AllowedResourceAliasChecker.getRealPath((Path)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isAllowed(Path path) {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            while (path != null) {
                if (this.isSameFile(path, this._base)) {
                    return true;
                }
                for (Path p : this._protected) {
                    void var3_3;
                    if (!this.isSameFile(path, (Path)var3_3)) continue;
                    return false;
                }
                path = path.getParent();
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSameFile(Path path1, Path path2) {
        block4: {
            if (Objects.equals(path1, path2)) {
                return true;
            }
            try {
                void var2_3;
                if (Files.isSameFile(path1, (Path)var2_3)) {
                    return true;
                }
            }
            catch (Throwable t) {
                void var1_2;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("ignored", (Throwable)var1_2);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static Path getRealPath(Path path) {
        block4: {
            if (path == null || !Files.exists(path, new LinkOption[0])) {
                return null;
            }
            try {
                path = path.toRealPath(FOLLOW_LINKS);
                if (Files.exists(path, new LinkOption[0])) {
                    return path;
                }
            }
            catch (IOException e) {
                void var1_1;
                Path path2;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("No real path for {}", new Object[]{path2, var1_1});
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected Path getPath(Resource resource) {
        try {
            if (resource instanceof PathResource) {
                return ((PathResource)resource).getPath();
            }
            if (resource == null) {
                return null;
            }
            return resource.getFile().toPath();
        }
        catch (Throwable t) {
            void var1_2;
            LOG.ignore((Throwable)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        String[] protectedTargets = this._contextHandler.getProtectedTargets();
        return String.format("%s@%x{base=%s,protected=%s}", this.getClass().getSimpleName(), this.hashCode(), this._base, protectedTargets == null ? null : Arrays.asList(var1_1));
    }

    private class AllowedResourceAliasCheckListener
    implements LifeCycle.Listener {
        private AllowedResourceAliasCheckListener() {
        }

        public void lifeCycleStarted(LifeCycle event) {
            AllowedResourceAliasChecker.this.initialize();
        }
    }
}

