/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.RateStatistic;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject
public class AcceptRateLimit
extends AbstractLifeCycle
implements Runnable,
SelectorManager.AcceptListener {
    private static final Logger LOG = Log.getLogger(AcceptRateLimit.class);
    private final Server _server;
    private final List<AbstractConnector> _connectors = new ArrayList<AbstractConnector>();
    private final Rate _rate;
    private final int _acceptRateLimit;
    private boolean _limiting;
    private Scheduler.Task _task;

    /*
     * WARNING - void declaration
     */
    public AcceptRateLimit(@Name(value="acceptRateLimit") int acceptRateLimit, @Name(value="period") long period, @Name(value="units") TimeUnit units, @Name(value="server") Server server) {
        void var2_2;
        void var1_1;
        this._server = server;
        this._acceptRateLimit = var1_1;
        this._rate = new Rate((long)var2_2, units);
    }

    /*
     * WARNING - void declaration
     */
    public AcceptRateLimit(@Name(value="limit") int limit, @Name(value="period") long period, @Name(value="units") TimeUnit units, Connector ... connectors) {
        this((int)var1_1, (long)var2_3, units, (Server)null);
        void var2_3;
        void var1_1;
        Connector[] connectorArray = connectors;
        int n = connectors.length;
        for (int i = 0; i < n; ++i) {
            Connector c = connectorArray[i];
            if (c instanceof AbstractConnector) {
                this._connectors.add((AbstractConnector)c);
                continue;
            }
            LOG.warn("Connector {} is not an AbstractConnector. Connections not limited", new Object[]{c});
        }
    }

    @ManagedAttribute(value="The accept rate limit")
    public int getAcceptRateLimit() {
        return this._acceptRateLimit;
    }

    @ManagedAttribute(value="The accept rate period")
    public long getPeriod() {
        return this._rate.getPeriod();
    }

    @ManagedAttribute(value="The accept rate period units")
    public TimeUnit getUnits() {
        return this._rate.getUnits();
    }

    @ManagedAttribute(value="The current accept rate")
    public int getRate() {
        return this._rate.getRate();
    }

    @ManagedAttribute(value="The maximum accept rate achieved")
    public long getMaxRate() {
        return this._rate.getMax();
    }

    @ManagedOperation(value="Resets the accept rate", impact="ACTION")
    public void reset() {
        Rate rate = this._rate;
        synchronized (rate) {
            this._rate.reset();
            if (this._limiting) {
                this._limiting = false;
                this.unlimit();
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void age(long period, TimeUnit units) {
        void var3_2;
        void var1_1;
        this._rate.age((long)var1_1, (TimeUnit)var3_2);
    }

    protected void doStart() throws Exception {
        Rate rate = this._rate;
        synchronized (rate) {
            if (this._server != null) {
                for (Connector c : this._server.getConnectors()) {
                    if (c instanceof AbstractConnector) {
                        this._connectors.add((AbstractConnector)c);
                        continue;
                    }
                    LOG.warn("Connector {} is not an AbstractConnector. Connections not limited", new Object[]{c});
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("AcceptLimit accept<{} rate<{} in {} for {}", new Object[]{this._acceptRateLimit, this._rate, this._connectors});
            }
            for (AbstractConnector abstractConnector : this._connectors) {
                abstractConnector.addBean(this);
            }
            return;
        }
    }

    protected void doStop() throws Exception {
        Rate rate = this._rate;
        synchronized (rate) {
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            for (AbstractConnector abstractConnector : this._connectors) {
                abstractConnector.removeBean(this);
            }
            if (this._server != null) {
                this._connectors.clear();
            }
            this._limiting = false;
            return;
        }
    }

    protected void limit() {
        for (AbstractConnector abstractConnector : this._connectors) {
            abstractConnector.setAccepting(false);
        }
        this.schedule();
    }

    protected void unlimit() {
        for (AbstractConnector abstractConnector : this._connectors) {
            abstractConnector.setAccepting(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onAccepting(SelectableChannel channel) {
        Rate rate = this._rate;
        synchronized (rate) {
            int rate2 = this._rate.record();
            if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug("onAccepting rate {}/{} for {} {}", new Object[]{rate2, this._acceptRateLimit, this._rate, var1_1});
            }
            if (rate2 > this._acceptRateLimit && !this._limiting) {
                void var3_4;
                this._limiting = true;
                LOG.warn("AcceptLimit rate exceeded {}>{} on {}", new Object[]{(int)var3_4, this._acceptRateLimit, this._connectors});
                this.limit();
            }
            return;
        }
    }

    private void schedule() {
        long l;
        long oldest = this._rate.getOldest(TimeUnit.MILLISECONDS);
        long l2 = TimeUnit.MILLISECONDS.convert(this._rate.getPeriod(), this._rate.getUnits());
        long delay = l2 - (oldest > 0L ? l : 0L);
        if (delay < 0L) {
            delay = 0L;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("schedule {} {}", new Object[]{delay, TimeUnit.MILLISECONDS});
        }
        this._task = this._connectors.get(0).getScheduler().schedule((Runnable)this, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        Rate rate = this._rate;
        synchronized (rate) {
            this._task = null;
            if (!this.isRunning()) {
                return;
            }
            int rate2 = this._rate.getRate();
            if (rate2 > this._acceptRateLimit) {
                this.schedule();
                return;
            }
            if (this._limiting) {
                void var2_2;
                this._limiting = false;
                LOG.warn("AcceptLimit rate OK {}<={} on {}", new Object[]{(int)var2_2, this._acceptRateLimit, this._connectors});
                this.unlimit();
            }
            return;
        }
    }

    private final class Rate
    extends RateStatistic {
        /*
         * WARNING - void declaration
         */
        private Rate(long period, TimeUnit units) {
            void var2_2;
            super((long)var2_2, units);
        }

        /*
         * WARNING - void declaration
         */
        protected final void age(long period, TimeUnit units) {
            void var3_2;
            void var1_1;
            super.age((long)var1_1, (TimeUnit)var3_2);
        }
    }
}

