/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@Deprecated
public class AbstractNCSARequestLog
extends ContainerLifeCycle
implements RequestLog {
    protected static final Logger LOG = Log.getLogger(AbstractNCSARequestLog.class);
    private static ThreadLocal<StringBuilder> _buffers = ThreadLocal.withInitial(() -> new StringBuilder(256));
    protected final RequestLog.Writer _requestLogWriter;
    private String[] _ignorePaths;
    private boolean _extended;
    private transient PathMappings<String> _ignorePathMap;
    private boolean _logLatency = false;
    private boolean _logCookies = false;
    private boolean _logServer = false;
    private boolean _preferProxiedForAddress;
    private transient DateCache _logDateCache;
    private String _logDateFormat = "dd/MMM/yyyy:HH:mm:ss Z";
    private Locale _logLocale = Locale.getDefault();
    private String _logTimeZone = "GMT";

    /*
     * WARNING - void declaration
     */
    public AbstractNCSARequestLog(RequestLog.Writer requestLogWriter) {
        void var1_1;
        this._requestLogWriter = var1_1;
        AbstractNCSARequestLog abstractNCSARequestLog = this;
        abstractNCSARequestLog.addBean(abstractNCSARequestLog._requestLogWriter);
    }

    protected boolean isEnabled() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void write(String requestEntry) throws IOException {
        void var1_1;
        this._requestLogWriter.write((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void append(StringBuilder buf, String s) {
        void var2_2;
        void var1_1;
        if (s == null || s.length() == 0) {
            buf.append('-');
            return;
        }
        var1_1.append((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Request request, Response response) {
        try {
            if (this._ignorePathMap != null && this._ignorePathMap.getMatched(request.getRequestURI()) != null) {
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            StringBuilder buf = _buffers.get();
            buf.setLength(0);
            if (this._logServer) {
                this.append(buf, request.getServerName());
                buf.append(' ');
            }
            String addr = null;
            if (this._preferProxiedForAddress) {
                addr = request.getHeader(HttpHeader.X_FORWARDED_FOR.toString());
            }
            if (addr == null) {
                addr = request.getRemoteAddr();
            }
            buf.append(addr);
            buf.append(" - ");
            String auth = this.getAuthentication(request);
            this.append(buf, auth == null ? "-" : auth);
            buf.append(" [");
            if (this._logDateCache != null) {
                buf.append(this._logDateCache.format(request.getTimeStamp()));
            } else {
                buf.append(request.getTimeStamp());
            }
            buf.append("] \"");
            this.append(buf, request.getMethod());
            buf.append(' ');
            this.append(buf, request.getOriginalURI());
            buf.append(' ');
            this.append(buf, request.getProtocol());
            buf.append("\" ");
            int status = response.getCommittedMetaData().getStatus();
            if (status >= 0) {
                buf.append((char)(48 + status / 100 % 10));
                buf.append((char)(48 + status / 10 % 10));
                buf.append((char)(48 + status % 10));
            } else {
                buf.append(status);
            }
            long written = response.getHttpChannel().getBytesWritten();
            if (written >= 0L) {
                buf.append(' ');
                if (written > 99999L) {
                    buf.append(written);
                } else {
                    if (written > 9999L) {
                        buf.append((char)(48L + written / 10000L % 10L));
                    }
                    if (written > 999L) {
                        buf.append((char)(48L + written / 1000L % 10L));
                    }
                    if (written > 99L) {
                        buf.append((char)(48L + written / 100L % 10L));
                    }
                    if (written > 9L) {
                        buf.append((char)(48L + written / 10L % 10L));
                    }
                    buf.append((char)(48L + written % 10L));
                }
                buf.append(' ');
            } else {
                buf.append(" - ");
            }
            if (this._extended) {
                void var2_2;
                this.logExtended(buf, request, (Response)var2_2);
            }
            if (this._logCookies) {
                Cookie[] cookies = request.getCookies();
                if (cookies == null || cookies.length == 0) {
                    buf.append(" -");
                } else {
                    buf.append(" \"");
                    for (int i = 0; i < cookies.length; ++i) {
                        if (i != 0) {
                            buf.append(';');
                        }
                        buf.append(cookies[i].getName());
                        buf.append('=');
                        buf.append(cookies[i].getValue());
                    }
                    buf.append('\"');
                }
            }
            if (this._logLatency) {
                long now = System.currentTimeMillis();
                if (this._logLatency) {
                    void var1_1;
                    buf.append(' ');
                    buf.append(now - var1_1.getTimeStamp());
                }
            }
            String log = buf.toString();
            this.write(log);
            return;
        }
        catch (IOException e) {
            void var3_4;
            LOG.warn((Throwable)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String getAuthentication(Request request) {
        Authentication authentication = request.getAuthentication();
        if (authentication instanceof Authentication.User) {
            void var1_1;
            return ((Authentication.User)var1_1).getUserIdentity().getUserPrincipal().getName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void logExtended(StringBuilder b, Request request, Response response) throws IOException {
        void var1_1;
        void var2_2;
        String referer = request.getHeader(HttpHeader.REFERER.toString());
        if (referer == null) {
            b.append("\"-\" ");
        } else {
            void var3_3;
            b.append('\"');
            b.append((String)var3_3);
            b.append("\" ");
        }
        String agent = request.getHeader(HttpHeader.USER_AGENT.toString());
        if (agent == null) {
            b.append("\"-\"");
            return;
        }
        b.append('\"');
        b.append((String)var2_2);
        var1_1.append('\"');
    }

    /*
     * WARNING - void declaration
     */
    public void setIgnorePaths(String[] ignorePaths) {
        void var1_1;
        this._ignorePaths = var1_1;
    }

    public String[] getIgnorePaths() {
        return this._ignorePaths;
    }

    /*
     * WARNING - void declaration
     */
    public void setLogCookies(boolean logCookies) {
        void var1_1;
        this._logCookies = var1_1;
    }

    public boolean getLogCookies() {
        return this._logCookies;
    }

    /*
     * WARNING - void declaration
     */
    public void setLogServer(boolean logServer) {
        void var1_1;
        this._logServer = var1_1;
    }

    public boolean getLogServer() {
        return this._logServer;
    }

    /*
     * WARNING - void declaration
     */
    public void setLogLatency(boolean logLatency) {
        void var1_1;
        this._logLatency = var1_1;
    }

    public boolean getLogLatency() {
        return this._logLatency;
    }

    @Deprecated
    public void setLogDispatch(boolean value) {
    }

    @Deprecated
    public boolean isLogDispatch() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void setPreferProxiedForAddress(boolean preferProxiedForAddress) {
        void var1_1;
        this._preferProxiedForAddress = var1_1;
    }

    public boolean getPreferProxiedForAddress() {
        return this._preferProxiedForAddress;
    }

    /*
     * WARNING - void declaration
     */
    public void setExtended(boolean extended) {
        void var1_1;
        this._extended = var1_1;
    }

    @ManagedAttribute(value="use extended NCSA format")
    public boolean isExtended() {
        return this._extended;
    }

    protected synchronized void doStart() throws Exception {
        if (this._logDateFormat != null) {
            this._logDateCache = new DateCache(this._logDateFormat, this._logLocale, this._logTimeZone);
        }
        if (this._ignorePaths != null && this._ignorePaths.length > 0) {
            this._ignorePathMap = new PathMappings();
            for (int i = 0; i < this._ignorePaths.length; ++i) {
                this._ignorePathMap.put(this._ignorePaths[i], (Object)this._ignorePaths[i]);
            }
        } else {
            this._ignorePathMap = null;
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._logDateCache = null;
        super.doStop();
    }

    /*
     * WARNING - void declaration
     */
    public void setLogDateFormat(String format) {
        void var1_1;
        this._logDateFormat = var1_1;
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    /*
     * WARNING - void declaration
     */
    public void setLogLocale(Locale logLocale) {
        void var1_1;
        this._logLocale = var1_1;
    }

    public Locale getLogLocale() {
        return this._logLocale;
    }

    /*
     * WARNING - void declaration
     */
    public void setLogTimeZone(String tz) {
        void var1_1;
        this._logTimeZone = var1_1;
    }

    @ManagedAttribute(value="the timezone")
    public String getLogTimeZone() {
        return this._logTimeZone;
    }
}

