/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.stream.Collectors;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelListeners;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.Graceful;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPoolBudget;

@ManagedObject(value="Abstract implementation of the Connector Interface")
public abstract class AbstractConnector
extends ContainerLifeCycle
implements Connector,
Dumpable {
    protected static final Logger LOG = Log.getLogger(AbstractConnector.class);
    private final Locker _locker = new Locker();
    private final Condition _setAccepting = this._locker.newCondition();
    private final Map<String, ConnectionFactory> _factories = new LinkedHashMap<String, ConnectionFactory>();
    private final Server _server;
    private final Executor _executor;
    private final Scheduler _scheduler;
    private final ByteBufferPool _byteBufferPool;
    private final Thread[] _acceptors;
    private final Set<EndPoint> _endpoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<EndPoint> _immutableEndPoints = Collections.unmodifiableSet(this._endpoints);
    private final Graceful.Shutdown _shutdown = new Graceful.Shutdown();
    private HttpChannel.Listener _httpChannelListeners = HttpChannel.NOOP_LISTENER;
    private CountDownLatch _stopping;
    private long _idleTimeout = 30000L;
    private String _defaultProtocol;
    private ConnectionFactory _defaultConnectionFactory;
    private String _name;
    private int _acceptorPriorityDelta = -2;
    private boolean _accepting = true;
    private ThreadPoolBudget.Lease _lease;

    /*
     * WARNING - void declaration
     */
    public AbstractConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, ConnectionFactory ... factories) {
        void var1_2;
        void var2_3;
        void var3_5;
        this._server = server;
        Executor executor2 = this._executor = executor != null ? executor : this._server.getThreadPool();
        if (scheduler == null) {
            scheduler = (Scheduler)this._server.getBean(Scheduler.class);
        }
        Object object = this._scheduler = scheduler != null ? var3_5 : new ScheduledExecutorScheduler(String.format("Connector-Scheduler-%x", this.hashCode()), false);
        if (pool == null) {
            pool = (ByteBufferPool)this._server.getBean(ByteBufferPool.class);
        }
        this._byteBufferPool = pool != null ? pool : new ArrayByteBufferPool();
        this.addEventListener(new Container.Listener(this){
            final /* synthetic */ AbstractConnector this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public void beanAdded(Container parent, Object bean) {
                if (bean instanceof HttpChannel.Listener) {
                    AbstractConnector.access$002(this.this$0, new HttpChannelListeners(this.this$0.getBeans(HttpChannel.Listener.class)));
                }
            }

            public void beanRemoved(Container parent, Object bean) {
                if (bean instanceof HttpChannel.Listener) {
                    AbstractConnector.access$002(this.this$0, new HttpChannelListeners(this.this$0.getBeans(HttpChannel.Listener.class)));
                }
            }
        });
        AbstractConnector abstractConnector = this;
        abstractConnector.addBean(abstractConnector._server, false);
        AbstractConnector abstractConnector2 = this;
        abstractConnector2.addBean(abstractConnector2._executor);
        if (var2_3 == null) {
            AbstractConnector abstractConnector3 = this;
            abstractConnector3.unmanage(abstractConnector3._executor);
        }
        AbstractConnector abstractConnector4 = this;
        abstractConnector4.addBean(abstractConnector4._scheduler);
        AbstractConnector abstractConnector5 = this;
        abstractConnector5.addBean(abstractConnector5._byteBufferPool);
        server = factories;
        int n = factories.length;
        for (int i = 0; i < n; ++i) {
            ConnectionFactory factory = server[i];
            this.addConnectionFactory(factory);
        }
        int cores = ProcessorUtils.availableProcessors();
        if (acceptors < 0) {
            acceptors = Math.max(1, Math.min(4, cores / 8));
        }
        if (acceptors > var1_2) {
            LOG.warn("Acceptors should be <= availableProcessors: " + this, new Object[0]);
        }
        this._acceptors = new Thread[acceptors];
    }

    public HttpChannel.Listener getHttpChannelListeners() {
        return this._httpChannelListeners;
    }

    @Override
    public Server getServer() {
        return this._server;
    }

    @Override
    public Executor getExecutor() {
        return this._executor;
    }

    @Override
    public ByteBufferPool getByteBufferPool() {
        return this._byteBufferPool;
    }

    @Override
    @ManagedAttribute(value="The connection idle timeout in milliseconds")
    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setIdleTimeout(long idleTimeout) {
        void var1_1;
        this._idleTimeout = var1_1;
    }

    @ManagedAttribute(value="number of acceptor threads")
    public int getAcceptors() {
        return this._acceptors.length;
    }

    protected void doStart() throws Exception {
        String next;
        ConnectionFactory connectionFactory;
        this._shutdown.cancel();
        if (this._defaultProtocol == null) {
            throw new IllegalStateException("No default protocol for " + this);
        }
        this._defaultConnectionFactory = this.getConnectionFactory(this._defaultProtocol);
        if (this._defaultConnectionFactory == null) {
            throw new IllegalStateException("No protocol factory for default protocol '" + this._defaultProtocol + "' in " + this);
        }
        SslConnectionFactory ssl = this.getConnectionFactory(SslConnectionFactory.class);
        if (ssl != null && (connectionFactory = this.getConnectionFactory(next = ssl.getNextProtocol())) == null) {
            throw new IllegalStateException("No protocol factory for SSL next protocol: '" + next + "' in " + this);
        }
        AbstractConnector abstractConnector = this;
        this._lease = ThreadPoolBudget.leaseFrom((Executor)this.getExecutor(), (Object)abstractConnector, (int)abstractConnector._acceptors.length);
        super.doStart();
        this._stopping = new CountDownLatch(this._acceptors.length);
        for (int i = 0; i < this._acceptors.length; ++i) {
            Acceptor a = new Acceptor(i);
            this.addBean(a);
            this.getExecutor().execute((Runnable)((Object)connectionFactory));
        }
        LOG.info("Started {}", new Object[]{this});
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void interruptAcceptors() {
        Locker.Lock lock = this._locker.lock();
        try {
            Thread[] threadArray = this._acceptors;
            int n = this._acceptors.length;
            for (int i = 0; i < n; ++i) {
                Thread thread = threadArray[i];
                if (thread == null) continue;
                thread.interrupt();
            }
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    public Future<Void> shutdown() {
        return this._shutdown.shutdown();
    }

    public boolean isShutdown() {
        return this._shutdown.isShutdown();
    }

    /*
     * WARNING - void declaration
     */
    protected void doStop() throws Exception {
        if (this._lease != null) {
            this._lease.close();
        }
        this.interruptAcceptors();
        long stopTimeout = this.getStopTimeout();
        CountDownLatch stopping = this._stopping;
        if (stopTimeout > 0L && stopping != null && this.getAcceptors() > 0) {
            void var1_1;
            void var3_3;
            var3_3.await((long)var1_1, TimeUnit.MILLISECONDS);
        }
        this._stopping = null;
        super.doStop();
        for (Acceptor a : this.getBeans(Acceptor.class)) {
            void var2_4;
            this.removeBean(var2_4);
        }
        LOG.info("Stopped {}", new Object[]{this});
    }

    public void join() throws InterruptedException {
        this.join(0L);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void join(long timeout) throws InterruptedException {
        Locker.Lock lock = this._locker.lock();
        try {
            Thread[] threadArray = this._acceptors;
            int n = this._acceptors.length;
            for (int i = 0; i < n; ++i) {
                Thread thread = threadArray[i];
                if (thread == null) continue;
                thread.join(timeout);
            }
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var3_2;
                var3_2.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    protected abstract void accept(int var1) throws IOException, InterruptedException;

    /*
     * WARNING - void declaration
     */
    public boolean isAccepting() {
        boolean bl;
        block5: {
            Locker.Lock lock = this._locker.lock();
            try {
                bl = this._accepting;
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAccepting(boolean accepting) {
        Locker.Lock lock = this._locker.lock();
        try {
            void var1_1;
            this._accepting = var1_1;
            this._setAccepting.signalAll();
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConnectionFactory getConnectionFactory(String protocol) {
        ConnectionFactory connectionFactory;
        block5: {
            Locker.Lock lock = this._locker.lock();
            try {
                connectionFactory = this._factories.get(StringUtil.asciiToLowerCase((String)((Object)connectionFactory)));
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var2_3;
                        var2_3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return connectionFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getConnectionFactory(Class<T> factoryType) {
        Locker.Lock lock = this._locker.lock();
        try {
            for (ConnectionFactory f : this._factories.values()) {
                if (!((Class)factoryType).isAssignableFrom(f.getClass())) continue;
                factoryType = f;
                if (lock == null) break block7;
            }
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    void var2_2;
                    var2_2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        {
            block7: {
                lock.close();
            }
            return (T)factoryType;
        }
        if (lock != null) {
            lock.close();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void addConnectionFactory(ConnectionFactory factory) {
        void var2_2;
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        HashSet<ConnectionFactory> toRemove = new HashSet<ConnectionFactory>();
        for (String string : factory.getProtocols()) {
            String key = StringUtil.asciiToLowerCase((String)string);
            ConnectionFactory old = this._factories.remove(key);
            if (old != null) {
                if (old.getProtocol().equals(this._defaultProtocol)) {
                    this._defaultProtocol = null;
                }
                toRemove.add(old);
            }
            this._factories.put(key, factory);
        }
        for (ConnectionFactory f : this._factories.values()) {
            toRemove.remove(f);
        }
        for (ConnectionFactory old : var2_2) {
            this.removeBean(old);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("{} removed {}", new Object[]{this, old});
        }
        this.addBean(factory);
        if (this._defaultProtocol == null) {
            this._defaultProtocol = factory.getProtocol();
        }
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("{} added {}", new Object[]{this, var1_1});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addFirstConnectionFactory(ConnectionFactory factory) {
        void var1_1;
        Iterator iterator;
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        ArrayList<ConnectionFactory> existings = new ArrayList<ConnectionFactory>(this._factories.values());
        this._factories.clear();
        this.addConnectionFactory(factory);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            ConnectionFactory existing = (ConnectionFactory)iterator.next();
            this.addConnectionFactory((ConnectionFactory)var3_3);
        }
        this._defaultProtocol = var1_1.getProtocol();
    }

    /*
     * WARNING - void declaration
     */
    public void addIfAbsentConnectionFactory(ConnectionFactory factory) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        String key = StringUtil.asciiToLowerCase((String)factory.getProtocol());
        if (this._factories.containsKey(key)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} addIfAbsent ignored {}", new Object[]{this, factory});
                return;
            }
        } else {
            void var2_2;
            this._factories.put((String)var2_2, factory);
            this.addBean(factory);
            if (this._defaultProtocol == null) {
                this._defaultProtocol = factory.getProtocol();
            }
            if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug("{} addIfAbsent added {}", new Object[]{this, var1_1});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionFactory removeConnectionFactory(String protocol) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        ConnectionFactory factory = this._factories.remove(StringUtil.asciiToLowerCase((String)protocol));
        this.removeBean(factory);
        return var1_1;
    }

    @Override
    public Collection<ConnectionFactory> getConnectionFactories() {
        return this._factories.values();
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectionFactories(Collection<ConnectionFactory> factories) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        Iterator iterator = new ArrayList<ConnectionFactory>(this._factories.values());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ConnectionFactory factory = (ConnectionFactory)iterator.next();
            this.removeConnectionFactory(factory.getProtocol());
        }
        for (ConnectionFactory factory : var1_1) {
            void var3_3;
            if (factory == null) continue;
            this.addConnectionFactory((ConnectionFactory)var3_3);
        }
    }

    @ManagedAttribute(value="The priority delta to apply to acceptor threads")
    public int getAcceptorPriorityDelta() {
        return this._acceptorPriorityDelta;
    }

    public void setAcceptorPriorityDelta(int acceptorPriorityDelta) {
        int old = this._acceptorPriorityDelta;
        this._acceptorPriorityDelta = acceptorPriorityDelta;
        if (old != acceptorPriorityDelta && this.isStarted()) {
            Thread[] threadArray = this._acceptors;
            int n = this._acceptors.length;
            for (int i = 0; i < n; ++i) {
                Thread thread = threadArray[i];
                thread.setPriority(Math.max(1, Math.min(10, thread.getPriority() - old + acceptorPriorityDelta)));
            }
        }
    }

    @Override
    @ManagedAttribute(value="Protocols supported by this connector")
    public List<String> getProtocols() {
        return new ArrayList<String>(this._factories.keySet());
    }

    public void clearConnectionFactories() {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._factories.clear();
    }

    @ManagedAttribute(value="This connector's default protocol")
    public String getDefaultProtocol() {
        return this._defaultProtocol;
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultProtocol(String defaultProtocol) {
        void var1_1;
        this._defaultProtocol = StringUtil.asciiToLowerCase((String)var1_1);
        if (this.isRunning()) {
            this._defaultConnectionFactory = this.getConnectionFactory(this._defaultProtocol);
        }
    }

    @Override
    public ConnectionFactory getDefaultConnectionFactory() {
        if (this.isStarted()) {
            return this._defaultConnectionFactory;
        }
        AbstractConnector abstractConnector = this;
        return abstractConnector.getConnectionFactory(abstractConnector._defaultProtocol);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean handleAcceptFailure(Throwable ex) {
        void var1_1;
        if (this.isRunning()) {
            if (ex instanceof InterruptedException) {
                LOG.debug(ex);
                return true;
            }
            if (ex instanceof ClosedByInterruptException) {
                LOG.debug(ex);
                return false;
            }
            LOG.warn(ex);
            try {
                Thread.sleep(1000L);
                return true;
            }
            catch (Throwable x) {
                void var1_2;
                LOG.ignore((Throwable)var1_2);
                return false;
            }
        }
        LOG.ignore((Throwable)var1_1);
        return false;
    }

    @Override
    public Collection<EndPoint> getConnectedEndPoints() {
        return this._immutableEndPoints;
    }

    /*
     * WARNING - void declaration
     */
    protected void onEndPointOpened(EndPoint endp) {
        void var1_1;
        this._endpoints.add((EndPoint)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void onEndPointClosed(EndPoint endp) {
        void var1_1;
        this._endpoints.remove(var1_1);
    }

    @Override
    public Scheduler getScheduler() {
        return this._scheduler;
    }

    @Override
    public String getName() {
        return this._name;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this._name = var1_1;
    }

    public String toString() {
        return String.format("%s@%x{%s, %s}", this._name == null ? this.getClass().getSimpleName() : this._name, this.hashCode(), this.getDefaultProtocol(), this.getProtocols().stream().collect(Collectors.joining(", ", "(", ")")));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ HttpChannel.Listener access$002(AbstractConnector x0, HttpChannel.Listener x1) {
        void var1_1;
        x0._httpChannelListeners = var1_1;
        return x0._httpChannelListeners;
    }

    static /* synthetic */ Locker access$400(AbstractConnector x0) {
        return x0._locker;
    }

    static /* synthetic */ boolean access$500(AbstractConnector x0) {
        return x0._accepting;
    }

    static /* synthetic */ Condition access$600(AbstractConnector x0) {
        return x0._setAccepting;
    }

    private class Acceptor
    implements Runnable {
        private final int _id;
        private String _name;

        /*
         * WARNING - void declaration
         */
        private Acceptor(int id) {
            void var2_2;
            this._id = var2_2;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object thread = Thread.currentThread();
            String name = ((Thread)thread).getName();
            this._name = String.format("%s-acceptor-%d@%x-%s", name, this._id, this.hashCode(), AbstractConnector.this.toString());
            ((Thread)thread).setName(this._name);
            int priority = ((Thread)thread).getPriority();
            if (AbstractConnector.this._acceptorPriorityDelta != 0) {
                ((Thread)thread).setPriority(Math.max(1, Math.min(10, priority + AbstractConnector.this._acceptorPriorityDelta)));
            }
            ((AbstractConnector)AbstractConnector.this)._acceptors[this._id] = thread;
            try {}
            catch (Throwable throwable) {
                void var2_2;
                ((Thread)thread).setName((String)var2_2);
                if (AbstractConnector.this._acceptorPriorityDelta != 0) {
                    void var3_3;
                    ((Thread)thread).setPriority((int)var3_3);
                }
                thread = AbstractConnector.this;
                synchronized (thread) {
                    ((AbstractConnector)AbstractConnector.this)._acceptors[this._id] = null;
                }
                CountDownLatch stopping = AbstractConnector.this._stopping;
                if (stopping != null) {
                    void var1_1;
                    var1_1.countDown();
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            String name = this._name;
            if (name == null) {
                return String.format("acceptor-%d@%x", this._id, this.hashCode());
            }
            return var1_1;
        }
    }
}

