/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@ManagedObject
public abstract class AbstractConnectionFactory
extends ContainerLifeCycle
implements ConnectionFactory {
    private final String _protocol;
    private final List<String> _protocols;
    private int _inputbufferSize = 8192;

    /*
     * WARNING - void declaration
     */
    protected AbstractConnectionFactory(String protocol) {
        void var1_1;
        this._protocol = protocol;
        this._protocols = Collections.unmodifiableList(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractConnectionFactory(String ... protocols) {
        void var1_1;
        this._protocol = protocols[0];
        this._protocols = Collections.unmodifiableList(Arrays.asList(var1_1));
    }

    @Override
    @ManagedAttribute(value="The protocol name", readonly=true)
    public String getProtocol() {
        return this._protocol;
    }

    @Override
    public List<String> getProtocols() {
        return this._protocols;
    }

    @ManagedAttribute(value="The buffer size used to read from the network")
    public int getInputBufferSize() {
        return this._inputbufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setInputBufferSize(int size) {
        void var1_1;
        this._inputbufferSize = var1_1;
    }

    protected String findNextProtocol(Connector connector) {
        return AbstractConnectionFactory.findNextProtocol(connector, this.getProtocol());
    }

    /*
     * WARNING - void declaration
     */
    protected static String findNextProtocol(Connector connector, String currentProtocol) {
        void var2_2;
        String nextProtocol = null;
        Iterator<String> it = connector.getProtocols().iterator();
        while (it.hasNext()) {
            void var3_3;
            String protocol = (String)it.next();
            if (!currentProtocol.equalsIgnoreCase((String)var3_3)) continue;
            nextProtocol = it.hasNext() ? (String)it.next() : null;
            break;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractConnection configure(AbstractConnection connection, Connector connector, EndPoint endPoint) {
        void var1_1;
        connection.setInputBufferSize(this.getInputBufferSize());
        if (connector instanceof ContainerLifeCycle) {
            connector = (ContainerLifeCycle)connector;
            for (Connection.Listener listener : connector.getBeans(Connection.Listener.class)) {
                Iterator iterator;
                connection.addListener(iterator);
            }
        }
        for (Connection.Listener listener : this.getBeans(Connection.Listener.class)) {
            void var3_3;
            connection.addListener((Connection.Listener)var3_3);
        }
        return var1_1;
    }

    public String toString() {
        return String.format("%s@%x%s", this.getClass().getSimpleName(), this.hashCode(), this.getProtocols());
    }

    /*
     * WARNING - void declaration
     */
    public static ConnectionFactory[] getFactories(SslContextFactory sslContextFactory, ConnectionFactory ... factories) {
        void var1_1;
        SslContextFactory sslContextFactory2;
        factories = (ConnectionFactory[])ArrayUtil.removeNulls((Object[])factories);
        if (sslContextFactory == null) {
            return factories;
        }
        ConnectionFactory[] connectionFactoryArray = factories;
        int n = factories.length;
        for (int i = 0; i < n; ++i) {
            HttpConfiguration config;
            ConnectionFactory factory = connectionFactoryArray[i];
            if (!(factory instanceof HttpConfiguration.ConnectionFactory) || (config = ((HttpConfiguration.ConnectionFactory)((Object)factory)).getHttpConfiguration()).getCustomizer(SecureRequestCustomizer.class) != null) continue;
            config.addCustomizer(new SecureRequestCustomizer());
        }
        return (ConnectionFactory[])ArrayUtil.prependToArray((Object)new SslConnectionFactory(sslContextFactory2, factories[0].getProtocol()), (Object[])var1_1, ConnectionFactory.class);
    }
}

