/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.channel.unix.Limits;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class UnixChannelUtil {
    private UnixChannelUtil() {
    }

    public static boolean isBufferCopyNeededForWrite(ByteBuf byteBuf) {
        return UnixChannelUtil.isBufferCopyNeededForWrite(byteBuf, Limits.IOV_MAX);
    }

    /*
     * WARNING - void declaration
     */
    static boolean isBufferCopyNeededForWrite(ByteBuf byteBuf, int iovMax) {
        void var1_1;
        ByteBuf byteBuf2;
        return !byteBuf.hasMemoryAddress() && (!byteBuf.isDirect() || byteBuf2.nioBufferCount() > var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static InetSocketAddress computeRemoteAddr(InetSocketAddress remoteAddr, InetSocketAddress osRemoteAddr) {
        InetSocketAddress inetSocketAddress;
        if (osRemoteAddr != null) {
            void var1_1;
            if (PlatformDependent.javaVersion() >= 7) {
                try {
                    return new InetSocketAddress(InetAddress.getByAddress(remoteAddr.getHostString(), osRemoteAddr.getAddress().getAddress()), osRemoteAddr.getPort());
                }
                catch (UnknownHostException unknownHostException) {}
            }
            return var1_1;
        }
        return inetSocketAddress;
    }
}

