/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.unix.FileDescriptor;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class SocketWritableByteChannel
implements WritableByteChannel {
    protected final FileDescriptor fd;

    /*
     * WARNING - void declaration
     */
    protected SocketWritableByteChannel(FileDescriptor fd) {
        void var1_1;
        this.fd = (FileDescriptor)ObjectUtil.checkNotNull((Object)var1_1, (String)"fd");
    }

    /*
     * WARNING - void declaration
     */
    protected int write(ByteBuffer buf, int pos, int limit) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.fd.write((ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int write(ByteBuffer src) throws IOException {
        void var2_4;
        int written;
        int position = src.position();
        int limit = src.limit();
        if (src.isDirect()) {
            written = this.write(src, position, src.limit());
        } else {
            void readableBytes = written - position;
            ByteBuf buffer = null;
            try {
                ByteBuffer nioBuffer;
                if (readableBytes == false) {
                    buffer = Unpooled.EMPTY_BUFFER;
                } else {
                    ByteBufAllocator alloc = this.alloc();
                    if (alloc.isDirectBufferPooled()) {
                        buffer = alloc.directBuffer((int)readableBytes);
                    } else {
                        buffer = ByteBufUtil.threadLocalDirectBuffer();
                        if (buffer == null) {
                            buffer = Unpooled.directBuffer((int)readableBytes);
                        }
                    }
                }
                buffer.writeBytes(src.duplicate());
                ByteBuf byteBuf = buffer;
                ByteBuffer byteBuffer = nioBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), (int)readableBytes);
                written = this.write(byteBuffer, byteBuffer.position(), nioBuffer.limit());
            }
            finally {
                if (buffer != null) {
                    buffer.release();
                }
            }
        }
        if (written > 0) {
            void var3_3;
            void var1_1;
            var1_1.position((int)(var3_3 + written));
        }
        return (int)var2_4;
    }

    @Override
    public final boolean isOpen() {
        return this.fd.isOpen();
    }

    @Override
    public final void close() throws IOException {
        this.fd.close();
    }

    protected abstract ByteBufAllocator alloc();
}

