/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.channel.ChannelException;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.DatagramSocketAddress;
import io.netty.channel.unix.DomainDatagramSocketAddress;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

public class Socket
extends FileDescriptor {
    private static volatile boolean isIpv6Preferred;
    @Deprecated
    public static final int UDS_SUN_PATH_SIZE = 100;
    protected final boolean ipv6;

    /*
     * WARNING - void declaration
     */
    public Socket(int fd) {
        super(fd);
        void var1_1;
        this.ipv6 = Socket.isIPv6((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean useIpv6(InetAddress address) {
        void var1_1;
        return Socket.useIpv6(this, (InetAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean useIpv6(Socket socket, InetAddress address) {
        void var1_1;
        return socket.ipv6 || var1_1 instanceof Inet6Address;
    }

    public final void shutdown() throws IOException {
        this.shutdown(true, true);
    }

    /*
     * WARNING - void declaration
     */
    public final void shutdown(boolean read, boolean write) throws IOException {
        void var2_2;
        void var1_1;
        int newState;
        int oldState;
        do {
            if (Socket.isClosed(oldState = this.state)) {
                throw new ClosedChannelException();
            }
            newState = oldState;
            if (read && !Socket.isInputShutdown(newState)) {
                newState = Socket.inputShutdown(newState);
            }
            if (write && !Socket.isOutputShutdown(newState)) {
                newState = Socket.outputShutdown(newState);
            }
            if (newState != oldState) continue;
            return;
        } while (!this.casState(oldState, newState));
        int res = Socket.shutdown(this.fd, (boolean)var1_1, (boolean)var2_2);
        if (res < 0) {
            void var3_3;
            Errors.ioResult("shutdown", (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isShutdown() {
        void var1_1;
        int state = this.state;
        return Socket.isInputShutdown(state) && Socket.isOutputShutdown((int)var1_1);
    }

    public final boolean isInputShutdown() {
        return Socket.isInputShutdown(this.state);
    }

    public final boolean isOutputShutdown() {
        return Socket.isOutputShutdown(this.state);
    }

    /*
     * WARNING - void declaration
     */
    public final int sendTo(ByteBuffer buf, int pos, int limit, InetAddress addr, int port) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.sendTo((ByteBuffer)var1_1, (int)var2_2, (int)var3_3, addr, port, false);
    }

    /*
     * WARNING - void declaration
     */
    public final int sendTo(ByteBuffer buf, int pos, int limit, InetAddress addr, int port, boolean fastOpen) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        int scopeId;
        byte[] address;
        if (addr instanceof Inet6Address) {
            address = addr.getAddress();
            scopeId = ((Inet6Address)addr).getScopeId();
        } else {
            scopeId = 0;
            address = NativeInetAddress.ipv4MappedIpv6Address(addr.getAddress());
        }
        int flags = fastOpen ? Socket.msgFastopen() : 0;
        int res = Socket.sendTo(this.fd, this.useIpv6(addr), buf, (int)var2_3, (int)var3_4, address, scopeId, port, flags);
        if (res >= 0) {
            return res;
        }
        if (res == Errors.ERRNO_EINPROGRESS_NEGATIVE && fastOpen) {
            return 0;
        }
        if (res == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendTo failed");
        }
        return Errors.ioResult("sendTo", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int sendToDomainSocket(ByteBuffer buf, int pos, int limit, byte[] path) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        int res = Socket.sendToDomainSocket(this.fd, buf, (int)var2_3, (int)var3_4, path);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("sendToDomainSocket", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int sendToAddress(long memoryAddress, int pos, int limit, InetAddress addr, int port) throws IOException {
        void var3_2;
        void var1_1;
        return this.sendToAddress((long)var1_1, (int)var3_2, limit, addr, port, false);
    }

    /*
     * WARNING - void declaration
     */
    public final int sendToAddress(long memoryAddress, int pos, int limit, InetAddress addr, int port, boolean fastOpen) throws IOException {
        void var1_2;
        void var3_3;
        int scopeId;
        byte[] address;
        if (addr instanceof Inet6Address) {
            address = addr.getAddress();
            scopeId = ((Inet6Address)addr).getScopeId();
        } else {
            scopeId = 0;
            address = NativeInetAddress.ipv4MappedIpv6Address(addr.getAddress());
        }
        int flags = fastOpen ? Socket.msgFastopen() : 0;
        int res = Socket.sendToAddress(this.fd, this.useIpv6(addr), memoryAddress, (int)var3_3, limit, address, scopeId, port, flags);
        if (res >= 0) {
            return res;
        }
        if (res == Errors.ERRNO_EINPROGRESS_NEGATIVE && fastOpen) {
            return 0;
        }
        if (res == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendToAddress failed");
        }
        return Errors.ioResult("sendToAddress", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int sendToAddressDomainSocket(long memoryAddress, int pos, int limit, byte[] path) throws IOException {
        void var1_2;
        void var3_3;
        int res = Socket.sendToAddressDomainSocket(this.fd, memoryAddress, (int)var3_3, limit, path);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("sendToAddressDomainSocket", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int sendToAddresses(long memoryAddress, int length, InetAddress addr, int port) throws IOException {
        void var3_2;
        void var1_1;
        return this.sendToAddresses((long)var1_1, (int)var3_2, addr, port, false);
    }

    /*
     * WARNING - void declaration
     */
    public final int sendToAddresses(long memoryAddress, int length, InetAddress addr, int port, boolean fastOpen) throws IOException {
        void var1_2;
        void var3_3;
        int scopeId;
        byte[] address;
        if (addr instanceof Inet6Address) {
            address = addr.getAddress();
            scopeId = ((Inet6Address)addr).getScopeId();
        } else {
            scopeId = 0;
            address = NativeInetAddress.ipv4MappedIpv6Address(addr.getAddress());
        }
        int flags = fastOpen ? Socket.msgFastopen() : 0;
        int res = Socket.sendToAddresses(this.fd, this.useIpv6(addr), memoryAddress, (int)var3_3, address, scopeId, port, flags);
        if (res >= 0) {
            return res;
        }
        if (res == Errors.ERRNO_EINPROGRESS_NEGATIVE && fastOpen) {
            return 0;
        }
        if (res == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendToAddresses failed");
        }
        return Errors.ioResult("sendToAddresses", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int sendToAddressesDomainSocket(long memoryAddress, int length, byte[] path) throws IOException {
        void var1_2;
        void var3_3;
        int res = Socket.sendToAddressesDomainSocket(this.fd, memoryAddress, (int)var3_3, path);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("sendToAddressesDomainSocket", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final DatagramSocketAddress recvFrom(ByteBuffer buf, int pos, int limit) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return Socket.recvFrom(this.fd, (ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final DatagramSocketAddress recvFromAddress(long memoryAddress, int pos, int limit) throws IOException {
        void var3_2;
        void var1_1;
        return Socket.recvFromAddress(this.fd, (long)var1_1, (int)var3_2, limit);
    }

    /*
     * WARNING - void declaration
     */
    public final DomainDatagramSocketAddress recvFromDomainSocket(ByteBuffer buf, int pos, int limit) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return Socket.recvFromDomainSocket(this.fd, (ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final DomainDatagramSocketAddress recvFromAddressDomainSocket(long memoryAddress, int pos, int limit) throws IOException {
        void var3_2;
        void var1_1;
        return Socket.recvFromAddressDomainSocket(this.fd, (long)var1_1, (int)var3_2, limit);
    }

    /*
     * WARNING - void declaration
     */
    public int recv(ByteBuffer buf, int pos, int limit) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        int res = Socket.recv(this.intValue(), buf, (int)var2_3, (int)var3_4);
        if (res > 0) {
            return res;
        }
        if (res == 0) {
            return -1;
        }
        return Errors.ioResult("recv", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public int recvAddress(long address, int pos, int limit) throws IOException {
        void var1_2;
        void var3_3;
        int res = Socket.recvAddress(this.intValue(), address, (int)var3_3, limit);
        if (res > 0) {
            return res;
        }
        if (res == 0) {
            return -1;
        }
        return Errors.ioResult("recvAddress", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public int send(ByteBuffer buf, int pos, int limit) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        int res = Socket.send(this.intValue(), buf, (int)var2_3, (int)var3_4);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("send", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public int sendAddress(long address, int pos, int limit) throws IOException {
        void var1_2;
        void var3_3;
        int res = Socket.sendAddress(this.intValue(), address, (int)var3_3, limit);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("sendAddress", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int recvFd() throws IOException {
        void var1_1;
        int res = Socket.recvFd(this.fd);
        if (res > 0) {
            return res;
        }
        if (res == 0) {
            return -1;
        }
        if (res == Errors.ERRNO_EAGAIN_NEGATIVE || res == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        throw Errors.newIOException("recvFd", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int sendFd(int fdToSend) throws IOException {
        void var1_1;
        int res = Socket.sendFd(this.fd, fdToSend);
        if (res >= 0) {
            return res;
        }
        if (res == Errors.ERRNO_EAGAIN_NEGATIVE || res == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("sendFd", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean connect(SocketAddress socketAddress) throws IOException {
        void res;
        int res2;
        if (socketAddress instanceof InetSocketAddress) {
            void var3_4;
            void var2_3;
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            NativeInetAddress address = NativeInetAddress.newInstance(inetAddress);
            res2 = Socket.connect(this.fd, this.useIpv6((InetAddress)var2_3), address.address, var3_4.scopeId, inetSocketAddress.getPort());
        } else if (res instanceof DomainSocketAddress) {
            DomainSocketAddress unixDomainSocketAddress = (DomainSocketAddress)res;
            res2 = Socket.connectDomainSocket(this.fd, unixDomainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        } else {
            throw new Error("Unexpected SocketAddress implementation " + res);
        }
        if (res2 < 0) {
            void var1_2;
            return Errors.handleConnectErrno("connect", (int)var1_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean finishConnect() throws IOException {
        int res = Socket.finishConnect(this.fd);
        if (res < 0) {
            void var1_1;
            return Errors.handleConnectErrno("finishConnect", (int)var1_1);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void disconnect() throws IOException {
        int res = Socket.disconnect(this.fd, this.ipv6);
        if (res < 0) {
            void var1_1;
            Errors.handleConnectErrno("disconnect", (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void bind(SocketAddress socketAddress) throws IOException {
        void var1_1;
        void res2;
        SocketAddress addr;
        if (socketAddress instanceof InetSocketAddress) {
            void var3_5;
            addr = (InetSocketAddress)socketAddress;
            InetAddress inetAddress = ((InetSocketAddress)addr).getAddress();
            NativeInetAddress address = NativeInetAddress.newInstance(inetAddress);
            int res2 = Socket.bind(this.fd, this.useIpv6(inetAddress), address.address, var3_5.scopeId, ((InetSocketAddress)addr).getPort());
            if (res2 < 0) {
                throw Errors.newIOException("bind", res2);
            }
            return;
        }
        if (res2 instanceof DomainSocketAddress) {
            addr = (DomainSocketAddress)res2;
            int res3 = Socket.bindDomainSocket(this.fd, var1_1.path().getBytes(CharsetUtil.UTF_8));
            if (res3 < 0) {
                void var2_4;
                throw Errors.newIOException("bind", (int)var2_4);
            }
            return;
        }
        throw new Error("Unexpected SocketAddress implementation " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void listen(int backlog) throws IOException {
        int res = Socket.listen(this.fd, backlog);
        if (res < 0) {
            void var1_1;
            throw Errors.newIOException("listen", (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int accept(byte[] addr) throws IOException {
        void var1_2;
        int res = Socket.accept(this.fd, addr);
        if (res >= 0) {
            return res;
        }
        if (res == Errors.ERRNO_EAGAIN_NEGATIVE || res == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("accept", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final InetSocketAddress remoteAddress() {
        void var1_1;
        byte[] addr = Socket.remoteAddress(this.fd);
        if (addr == null) {
            return null;
        }
        return NativeInetAddress.address(addr, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public final DomainSocketAddress remoteDomainSocketAddress() {
        void var1_1;
        byte[] addr = Socket.remoteDomainSocketAddress(this.fd);
        if (addr == null) {
            return null;
        }
        return new DomainSocketAddress(new String((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final InetSocketAddress localAddress() {
        void var1_1;
        byte[] addr = Socket.localAddress(this.fd);
        if (addr == null) {
            return null;
        }
        return NativeInetAddress.address(addr, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public final DomainSocketAddress localDomainSocketAddress() {
        void var1_1;
        byte[] addr = Socket.localDomainSocketAddress(this.fd);
        if (addr == null) {
            return null;
        }
        return new DomainSocketAddress(new String((byte[])var1_1));
    }

    public final int getReceiveBufferSize() throws IOException {
        return Socket.getReceiveBufferSize(this.fd);
    }

    public final int getSendBufferSize() throws IOException {
        return Socket.getSendBufferSize(this.fd);
    }

    public final boolean isKeepAlive() throws IOException {
        return Socket.isKeepAlive(this.fd) != 0;
    }

    public final boolean isTcpNoDelay() throws IOException {
        return Socket.isTcpNoDelay(this.fd) != 0;
    }

    public final boolean isReuseAddress() throws IOException {
        return Socket.isReuseAddress(this.fd) != 0;
    }

    public final boolean isReusePort() throws IOException {
        return Socket.isReusePort(this.fd) != 0;
    }

    public final boolean isBroadcast() throws IOException {
        return Socket.isBroadcast(this.fd) != 0;
    }

    public final int getSoLinger() throws IOException {
        return Socket.getSoLinger(this.fd);
    }

    public final int getSoError() throws IOException {
        return Socket.getSoError(this.fd);
    }

    public final int getTrafficClass() throws IOException {
        return Socket.getTrafficClass(this.fd, this.ipv6);
    }

    /*
     * WARNING - void declaration
     */
    public final void setKeepAlive(boolean keepAlive) throws IOException {
        void var1_1;
        Socket.setKeepAlive(this.fd, var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void setReceiveBufferSize(int receiveBufferSize) throws IOException {
        void var1_1;
        Socket.setReceiveBufferSize(this.fd, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSendBufferSize(int sendBufferSize) throws IOException {
        void var1_1;
        Socket.setSendBufferSize(this.fd, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTcpNoDelay(boolean tcpNoDelay) throws IOException {
        void var1_1;
        Socket.setTcpNoDelay(this.fd, var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSoLinger(int soLinger) throws IOException {
        void var1_1;
        Socket.setSoLinger(this.fd, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setReuseAddress(boolean reuseAddress) throws IOException {
        void var1_1;
        Socket.setReuseAddress(this.fd, var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void setReusePort(boolean reusePort) throws IOException {
        void var1_1;
        Socket.setReusePort(this.fd, var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBroadcast(boolean broadcast) throws IOException {
        void var1_1;
        Socket.setBroadcast(this.fd, var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTrafficClass(int trafficClass) throws IOException {
        void var1_1;
        Socket.setTrafficClass(this.fd, this.ipv6, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIntOpt(int level, int optname, int optvalue) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Socket.setIntOpt(this.fd, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void setRawOpt(int level, int optname, ByteBuffer optvalue) throws IOException {
        void var3_3;
        int limit = optvalue.limit();
        if (optvalue.isDirect()) {
            Socket.setRawOptAddress(this.fd, level, optname, Buffer.memoryAddress(optvalue) + (long)optvalue.position(), optvalue.remaining());
        } else if (optvalue.hasArray()) {
            Socket.setRawOptArray(this.fd, level, optname, optvalue.array(), optvalue.arrayOffset() + optvalue.position(), optvalue.remaining());
        } else {
            void var2_2;
            void var1_1;
            byte[] bytes = new byte[optvalue.remaining()];
            optvalue.duplicate().get(bytes);
            Socket.setRawOptArray(this.fd, (int)var1_1, (int)var2_2, bytes, 0, bytes.length);
        }
        var3_3.position(limit);
    }

    /*
     * WARNING - void declaration
     */
    public int getIntOpt(int level, int optname) throws IOException {
        void var2_2;
        void var1_1;
        return Socket.getIntOpt(this.fd, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void getRawOpt(int level, int optname, ByteBuffer out) throws IOException {
        void var3_3;
        if (out.isDirect()) {
            Socket.getRawOptAddress(this.fd, level, optname, Buffer.memoryAddress(out) + (long)out.position(), out.remaining());
        } else if (out.hasArray()) {
            Socket.getRawOptArray(this.fd, level, optname, out.array(), out.position() + out.arrayOffset(), out.remaining());
        } else {
            void var2_2;
            void var1_1;
            byte[] outArray = new byte[out.remaining()];
            Socket.getRawOptArray(this.fd, (int)var1_1, (int)var2_2, outArray, 0, outArray.length);
            out.put(outArray);
        }
        void v0 = var3_3;
        v0.position(v0.limit());
    }

    public static boolean isIPv6Preferred() {
        return isIpv6Preferred;
    }

    public static boolean shouldUseIpv6(InternetProtocolFamily family) {
        InternetProtocolFamily internetProtocolFamily;
        if (family == null) {
            return Socket.isIPv6Preferred();
        }
        return internetProtocolFamily == InternetProtocolFamily.IPv6;
    }

    private static native boolean isIPv6Preferred0(boolean var0);

    private static native boolean isIPv6(int var0);

    @Override
    public String toString() {
        return "Socket{fd=" + this.fd + '}';
    }

    public static Socket newSocketStream() {
        return new Socket(Socket.newSocketStream0());
    }

    public static Socket newSocketDgram() {
        return new Socket(Socket.newSocketDgram0());
    }

    public static Socket newSocketDomain() {
        return new Socket(Socket.newSocketDomain0());
    }

    public static Socket newSocketDomainDgram() {
        return new Socket(Socket.newSocketDomainDgram0());
    }

    public static void initialize() {
        isIpv6Preferred = Socket.isIPv6Preferred0(NetUtil.isIpV4StackPreferred());
    }

    protected static int newSocketStream0() {
        return Socket.newSocketStream0(Socket.isIPv6Preferred());
    }

    protected static int newSocketStream0(InternetProtocolFamily protocol) {
        return Socket.newSocketStream0(Socket.shouldUseIpv6(protocol));
    }

    protected static int newSocketStream0(boolean ipv6) {
        int n;
        int res = Socket.newSocketStreamFd(ipv6);
        if (res < 0) {
            throw new ChannelException((Throwable)Errors.newIOException("newSocketStream", res));
        }
        return (int)n;
    }

    protected static int newSocketDgram0() {
        return Socket.newSocketDgram0(Socket.isIPv6Preferred());
    }

    protected static int newSocketDgram0(InternetProtocolFamily family) {
        return Socket.newSocketDgram0(Socket.shouldUseIpv6(family));
    }

    protected static int newSocketDgram0(boolean ipv6) {
        int n;
        int res = Socket.newSocketDgramFd(ipv6);
        if (res < 0) {
            throw new ChannelException((Throwable)Errors.newIOException("newSocketDgram", res));
        }
        return (int)n;
    }

    /*
     * WARNING - void declaration
     */
    protected static int newSocketDomain0() {
        void var0;
        int res = Socket.newSocketDomainFd();
        if (res < 0) {
            throw new ChannelException((Throwable)Errors.newIOException("newSocketDomain", res));
        }
        return (int)var0;
    }

    /*
     * WARNING - void declaration
     */
    protected static int newSocketDomainDgram0() {
        void var0;
        int res = Socket.newSocketDomainDgramFd();
        if (res < 0) {
            throw new ChannelException((Throwable)Errors.newIOException("newSocketDomainDgram", res));
        }
        return (int)var0;
    }

    private static native int shutdown(int var0, boolean var1, boolean var2);

    private static native int connect(int var0, boolean var1, byte[] var2, int var3, int var4);

    private static native int connectDomainSocket(int var0, byte[] var1);

    private static native int finishConnect(int var0);

    private static native int disconnect(int var0, boolean var1);

    private static native int bind(int var0, boolean var1, byte[] var2, int var3, int var4);

    private static native int bindDomainSocket(int var0, byte[] var1);

    private static native int listen(int var0, int var1);

    private static native int accept(int var0, byte[] var1);

    private static native byte[] remoteAddress(int var0);

    private static native byte[] remoteDomainSocketAddress(int var0);

    private static native byte[] localAddress(int var0);

    private static native byte[] localDomainSocketAddress(int var0);

    private static native int send(int var0, ByteBuffer var1, int var2, int var3);

    private static native int sendAddress(int var0, long var1, int var3, int var4);

    private static native int recv(int var0, ByteBuffer var1, int var2, int var3);

    private static native int recvAddress(int var0, long var1, int var3, int var4);

    private static native int sendTo(int var0, boolean var1, ByteBuffer var2, int var3, int var4, byte[] var5, int var6, int var7, int var8);

    private static native int sendToAddress(int var0, boolean var1, long var2, int var4, int var5, byte[] var6, int var7, int var8, int var9);

    private static native int sendToAddresses(int var0, boolean var1, long var2, int var4, byte[] var5, int var6, int var7, int var8);

    private static native int sendToDomainSocket(int var0, ByteBuffer var1, int var2, int var3, byte[] var4);

    private static native int sendToAddressDomainSocket(int var0, long var1, int var3, int var4, byte[] var5);

    private static native int sendToAddressesDomainSocket(int var0, long var1, int var3, byte[] var4);

    private static native DatagramSocketAddress recvFrom(int var0, ByteBuffer var1, int var2, int var3) throws IOException;

    private static native DatagramSocketAddress recvFromAddress(int var0, long var1, int var3, int var4) throws IOException;

    private static native DomainDatagramSocketAddress recvFromDomainSocket(int var0, ByteBuffer var1, int var2, int var3) throws IOException;

    private static native DomainDatagramSocketAddress recvFromAddressDomainSocket(int var0, long var1, int var3, int var4) throws IOException;

    private static native int recvFd(int var0);

    private static native int sendFd(int var0, int var1);

    private static native int msgFastopen();

    private static native int newSocketStreamFd(boolean var0);

    private static native int newSocketDgramFd(boolean var0);

    private static native int newSocketDomainFd();

    private static native int newSocketDomainDgramFd();

    private static native int isReuseAddress(int var0) throws IOException;

    private static native int isReusePort(int var0) throws IOException;

    private static native int getReceiveBufferSize(int var0) throws IOException;

    private static native int getSendBufferSize(int var0) throws IOException;

    private static native int isKeepAlive(int var0) throws IOException;

    private static native int isTcpNoDelay(int var0) throws IOException;

    private static native int isBroadcast(int var0) throws IOException;

    private static native int getSoLinger(int var0) throws IOException;

    private static native int getSoError(int var0) throws IOException;

    private static native int getTrafficClass(int var0, boolean var1) throws IOException;

    private static native void setReuseAddress(int var0, int var1) throws IOException;

    private static native void setReusePort(int var0, int var1) throws IOException;

    private static native void setKeepAlive(int var0, int var1) throws IOException;

    private static native void setReceiveBufferSize(int var0, int var1) throws IOException;

    private static native void setSendBufferSize(int var0, int var1) throws IOException;

    private static native void setTcpNoDelay(int var0, int var1) throws IOException;

    private static native void setSoLinger(int var0, int var1) throws IOException;

    private static native void setBroadcast(int var0, int var1) throws IOException;

    private static native void setTrafficClass(int var0, boolean var1, int var2) throws IOException;

    private static native void setIntOpt(int var0, int var1, int var2, int var3) throws IOException;

    private static native void setRawOptArray(int var0, int var1, int var2, byte[] var3, int var4, int var5) throws IOException;

    private static native void setRawOptAddress(int var0, int var1, int var2, long var3, int var5) throws IOException;

    private static native int getIntOpt(int var0, int var1, int var2) throws IOException;

    private static native void getRawOptArray(int var0, int var1, int var2, byte[] var3, int var4, int var5) throws IOException;

    private static native void getRawOptAddress(int var0, int var1, int var2, long var3, int var5) throws IOException;
}

