/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class NativeInetAddress {
    private static final byte[] IPV4_MAPPED_IPV6_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    final byte[] address;
    final int scopeId;

    /*
     * WARNING - void declaration
     */
    public static NativeInetAddress newInstance(InetAddress addr) {
        void var1_1;
        byte[] bytes = addr.getAddress();
        if (addr instanceof Inet6Address) {
            InetAddress inetAddress;
            return new NativeInetAddress(bytes, ((Inet6Address)inetAddress).getScopeId());
        }
        return new NativeInetAddress(NativeInetAddress.ipv4MappedIpv6Address((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public NativeInetAddress(byte[] address, int scopeId) {
        void var2_2;
        void var1_1;
        this.address = var1_1;
        this.scopeId = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public NativeInetAddress(byte[] address) {
        this((byte[])var1_1, 0);
        void var1_1;
    }

    public final byte[] address() {
        return this.address;
    }

    public final int scopeId() {
        return this.scopeId;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] ipv4MappedIpv6Address(byte[] ipv4) {
        void var1_1;
        byte[] byArray;
        byte[] address = new byte[16];
        NativeInetAddress.copyIpv4MappedIpv6Address(byArray, address);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void copyIpv4MappedIpv6Address(byte[] ipv4, byte[] ipv6) {
        byte[] byArray;
        void var1_1;
        System.arraycopy(IPV4_MAPPED_IPV6_PREFIX, 0, ipv6, 0, IPV4_MAPPED_IPV6_PREFIX.length);
        System.arraycopy(ipv4, 0, var1_1, 12, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static InetSocketAddress address(byte[] addr, int offset, int len) {
        int port = NativeInetAddress.decodeInt(addr, offset + len - 4);
        try {
            void var3_6;
            Object object;
            switch (len) {
                case 8: {
                    byte[] ipv4 = new byte[4];
                    System.arraycopy(addr, offset, ipv4, 0, 4);
                    Object address = InetAddress.getByAddress(ipv4);
                    break;
                }
                case 24: {
                    void ipv4;
                    void var1_2;
                    Object address;
                    byte[] ipv6 = new byte[16];
                    System.arraycopy(address, offset, ipv6, 0, 16);
                    int scopeId = NativeInetAddress.decodeInt(address, (int)(var1_2 + ipv4 - 8));
                    if (scopeId != 0 || ipv6[0] == -2 && ipv6[1] == -128) {
                        address = Inet6Address.getByAddress(null, ipv6, scopeId);
                        break;
                    }
                    address = InetAddress.getByAddress(null, ipv6);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return new InetSocketAddress((InetAddress)object, (int)var3_6);
        }
        catch (UnknownHostException e) {
            void var2_5;
            throw new Error("Should never happen", (Throwable)var2_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    static int decodeInt(byte[] addr, int index) {
        void var1_1;
        byte[] byArray;
        return (addr[index] & 0xFF) << 24 | (addr[index + 1] & 0xFF) << 16 | (addr[index + 2] & 0xFF) << 8 | byArray[var1_1 + 3] & 0xFF;
    }
}

