/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Limits;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class IovArray
implements ChannelOutboundBuffer.MessageProcessor {
    private static final int ADDRESS_SIZE = Buffer.addressSize();
    public static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int MAX_CAPACITY = Limits.IOV_MAX * IOV_SIZE;
    private final long memoryAddress;
    private final ByteBuf memory;
    private int count;
    private long size;
    private long maxBytes = Limits.SSIZE_MAX;

    public IovArray() {
        this(Unpooled.wrappedBuffer((ByteBuffer)Buffer.allocateDirectWithNativeOrder(MAX_CAPACITY)).setIndex(0, 0));
    }

    /*
     * WARNING - void declaration
     */
    public IovArray(ByteBuf memory) {
        void var1_1;
        assert (memory.writerIndex() == 0);
        assert (memory.readerIndex() == 0);
        ByteBuf byteBuf = PlatformDependent.hasUnsafe() ? memory : (this.memory = memory.order(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN));
        if (memory.hasMemoryAddress()) {
            this.memoryAddress = memory.memoryAddress();
            return;
        }
        this.memoryAddress = Buffer.memoryAddress(memory.internalNioBuffer(0, var1_1.capacity()));
    }

    public final void clear() {
        this.count = 0;
        this.size = 0L;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final boolean add(ByteBuf buf) {
        void var1_1;
        ByteBuf byteBuf = buf;
        return this.add(byteBuf, byteBuf.readerIndex(), var1_1.readableBytes());
    }

    public final boolean add(ByteBuf buf, int offset, int len) {
        int n;
        int n2;
        ByteBuffer[] byteBufferArray;
        if (this.count == Limits.IOV_MAX) {
            return false;
        }
        if (buf.nioBufferCount() == 1) {
            if (len == 0) {
                return true;
            }
            if (buf.hasMemoryAddress()) {
                IovArray iovArray = this;
                return iovArray.add(iovArray.memoryAddress, buf.memoryAddress() + (long)offset, len);
            }
            ByteBuffer nioBuffer = buf.internalNioBuffer(offset, len);
            IovArray iovArray = this;
            return iovArray.add(iovArray.memoryAddress, Buffer.memoryAddress(nioBuffer) + (long)byteBufferArray.position(), len);
        }
        ByteBuffer[] byteBufferArray2 = byteBufferArray.nioBuffers(n2, n);
        byteBufferArray = byteBufferArray2;
        byteBufferArray = byteBufferArray2;
        n2 = byteBufferArray2.length;
        for (n = 0; n < n2; ++n) {
            ByteBuffer nioBuffer = byteBufferArray[n];
            int remaining = nioBuffer.remaining();
            if (remaining == 0) continue;
            IovArray iovArray = this;
            if (iovArray.add(iovArray.memoryAddress, Buffer.memoryAddress(nioBuffer) + (long)nioBuffer.position(), remaining) && this.count != Limits.IOV_MAX) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean add(long memoryAddress, long addr, int len) {
        assert (addr != 0L);
        if (this.maxBytes - (long)len < this.size && this.count > 0 || this.memory.capacity() < (this.count + 1) * IOV_SIZE) {
            return false;
        }
        int baseOffset = IovArray.idx(this.count);
        int lengthOffset = baseOffset + ADDRESS_SIZE;
        this.size += (long)len;
        ++this.count;
        if (ADDRESS_SIZE == 8) {
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putLong((long)((long)baseOffset + memoryAddress), (long)addr);
                PlatformDependent.putLong((long)((long)lengthOffset + memoryAddress), (long)len);
            } else {
                this.memory.setLong(baseOffset, addr);
                this.memory.setLong(lengthOffset, (long)len);
            }
        } else {
            assert (ADDRESS_SIZE == 4);
            if (PlatformDependent.hasUnsafe()) {
                void var1_1;
                PlatformDependent.putInt((long)((long)baseOffset + memoryAddress), (int)((int)addr));
                PlatformDependent.putInt((long)((long)lengthOffset + var1_1), (int)len);
            } else {
                void var3_2;
                this.memory.setInt(baseOffset, (int)var3_2);
                this.memory.setInt(lengthOffset, len);
            }
        }
        return true;
    }

    public final int count() {
        return this.count;
    }

    public final long size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final void maxBytes(long maxBytes) {
        void var1_1;
        this.maxBytes = Math.min(Limits.SSIZE_MAX, ObjectUtil.checkPositive((long)var1_1, (String)"maxBytes"));
    }

    public final long maxBytes() {
        return this.maxBytes;
    }

    /*
     * WARNING - void declaration
     */
    public final long memoryAddress(int offset) {
        void var1_1;
        return this.memoryAddress + (long)IovArray.idx((int)var1_1);
    }

    public final void release() {
        this.memory.release();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean processMessage(Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            void var1_1;
            ByteBuf buffer;
            ByteBuf byteBuf = buffer = (ByteBuf)msg;
            return this.add(byteBuf, byteBuf.readerIndex(), var1_1.readableBytes());
        }
        return false;
    }

    private static int idx(int index) {
        int n;
        return IOV_SIZE * n;
    }
}

