/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.channel.unix.Errors;
import io.netty.channel.unix.Limits;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class FileDescriptor {
    private static final AtomicIntegerFieldUpdater<FileDescriptor> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(FileDescriptor.class, "state");
    private static final int STATE_CLOSED_MASK = 1;
    private static final int STATE_INPUT_SHUTDOWN_MASK = 2;
    private static final int STATE_OUTPUT_SHUTDOWN_MASK = 4;
    private static final int STATE_ALL_MASK = 7;
    volatile int state;
    final int fd;

    /*
     * WARNING - void declaration
     */
    public FileDescriptor(int fd) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)fd, (String)"fd");
        this.fd = var1_1;
    }

    public final int intValue() {
        return this.fd;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean markClosed() {
        void v0;
        do {
            void var1_1;
            int state;
            if (FileDescriptor.isClosed(state = this.state)) {
                return false;
            }
            v0 = var1_1;
        } while (!this.casState((int)v0, v0 | 7));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void close() throws IOException {
        int res;
        if (this.markClosed() && (res = FileDescriptor.close(this.fd)) < 0) {
            void var1_1;
            throw Errors.newIOException("close", (int)var1_1);
        }
    }

    public boolean isOpen() {
        return !FileDescriptor.isClosed(this.state);
    }

    /*
     * WARNING - void declaration
     */
    public final int write(ByteBuffer buf, int pos, int limit) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        int res = FileDescriptor.write(this.fd, buf, (int)var2_3, (int)var3_4);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("write", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int writeAddress(long address, int pos, int limit) throws IOException {
        void var1_2;
        void var3_3;
        int res = FileDescriptor.writeAddress(this.fd, address, (int)var3_3, limit);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("writeAddress", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final long writev(ByteBuffer[] buffers, int offset, int length, long maxBytesToWrite) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        long res = FileDescriptor.writev(this.fd, (ByteBuffer[])var1_1, (int)var2_2, Math.min(Limits.IOV_MAX, (int)var3_3), maxBytesToWrite);
        if (res >= 0L) {
            return res;
        }
        return Errors.ioResult("writev", (int)res);
    }

    /*
     * WARNING - void declaration
     */
    public final long writevAddresses(long memoryAddress, int length) throws IOException {
        void var3_2;
        void var1_1;
        long res = FileDescriptor.writevAddresses(this.fd, (long)var1_1, (int)var3_2);
        if (res >= 0L) {
            return res;
        }
        return Errors.ioResult("writevAddresses", (int)res);
    }

    /*
     * WARNING - void declaration
     */
    public final int read(ByteBuffer buf, int pos, int limit) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        int res = FileDescriptor.read(this.fd, buf, (int)var2_3, (int)var3_4);
        if (res > 0) {
            return res;
        }
        if (res == 0) {
            return -1;
        }
        return Errors.ioResult("read", (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int readAddress(long address, int pos, int limit) throws IOException {
        void var1_2;
        void var3_3;
        int res = FileDescriptor.readAddress(this.fd, address, (int)var3_3, limit);
        if (res > 0) {
            return res;
        }
        if (res == 0) {
            return -1;
        }
        return Errors.ioResult("readAddress", (int)var1_2);
    }

    public String toString() {
        return "FileDescriptor{fd=" + this.fd + '}';
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileDescriptor)) {
            return false;
        }
        return this.fd == ((FileDescriptor)var1_1).fd;
    }

    public int hashCode() {
        return this.fd;
    }

    /*
     * WARNING - void declaration
     */
    public static FileDescriptor from(String path) throws IOException {
        void var0_1;
        int res = FileDescriptor.open((String)ObjectUtil.checkNotNull((Object)path, (String)"path"));
        if (res < 0) {
            throw Errors.newIOException("open", res);
        }
        return new FileDescriptor((int)var0_1);
    }

    public static FileDescriptor from(File file) throws IOException {
        return FileDescriptor.from(((File)ObjectUtil.checkNotNull((Object)file, (String)"file")).getPath());
    }

    /*
     * WARNING - void declaration
     */
    public static FileDescriptor[] pipe() throws IOException {
        void var0;
        long res = FileDescriptor.newPipe();
        if (res < 0L) {
            throw Errors.newIOException("newPipe", (int)res);
        }
        return new FileDescriptor[]{new FileDescriptor((int)(res >>> 32)), new FileDescriptor((int)var0)};
    }

    /*
     * WARNING - void declaration
     */
    final boolean casState(int expected, int update) {
        void var2_2;
        void var1_1;
        return stateUpdater.compareAndSet(this, (int)var1_1, (int)var2_2);
    }

    static boolean isClosed(int state) {
        return (state & 1) != 0;
    }

    static boolean isInputShutdown(int state) {
        return (state & 2) != 0;
    }

    static boolean isOutputShutdown(int state) {
        return (state & 4) != 0;
    }

    static int inputShutdown(int state) {
        return state | 2;
    }

    static int outputShutdown(int state) {
        return state | 4;
    }

    private static native int open(String var0);

    private static native int close(int var0);

    private static native int write(int var0, ByteBuffer var1, int var2, int var3);

    private static native int writeAddress(int var0, long var1, int var3, int var4);

    private static native long writev(int var0, ByteBuffer[] var1, int var2, int var3, long var4);

    private static native long writevAddresses(int var0, long var1, int var3);

    private static native int read(int var0, ByteBuffer var1, int var2, int var3);

    private static native int readAddress(int var0, long var1, int var3, int var4);

    private static native long newPipe();
}

