/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.channel.unix.ErrorsStaticallyReferencedJniMethods;
import io.netty.util.internal.EmptyArrays;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;

public final class Errors {
    public static final int ERRNO_ENOENT_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoENOENT();
    public static final int ERRNO_ENOTCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoENOTCONN();
    public static final int ERRNO_EBADF_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEBADF();
    public static final int ERRNO_EPIPE_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEPIPE();
    public static final int ERRNO_ECONNRESET_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoECONNRESET();
    public static final int ERRNO_EAGAIN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEAGAIN();
    public static final int ERRNO_EWOULDBLOCK_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEWOULDBLOCK();
    public static final int ERRNO_EINPROGRESS_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEINPROGRESS();
    public static final int ERROR_ECONNREFUSED_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorECONNREFUSED();
    public static final int ERROR_EISCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorEISCONN();
    public static final int ERROR_EALREADY_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorEALREADY();
    public static final int ERROR_ENETUNREACH_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorENETUNREACH();
    public static final int ERROR_EHOSTUNREACH_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorEHOSTUNREACH();
    private static final String[] ERRORS = new String[2048];

    /*
     * WARNING - void declaration
     */
    public static boolean handleConnectErrno(String method, int err) throws IOException {
        void var1_1;
        String string;
        if (err == ERRNO_EINPROGRESS_NEGATIVE || err == ERROR_EALREADY_NEGATIVE) {
            return false;
        }
        throw Errors.newConnectException0(string, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void throwConnectException(String method, int err) throws IOException {
        void var1_1;
        String string;
        if (err == ERROR_EALREADY_NEGATIVE) {
            throw new ConnectionPendingException();
        }
        throw Errors.newConnectException0(string, (int)var1_1);
    }

    private static String errnoString(int err) {
        int n;
        if (err < ERRORS.length - 1) {
            return ERRORS[err];
        }
        return ErrorsStaticallyReferencedJniMethods.strError(n);
    }

    /*
     * WARNING - void declaration
     */
    private static IOException newConnectException0(String method, int err) {
        void var1_1;
        String string;
        if (err == ERROR_ENETUNREACH_NEGATIVE || err == ERROR_EHOSTUNREACH_NEGATIVE) {
            return new NoRouteToHostException();
        }
        if (err == ERROR_EISCONN_NEGATIVE) {
            throw new AlreadyConnectedException();
        }
        if (err == ERRNO_ENOENT_NEGATIVE) {
            return new FileNotFoundException();
        }
        return new ConnectException(string + "(..) failed: " + Errors.errnoString((int)(-var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static NativeIoException newConnectionResetException(String method, int errnoNegative) {
        NativeIoException nativeIoException;
        void var1_1;
        NativeIoException exception = new NativeIoException(method, (int)var1_1, false);
        exception.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        return nativeIoException;
    }

    /*
     * WARNING - void declaration
     */
    public static NativeIoException newIOException(String method, int err) {
        void var1_1;
        String string;
        return new NativeIoException(string, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int ioResult(String method, int err, NativeIoException resetCause, ClosedChannelException closedCause) throws IOException {
        void var1_1;
        String string;
        if (err == ERRNO_EAGAIN_NEGATIVE || err == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        if (err == resetCause.expectedErr()) {
            void var2_2;
            throw var2_2;
        }
        if (err == ERRNO_EBADF_NEGATIVE) {
            void var3_3;
            throw var3_3;
        }
        if (err == ERRNO_ENOTCONN_NEGATIVE) {
            throw new NotYetConnectedException();
        }
        if (err == ERRNO_ENOENT_NEGATIVE) {
            throw new FileNotFoundException();
        }
        throw Errors.newIOException(string, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int ioResult(String method, int err) throws IOException {
        void var1_1;
        String string;
        if (err == ERRNO_EAGAIN_NEGATIVE || err == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        if (err == ERRNO_EBADF_NEGATIVE) {
            throw new ClosedChannelException();
        }
        if (err == ERRNO_ENOTCONN_NEGATIVE) {
            throw new NotYetConnectedException();
        }
        if (err == ERRNO_ENOENT_NEGATIVE) {
            throw new FileNotFoundException();
        }
        throw new NativeIoException(string, (int)var1_1, false);
    }

    private Errors() {
    }

    static {
        int i = 0;
        while (i < ERRORS.length) {
            int n = i++;
            Errors.ERRORS[n] = ErrorsStaticallyReferencedJniMethods.strError(n);
        }
    }

    static final class NativeConnectException
    extends ConnectException {
        private static final long serialVersionUID = -5532328671712318161L;
        private final int expectedErr;

        /*
         * WARNING - void declaration
         */
        NativeConnectException(String method, int expectedErr) {
            super((String)var1_1 + "(..) failed: " + Errors.errnoString(-expectedErr));
            void var2_2;
            void var1_1;
            this.expectedErr = var2_2;
        }

        final int expectedErr() {
            return this.expectedErr;
        }
    }

    public static final class NativeIoException
    extends IOException {
        private static final long serialVersionUID = 8222160204268655526L;
        private final int expectedErr;
        private final boolean fillInStackTrace;

        /*
         * WARNING - void declaration
         */
        public NativeIoException(String method, int expectedErr) {
            this((String)var1_1, (int)var2_2, true);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public NativeIoException(String method, int expectedErr, boolean fillInStackTrace) {
            super((String)var1_1 + "(..) failed: " + Errors.errnoString(-expectedErr));
            void var3_3;
            void var2_2;
            void var1_1;
            this.expectedErr = var2_2;
            this.fillInStackTrace = var3_3;
        }

        public final int expectedErr() {
            return this.expectedErr;
        }

        @Override
        public final synchronized Throwable fillInStackTrace() {
            if (this.fillInStackTrace) {
                return super.fillInStackTrace();
            }
            return this;
        }
    }
}

