/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\b\u0010\u000f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u0011H\u0007J\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/compose/runtime/snapshots/SnapshotDoubleIndexHeap;", "", "()V", "firstFreeHandle", "", "handles", "", "index", "<set-?>", "size", "getSize", "()I", "values", "add", "value", "allocateHandle", "ensure", "", "atLeast", "freeHandle", "handle", "lowestOrDefault", "default", "remove", "shiftDown", "shiftUp", "swap", "a", "b", "validate", "validateHandle", "runtime"})
@StabilityInferred(parameters=0)
public final class SnapshotDoubleIndexHeap {
    private int size;
    private int[] values = new int[16];
    private int[] index = new int[16];
    private int[] handles;
    private int firstFreeHandle;
    public static final int $stable = 8;

    public SnapshotDoubleIndexHeap() {
        int n = 0;
        int[] nArray = new int[16];
        SnapshotDoubleIndexHeap snapshotDoubleIndexHeap = this;
        while (n < 16) {
            int n2;
            int n3 = n2 = n++;
            nArray[n3] = n3 + 1;
        }
        snapshotDoubleIndexHeap.handles = nArray;
    }

    public final int getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final int lowestOrDefault(int n) {
        void var1_1;
        if (this.size > 0) {
            return this.values[0];
        }
        return (int)var1_1;
    }

    public static /* synthetic */ int lowestOrDefault$default(SnapshotDoubleIndexHeap snapshotDoubleIndexHeap, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return snapshotDoubleIndexHeap.lowestOrDefault(n);
    }

    /*
     * WARNING - void declaration
     */
    public final int add(int value) {
        void var2_3;
        void var1_1;
        SnapshotDoubleIndexHeap snapshotDoubleIndexHeap = this;
        snapshotDoubleIndexHeap.ensure(snapshotDoubleIndexHeap.size + 1);
        int n = this.size;
        this.size = n + 1;
        int i = n;
        int handle = this.allocateHandle();
        this.values[i] = var1_1;
        this.index[i] = handle;
        this.handles[handle] = i;
        this.shiftUp((int)var2_3);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final void remove(int handle) {
        void var1_1;
        void var2_2;
        int i = this.handles[handle];
        this.swap(i, this.size - 1);
        int n = this.size;
        this.size = n + -1;
        this.shiftUp(i);
        this.shiftDown((int)var2_2);
        this.freeHandle((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void validate() {
        int n = this.size;
        for (int index = 1; index < n; ++index) {
            void var3_3;
            int parent = (index + 1 >> 1) - 1;
            if (this.values[var3_3] <= this.values[index]) continue;
            throw new IllegalStateException(("Index " + index + " is out of place").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void validateHandle(int handle, int value) {
        int i = this.handles[handle];
        if (this.index[i] != handle) {
            throw new IllegalStateException(("Index for handle " + handle + " is corrupted").toString());
        }
        if (this.values[i] != value) {
            void var2_2;
            void var3_3;
            void var1_1;
            throw new IllegalStateException(("Value for handle " + (int)var1_1 + " was " + this.values[var3_3] + " but was supposed to be " + (int)var2_2).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void shiftUp(int index) {
        void parent;
        void current;
        int[] values = this.values;
        int value = this.values[index];
        while (current > 0 && values[parent = (current + true >> 1) - true] > value) {
            this.swap((int)parent, (int)current);
            current = parent;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void shiftDown(int index) {
        void current;
        int[] values = this.values;
        int half = this.size >> 1;
        while (current < half) {
            void right = current + true << 1;
            void left = right - true;
            if (right < this.size && values[right] < values[left]) {
                if (values[right] < values[current]) {
                    this.swap((int)right, (int)current);
                    current = right;
                    continue;
                }
                return;
            }
            if (values[left] < values[current]) {
                this.swap((int)left, (int)current);
                current = left;
                continue;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void swap(int a, int b) {
        void var2_2;
        void var1_1;
        int[] values = this.values;
        int[] index = this.index;
        int[] handles = this.handles;
        int t = values[a];
        values[a] = values[b];
        var3_3[b] = t;
        t = index[a];
        index[a] = index[b];
        index[b] = t;
        handles[index[a]] = var1_1;
        handles[index[b]] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final void ensure(int atLeast) {
        void var1_2;
        void var2_4;
        int capacity = this.values.length;
        if (atLeast <= capacity) {
            return;
        }
        int newCapacity = capacity << 1;
        int[] newValues = new int[newCapacity];
        int[] newIndex = new int[newCapacity];
        ArraysKt.copyInto$default((int[])this.values, (int[])newValues, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.copyInto$default((int[])this.index, (int[])newIndex, (int)0, (int)0, (int)0, (int)14, null);
        this.values = var2_4;
        this.index = var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private final int allocateHandle() {
        void var1_1;
        int capacity = this.handles.length;
        if (this.firstFreeHandle >= capacity) {
            int n = 0;
            int[] nArray = new int[capacity <<= 1];
            while (n < capacity) {
                int n2;
                int n3 = n2 = n++;
                nArray[n3] = n3 + 1;
            }
            int[] newHandles = nArray;
            ArraysKt.copyInto$default((int[])this.handles, (int[])newHandles, (int)0, (int)0, (int)0, (int)14, null);
            this.handles = newHandles;
        }
        int handle = this.firstFreeHandle;
        this.firstFreeHandle = this.handles[this.firstFreeHandle];
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final void freeHandle(int handle) {
        void var1_1;
        this.handles[handle] = this.firstFreeHandle;
        this.firstFreeHandle = var1_1;
    }
}

