/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.reflect;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.reflect.ComposableInfo;
import androidx.compose.runtime.reflect.ComposableMethodKt;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0003J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\bH\u0016J:\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\f\"\u0004\u0018\u00010\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Landroidx/compose/runtime/reflect/ComposableMethod;", "", "method", "Ljava/lang/reflect/Method;", "composableInfo", "Landroidx/compose/runtime/reflect/ComposableInfo;", "(Ljava/lang/reflect/Method;Landroidx/compose/runtime/reflect/ComposableInfo;)V", "parameterCount", "", "getParameterCount", "()I", "parameterTypes", "", "Ljava/lang/Class;", "getParameterTypes", "()[Ljava/lang/Class;", "parameters", "Ljava/lang/reflect/Parameter;", "getParameters", "()[Ljava/lang/reflect/Parameter;", "asMethod", "equals", "", "other", "hashCode", "invoke", "composer", "Landroidx/compose/runtime/Composer;", "instance", "args", "(Landroidx/compose/runtime/Composer;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposableMethod.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposableMethod.jvm.kt\nandroidx/compose/runtime/reflect/ComposableMethod\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1549#2:223\n1620#2,3:224\n1804#2,4:227\n*S KotlinDebug\n*F\n+ 1 ComposableMethod.jvm.kt\nandroidx/compose/runtime/reflect/ComposableMethod\n*L\n145#1:223\n145#1:224,3\n146#1:227,4\n*E\n"})
public final class ComposableMethod {
    private final Method method;
    private final ComposableInfo composableInfo;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public ComposableMethod(Method method, ComposableInfo composableInfo) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)composableInfo, (String)"composableInfo");
        this.method = var1_1;
        this.composableInfo = var2_2;
    }

    public final Method asMethod() {
        return this.method;
    }

    public final int getParameterCount() {
        return this.composableInfo.getRealParamsCount();
    }

    public final Parameter[] getParameters() {
        Parameter[] parameterArray = this.method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
        Object[] objectArray = parameterArray;
        int n = this.composableInfo.getRealParamsCount();
        return (Parameter[])ArraysKt.copyOfRange((Object[])objectArray, (int)0, (int)n);
    }

    public final Class<?>[] getParameterTypes() {
        Class<?>[] classArray = this.method.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
        Object[] objectArray = classArray;
        int n = this.composableInfo.getRealParamsCount();
        return (Class[])ArraysKt.copyOfRange((Object[])objectArray, (int)0, (int)n);
    }

    /*
     * WARNING - void declaration
     */
    public final Object invoke(Composer composer, Object instance, Object ... args) {
        void var2_2;
        Object[] objectArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ComposableInfo composableInfo = this.composableInfo;
        int realParamsCount = composableInfo.component2();
        int changedParams = composableInfo.component3();
        int defaultParams = composableInfo.component4();
        int totalParams = this.method.getParameterTypes().length;
        int changedStartIndex = realParamsCount + 1;
        int defaultStartIndex = changedStartIndex + changedParams;
        Integer[] integerArray = new Integer[defaultParams];
        for (int i = 0; i < defaultParams; ++i) {
            int n2;
            void $this$foldIndexed$iv2;
            Collection<Integer> $this$mapTo$iv$iv;
            void $this$map$iv;
            int n3;
            int n4 = n3 = i;
            int start22 = n4 * 31;
            int end22 = Math.min(start22 + 31, realParamsCount);
            Iterable iterable = (Iterable)RangesKt.until((int)start22, (int)end22);
            n = n4;
            objectArray = integerArray;
            void start22 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            Object end22 = $this$mapTo$iv$iv.iterator();
            while (end22.hasNext()) {
                void it;
                int item$iv$iv;
                int n5 = item$iv$iv = ((IntIterator)end22).nextInt();
                $this$mapTo$iv$iv = destination$iv$iv;
                $this$mapTo$iv$iv.add(it >= args.length || args[it] == null ? 1 : 0);
            }
            $this$mapTo$iv$iv = (List)destination$iv$iv;
            end22 = $this$mapTo$iv$iv;
            destination$iv$iv = (Iterable)end22;
            int index$iv = 0;
            boolean accumulator$iv = false;
            for (Object element$iv : $this$foldIndexed$iv2) {
                void default_;
                void mask;
                if (($this$foldIndexed$iv2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n6 = $this$foldIndexed$iv2;
                int $this$foldIndexed$iv2 = ((Number)element$iv).intValue();
                int i2 = n6;
                n2 = mask | default_ << i2;
            }
            void var12_20 = n2;
            n3 = var12_20;
            objectArray[n] = n3;
        }
        Integer[] defaultsMasks = integerArray;
        Object[] objectArray2 = new Object[totalParams];
        for (int i = 0; i < totalParams; ++i) {
            Object object;
            int n7;
            int n8 = i;
            Object[] objectArray3 = objectArray2;
            int n9 = n8;
            boolean bl = n7 >= 0 ? n7 < realParamsCount : false;
            if (bl) {
                Object[] objectArray4 = args;
                if (n8 >= 0 && n8 <= ArraysKt.getLastIndex((Object[])objectArray4)) {
                    object = objectArray4[n8];
                } else {
                    n = n9;
                    objectArray = objectArray3;
                    Class<?> clazz = this.method.getParameterTypes()[n8];
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"get(...)");
                    Object object2 = ComposableMethodKt.access$getDefaultValue(clazz);
                    objectArray3 = objectArray;
                    n9 = n;
                    object = object2;
                }
            } else if (n7 == realParamsCount) {
                object = composer;
            } else if (n7 == changedStartIndex) {
                object = 0;
            } else {
                boolean bl2 = changedStartIndex + 1 <= n7 ? n7 < defaultStartIndex : false;
                if (bl2) {
                    object = 0;
                } else {
                    boolean bl3 = defaultStartIndex <= n7 ? n7 < totalParams : false;
                    if (bl3) {
                        object = defaultsMasks[n8 - defaultStartIndex];
                    } else {
                        throw new IllegalStateException("Unexpected index".toString());
                    }
                }
            }
            objectArray3[n9] = object;
        }
        Object[] arguments = objectArray2;
        return this.method.invoke((Object)var2_2, Arrays.copyOf(arguments, arguments.length));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (other instanceof ComposableMethod) {
            void var1_1;
            return Intrinsics.areEqual((Object)this.method, (Object)((ComposableMethod)var1_1).method);
        }
        return false;
    }

    public final int hashCode() {
        return this.method.hashCode();
    }
}

