/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ajax;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JSONPojoConvertor
implements JSON.Convertor {
    private static final Logger LOG = Log.getLogger(JSONPojoConvertor.class);
    public static final Object[] GETTER_ARG = new Object[0];
    public static final Object[] NULL_ARG = new Object[]{null};
    private static final Map<Class<?>, NumberType> __numberTypes = new HashMap();
    protected boolean _fromJSON;
    protected Class<?> _pojoClass;
    protected Map<String, Method> _getters = new HashMap<String, Method>();
    protected Map<String, Setter> _setters = new HashMap<String, Setter>();
    protected Set<String> _excluded;
    public static final NumberType SHORT = new NumberType(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Object getActualValue(Number number) {
            void var1_1;
            return new Short(var1_1.shortValue());
        }
    };
    public static final NumberType INTEGER = new NumberType(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Object getActualValue(Number number) {
            void var1_1;
            return new Integer(var1_1.intValue());
        }
    };
    public static final NumberType FLOAT = new NumberType(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Object getActualValue(Number number) {
            void var1_1;
            return new Float(var1_1.floatValue());
        }
    };
    public static final NumberType LONG = new NumberType(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Object getActualValue(Number number) {
            void var1_1;
            if (number instanceof Long) {
                return number;
            }
            return new Long(var1_1.longValue());
        }
    };
    public static final NumberType DOUBLE = new NumberType(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Object getActualValue(Number number) {
            void var1_1;
            if (number instanceof Double) {
                return number;
            }
            return new Double(var1_1.doubleValue());
        }
    };

    public static NumberType getNumberType(Class<?> clazz) {
        Class<?> clazz2;
        return __numberTypes.get(clazz2);
    }

    /*
     * WARNING - void declaration
     */
    public JSONPojoConvertor(Class<?> pojoClass) {
        this((Class<?>)var1_1, null, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONPojoConvertor(Class<?> pojoClass, String[] excluded) {
        this((Class<?>)var1_1, (Set<String>)new HashSet<String>(Arrays.asList(var2_2)), true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONPojoConvertor(Class<?> pojoClass, Set<String> excluded) {
        this((Class<?>)var1_1, (Set<String>)var2_2, true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONPojoConvertor(Class<?> pojoClass, Set<String> excluded, boolean fromJSON) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._pojoClass = var1_1;
        this._excluded = var2_2;
        this._fromJSON = var3_3;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public JSONPojoConvertor(Class<?> pojoClass, boolean fromJSON) {
        this((Class<?>)var1_1, null, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void init() {
        Method[] methods = this._pojoClass.getMethods();
        block4: for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (Modifier.isStatic(m.getModifiers()) || m.getDeclaringClass() == Object.class) continue;
            String name = m.getName();
            switch (m.getParameterCount()) {
                case 0: {
                    if (m.getReturnType() == null) continue block4;
                    if (name.startsWith("is") && name.length() > 2) {
                        name = name.substring(2, 3).toLowerCase(Locale.ENGLISH) + name.substring(3);
                    } else {
                        if (!name.startsWith("get") || name.length() <= 3) continue block4;
                        name = name.substring(3, 4).toLowerCase(Locale.ENGLISH) + name.substring(4);
                    }
                    if (!this.includeField(name, m)) continue block4;
                    this.addGetter(name, m);
                    continue block4;
                }
                case 1: {
                    void var3_3;
                    if (!name.startsWith("set") || name.length() <= 3 || !this.includeField(name = name.substring(3, 4).toLowerCase(Locale.ENGLISH) + name.substring(4), m)) continue block4;
                    this.addSetter(name, (Method)var3_3);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addGetter(String name, Method method) {
        void var2_2;
        void var1_1;
        this._getters.put((String)var1_1, (Method)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void addSetter(String name, Method method) {
        void var2_2;
        void var1_1;
        this._setters.put(name, new Setter((String)var1_1, (Method)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    protected Setter getSetter(String name) {
        void var1_1;
        return this._setters.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean includeField(String name, Method m) {
        void var1_1;
        return this._excluded == null || !this._excluded.contains(var1_1);
    }

    protected int getExcludedCount() {
        if (this._excluded == null) {
            return 0;
        }
        return this._excluded.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object fromJSON(Map object) {
        void var2_3;
        void var1_1;
        Object obj;
        try {
            obj = this._pojoClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
        this.setProps(obj, (Map<?, ?>)var1_1);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public int setProps(Object obj, Map<?, ?> props) {
        void var3_3;
        int count = 0;
        for (Map.Entry<?, ?> entry : props.entrySet()) {
            Setter setter = this.getSetter((String)entry.getKey());
            if (setter == null) continue;
            try {
                setter.invoke(obj, entry.getValue());
                ++count;
            }
            catch (Exception e) {
                LOG.warn(this._pojoClass.getName() + "#" + setter.getPropertyName() + " not set from " + entry.getValue().getClass().getName() + "=" + entry.getValue().toString(), new Object[0]);
                this.log(e);
            }
        }
        return (int)var3_3;
    }

    @Override
    public void toJSON(Object obj, JSON.Output out) {
        if (this._fromJSON) {
            out.addClass(this._pojoClass);
        }
        for (Map.Entry<String, Method> entry : this._getters.entrySet()) {
            try {
                out.add(entry.getKey(), entry.getValue().invoke(obj, GETTER_ARG));
            }
            catch (Exception e) {
                LOG.warn("{} property '{}' excluded. (errors)", new Object[]{this._pojoClass.getName(), entry.getKey()});
                this.log(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void log(Throwable t) {
        void var1_1;
        LOG.ignore((Throwable)var1_1);
    }

    static {
        __numberTypes.put(Short.class, SHORT);
        __numberTypes.put(Short.TYPE, SHORT);
        __numberTypes.put(Integer.class, INTEGER);
        __numberTypes.put(Integer.TYPE, INTEGER);
        __numberTypes.put(Long.class, LONG);
        __numberTypes.put(Long.TYPE, LONG);
        __numberTypes.put(Float.class, FLOAT);
        __numberTypes.put(Float.TYPE, FLOAT);
        __numberTypes.put(Double.class, DOUBLE);
        __numberTypes.put(Double.TYPE, DOUBLE);
    }

    public static interface NumberType {
        public Object getActualValue(Number var1);
    }

    public static class Setter {
        protected String _propertyName;
        protected Method _setter;
        protected NumberType _numberType;
        protected Class<?> _type;
        protected Class<?> _componentType;

        /*
         * WARNING - void declaration
         */
        public Setter(String propertyName, Method method) {
            void var2_2;
            void var1_1;
            this._propertyName = var1_1;
            this._setter = method;
            this._type = var2_2.getParameterTypes()[0];
            this._numberType = (NumberType)__numberTypes.get(this._type);
            if (this._numberType == null && this._type.isArray()) {
                this._componentType = this._type.getComponentType();
                this._numberType = (NumberType)__numberTypes.get(this._componentType);
            }
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public Method getMethod() {
            return this._setter;
        }

        public NumberType getNumberType() {
            return this._numberType;
        }

        public Class<?> getType() {
            return this._type;
        }

        public Class<?> getComponentType() {
            return this._componentType;
        }

        public boolean isPropertyNumber() {
            return this._numberType != null;
        }

        /*
         * WARNING - void declaration
         */
        public void invoke(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            void var2_2;
            void var1_1;
            if (value == null) {
                this._setter.invoke(obj, NULL_ARG);
                return;
            }
            this.invokeObject(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        protected void invokeObject(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            void var2_2;
            void var1_1;
            if (this._type.isEnum()) {
                if (value instanceof Enum) {
                    this._setter.invoke(obj, value);
                    return;
                }
                this._setter.invoke(obj, Enum.valueOf(this._type, value.toString()));
                return;
            }
            if (this._numberType != null && value instanceof Number) {
                this._setter.invoke(obj, this._numberType.getActualValue((Number)value));
                return;
            }
            if (Character.TYPE.equals(this._type) || Character.class.equals(this._type)) {
                this._setter.invoke(obj, Character.valueOf(String.valueOf(value).charAt(0)));
                return;
            }
            if (this._componentType != null && value.getClass().isArray()) {
                if (this._numberType == null) {
                    int len = Array.getLength(value);
                    Object array = Array.newInstance(this._componentType, len);
                    try {
                        System.arraycopy(value, 0, array, 0, len);
                    }
                    catch (Exception e) {
                        LOG.ignore((Throwable)e);
                        this._setter.invoke(obj, value);
                        return;
                    }
                    this._setter.invoke(obj, array);
                    return;
                }
                Object[] old = (Object[])value;
                Object array = Array.newInstance(this._componentType, old.length);
                try {
                    for (int i = 0; i < old.length; ++i) {
                        Array.set(array, i, this._numberType.getActualValue((Number)old[i]));
                    }
                }
                catch (Exception e) {
                    LOG.ignore((Throwable)e);
                    this._setter.invoke(obj, value);
                    return;
                }
                this._setter.invoke(obj, array);
                return;
            }
            this._setter.invoke((Object)var1_1, var2_2);
        }
    }
}

