/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ajax;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JSONDateConvertor
implements JSON.Convertor {
    private static final Logger LOG = Log.getLogger(JSONDateConvertor.class);
    private final boolean _fromJSON;
    private final DateCache _dateCache;
    private final SimpleDateFormat _format;

    public JSONDateConvertor() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    public JSONDateConvertor(boolean fromJSON) {
        this("EEE MMM dd HH:mm:ss zzz yyyy", TimeZone.getTimeZone("GMT"), (boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONDateConvertor(String format, TimeZone zone, boolean fromJSON) {
        void var2_2;
        void var1_1;
        void var3_3;
        this._dateCache = new DateCache(format, null, zone);
        this._fromJSON = var3_3;
        this._format = new SimpleDateFormat((String)var1_1);
        this._format.setTimeZone((TimeZone)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public JSONDateConvertor(String format, TimeZone zone, boolean fromJSON, Locale locale) {
        void var2_2;
        void var1_1;
        void var3_3;
        this._dateCache = new DateCache(format, locale, zone);
        this._fromJSON = var3_3;
        this._format = new SimpleDateFormat((String)var1_1, new DateFormatSymbols(locale));
        this._format.setTimeZone((TimeZone)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object fromJSON(Map map) {
        if (!this._fromJSON) {
            throw new UnsupportedOperationException();
        }
        try {
            SimpleDateFormat simpleDateFormat = this._format;
            synchronized (simpleDateFormat) {
                void var1_1;
                return this._format.parseObject((String)var1_1.get("value"));
            }
        }
        catch (Exception e) {
            void var2_4;
            LOG.warn((Throwable)var2_4);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void toJSON(Object obj, JSON.Output out) {
        void var3_3;
        void var2_2;
        String date = this._dateCache.format((Date)obj);
        if (this._fromJSON) {
            void var1_1;
            out.addClass(var1_1.getClass());
            out.add("value", date);
            return;
        }
        var2_2.add(var3_3);
    }
}

