/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ajax;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JSON {
    static final Logger LOG = Log.getLogger(JSON.class);
    public static final JSON DEFAULT = new JSON();
    private final Map<String, Convertor> _convertors = new ConcurrentHashMap<String, Convertor>();
    private int _stringBufferSize = 1024;
    private Function<List<?>, Object> _arrayConverter = this::defaultArrayConverter;

    public static void reset() {
        JSON.DEFAULT._convertors.clear();
        JSON.DEFAULT._stringBufferSize = 1024;
    }

    public int getStringBufferSize() {
        return this._stringBufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setStringBufferSize(int stringBufferSize) {
        void var1_1;
        this._stringBufferSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void registerConvertor(Class forClass, Convertor convertor) {
        void var1_1;
        Class clazz;
        DEFAULT.addConvertor(clazz, (Convertor)var1_1);
    }

    public static JSON getDefault() {
        return DEFAULT;
    }

    @Deprecated
    public static void setDefault(JSON json) {
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object object) {
        void var1_1;
        Object object2;
        StringBuilder buffer = new StringBuilder(DEFAULT.getStringBufferSize());
        DEFAULT.append(buffer, object2);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Map object) {
        void var1_1;
        Map map;
        StringBuilder buffer = new StringBuilder(DEFAULT.getStringBufferSize());
        DEFAULT.appendMap(buffer, map);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object[] array) {
        void var1_1;
        Object[] objectArray;
        StringBuilder buffer = new StringBuilder(DEFAULT.getStringBufferSize());
        DEFAULT.appendArray((Appendable)buffer, (Object)objectArray);
        return var1_1.toString();
    }

    public static Object parse(String s) {
        String string;
        return DEFAULT.parse(new StringSource(string), false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object parse(String s, boolean stripOuterComment) {
        void var1_1;
        String string;
        return DEFAULT.parse(new StringSource(string), (boolean)var1_1);
    }

    public static Object parse(Reader in) throws IOException {
        Reader reader;
        return DEFAULT.parse(new ReaderSource(reader), false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object parse(Reader in, boolean stripOuterComment) throws IOException {
        void var1_1;
        Reader reader;
        return DEFAULT.parse(new ReaderSource(reader), (boolean)var1_1);
    }

    @Deprecated
    public static Object parse(InputStream in) throws IOException {
        InputStream inputStream;
        return DEFAULT.parse(new StringSource(IO.toString((InputStream)inputStream)), false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Object parse(InputStream in, boolean stripOuterComment) throws IOException {
        void var1_1;
        InputStream inputStream;
        return DEFAULT.parse(new StringSource(IO.toString((InputStream)inputStream)), (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void quotedEscape(Appendable buffer, String input) {
        try {
            buffer.append('\"');
            if (input != null && !input.isEmpty()) {
                void var2_3;
                this.escapeString(buffer, (String)var2_3);
            }
            buffer.append('\"');
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    public void escapeString(Appendable buffer, String input) throws IOException {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= ' ' && c <= '~') {
                if (c == '\"' || c == '\\') {
                    buffer.append('\\').append(c);
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '\b') {
                buffer.append("\\b");
                continue;
            }
            if (c == '\f') {
                buffer.append("\\f");
                continue;
            }
            if (c == '\n') {
                buffer.append("\\n");
                continue;
            }
            if (c == '\r') {
                buffer.append("\\r");
                continue;
            }
            if (c == '\t') {
                buffer.append("\\t");
                continue;
            }
            if (c < ' ' || c == '\u007f') {
                buffer.append(String.format("\\u%04x", (short)c));
                continue;
            }
            this.escapeUnicode(buffer, c);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void escapeUnicode(Appendable buffer, char c) throws IOException {
        void var2_2;
        buffer.append((char)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String toJSON(Object object) {
        void var2_2;
        void var1_1;
        StringBuilder buffer = new StringBuilder(this.getStringBufferSize());
        this.append(buffer, (Object)var1_1);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Object fromJSON(String json) {
        void var1_1;
        StringSource source = new StringSource(json);
        return this.parse((Source)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void append(StringBuffer buffer, Object object) {
        void var2_2;
        void var1_1;
        this.append((Appendable)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void append(Appendable buffer, Object object) {
        block13: {
            try {
                void var2_2;
                void var1_1;
                if (object == null) {
                    buffer.append("null");
                    break block13;
                }
                if (object instanceof Map) {
                    this.appendMap(buffer, (Map)object);
                    break block13;
                }
                if (object instanceof String) {
                    this.appendString(buffer, (String)object);
                    break block13;
                }
                if (object instanceof Number) {
                    this.appendNumber(buffer, (Number)object);
                    break block13;
                }
                if (object instanceof Boolean) {
                    this.appendBoolean(buffer, (Boolean)object);
                    break block13;
                }
                if (object.getClass().isArray()) {
                    this.appendArray(buffer, object);
                    break block13;
                }
                if (object instanceof Character) {
                    this.appendString(buffer, object.toString());
                    break block13;
                }
                if (object instanceof Convertible) {
                    this.appendJSON(buffer, (Convertible)object);
                    break block13;
                }
                if (object instanceof Generator) {
                    this.appendJSON(buffer, (Generator)object);
                    break block13;
                }
                Convertor convertor = this.getConvertor(object.getClass());
                if (convertor != null) {
                    this.appendJSON(buffer, convertor, object);
                    break block13;
                }
                if (object instanceof Collection) {
                    this.appendArray(buffer, (Collection)object);
                    break block13;
                }
                this.appendString((Appendable)var1_1, var2_2.toString());
                return;
            }
            catch (IOException e) {
                void var3_4;
                throw new RuntimeException((Throwable)var3_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void appendNull(StringBuffer buffer) {
        void var1_1;
        this.appendNull((Appendable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void appendNull(Appendable buffer) {
        try {
            buffer.append("null");
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void appendJSON(StringBuffer buffer, Convertor convertor, Object object) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendJSON((Appendable)var1_1, (Convertor)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void appendJSON(Appendable buffer, Convertor convertor, Object object) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendJSON((Appendable)var1_1, new Convertible(this, (Convertor)var2_2, var3_3){
            final /* synthetic */ Convertor val$convertor;
            final /* synthetic */ Object val$object;
            final /* synthetic */ JSON this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$convertor = convertor;
                this.val$object = object;
            }

            @Override
            public void fromJSON(Map object) {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void toJSON(Output out) {
                void var1_1;
                this.val$convertor.toJSON(this.val$object, (Output)var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void appendJSON(StringBuffer buffer, Convertible converter) {
        void var2_2;
        void var1_1;
        this.appendJSON((Appendable)var1_1, (Convertible)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void appendJSON(Appendable buffer, Convertible converter) {
        void var1_1;
        void var2_2;
        ConvertableOutput out = new ConvertableOutput(buffer);
        var2_2.toJSON(out);
        var1_1.complete();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void appendJSON(StringBuffer buffer, Generator generator) {
        void var1_1;
        generator.addJSON((Appendable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void appendJSON(Appendable buffer, Generator generator) {
        void var1_1;
        generator.addJSON((Appendable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void appendMap(StringBuffer buffer, Map<?, ?> map) {
        void var2_2;
        void var1_1;
        this.appendMap((Appendable)var1_1, (Map<?, ?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void appendMap(Appendable buffer, Map<?, ?> map) {
        try {
            void var1_1;
            if (map == null) {
                this.appendNull(buffer);
                return;
            }
            buffer.append('{');
            Iterator<Map.Entry<?, ?>> iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                void var3_4;
                Map.Entry<?, ?> entry = iter.next();
                this.quotedEscape(buffer, entry.getKey().toString());
                buffer.append(':');
                this.append(buffer, var3_4.getValue());
                if (!iter.hasNext()) continue;
                buffer.append(',');
            }
            var1_1.append('}');
            return;
        }
        catch (IOException e) {
            void var2_3;
            throw new RuntimeException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void appendArray(StringBuffer buffer, Collection collection) {
        void var2_2;
        void var1_1;
        this.appendArray((Appendable)var1_1, (Collection)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void appendArray(Appendable buffer, Collection collection) {
        try {
            void var1_1;
            if (collection == null) {
                this.appendNull(buffer);
                return;
            }
            buffer.append('[');
            Iterator iter = collection.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                if (!first) {
                    buffer.append(',');
                }
                first = false;
                this.append(buffer, iter.next());
            }
            var1_1.append(']');
            return;
        }
        catch (IOException e) {
            void var2_3;
            throw new RuntimeException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void appendArray(StringBuffer buffer, Object array) {
        void var2_2;
        void var1_1;
        this.appendArray((Appendable)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void appendArray(Appendable buffer, Object array) {
        try {
            void var1_1;
            if (array == null) {
                this.appendNull(buffer);
                return;
            }
            buffer.append('[');
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    buffer.append(',');
                }
                this.append(buffer, Array.get(array, i));
            }
            var1_1.append(']');
            return;
        }
        catch (IOException e) {
            void var3_4;
            throw new RuntimeException((Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void appendBoolean(StringBuffer buffer, Boolean b) {
        void var2_2;
        void var1_1;
        this.appendBoolean((Appendable)var1_1, (Boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void appendBoolean(Appendable buffer, Boolean b) {
        try {
            void var2_3;
            if (b == null) {
                this.appendNull(buffer);
                return;
            }
            buffer.append(var2_3.booleanValue() ? "true" : "false");
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void appendNumber(StringBuffer buffer, Number number) {
        void var2_2;
        void var1_1;
        this.appendNumber((Appendable)var1_1, (Number)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void appendNumber(Appendable buffer, Number number) {
        try {
            void var2_3;
            if (number == null) {
                this.appendNull(buffer);
                return;
            }
            buffer.append(String.valueOf(var2_3));
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void appendString(StringBuffer buffer, String string) {
        void var2_2;
        void var1_1;
        this.appendString((Appendable)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void appendString(Appendable buffer, String string) {
        void var2_2;
        void var1_1;
        if (string == null) {
            this.appendNull(buffer);
            return;
        }
        this.quotedEscape((Appendable)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected String toString(char[] buffer, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new String((char[])var1_1, (int)var2_2, (int)var3_3);
    }

    protected Map<String, Object> newMap() {
        return new HashMap<String, Object>();
    }

    @Deprecated
    protected Object[] newArray(int size) {
        return new Object[size];
    }

    protected JSON contextForArray() {
        return this;
    }

    protected JSON contextFor(String field) {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    protected Object convertTo(Class type, Map map) {
        void var2_3;
        void e2;
        if (type != null && Convertible.class.isAssignableFrom(type)) {
            try {
                Convertible conv = (Convertible)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                conv.fromJSON(map);
                return conv;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        Convertor convertor = this.getConvertor((Class)e2);
        if (convertor != null) {
            void var1_1;
            return var1_1.fromJSON(map);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public void addConvertor(Class forClass, Convertor convertor) {
        void var2_2;
        void var1_1;
        this._convertors.put(var1_1.getName(), (Convertor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected Convertor getConvertor(Class forClass) {
        void var2_2;
        Class cls = forClass;
        Convertor convertor = this._convertors.get(cls.getName());
        if (convertor == null && this != DEFAULT) {
            convertor = DEFAULT.getConvertor(cls);
        }
        while (convertor == null && cls != Object.class) {
            Class<?>[] ifs = cls.getInterfaces();
            int i = 0;
            while (convertor == null && i < ifs.length) {
                convertor = this._convertors.get(ifs[i++].getName());
            }
            if (convertor != null) continue;
            cls = cls.getSuperclass();
            convertor = this._convertors.get(cls.getName());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void addConvertorFor(String name, Convertor convertor) {
        void var2_2;
        void var1_1;
        this._convertors.put((String)var1_1, (Convertor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Convertor removeConvertorFor(String name) {
        void var1_1;
        return this._convertors.remove(var1_1);
    }

    public Function<List<?>, Object> getArrayConverter() {
        return this._arrayConverter;
    }

    /*
     * WARNING - void declaration
     */
    public void setArrayConverter(Function<List<?>, Object> arrayConverter) {
        void var1_1;
        this._arrayConverter = (Function)Objects.requireNonNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Convertor getConvertorFor(String name) {
        void var2_2;
        Convertor convertor = this._convertors.get(name);
        if (convertor == null && this != DEFAULT) {
            void var1_1;
            convertor = DEFAULT.getConvertorFor((String)var1_1);
        }
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object parse(Source source, boolean stripOuterComment) {
        int commentState = 0;
        if (!stripOuterComment) {
            return this.parse(source);
        }
        int stripState = 1;
        Object o = null;
        while (source.hasNext()) {
            char c = source.peek();
            if (commentState == 1) {
                switch (c) {
                    case '/': {
                        commentState = -1;
                        break;
                    }
                    case '*': {
                        commentState = 2;
                        if (stripState == 1) {
                            commentState = 0;
                            stripState = 2;
                        } else {
                            break;
                        }
                    }
                }
            } else if (commentState > 1) {
                switch (c) {
                    case '*': {
                        commentState = 3;
                        break;
                    }
                    case '/': {
                        if (commentState == 3) {
                            commentState = 0;
                            if (stripState != 2) break;
                            return o;
                        }
                        commentState = 2;
                        break;
                    }
                    default: {
                        commentState = 2;
                        break;
                    }
                }
            } else if (commentState < 0) {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        commentState = 0;
                        break;
                    }
                }
            } else if (!Character.isWhitespace(c)) {
                if (c == '/') {
                    commentState = 1;
                } else if (c == '*') {
                    commentState = 3;
                } else if (o == null) {
                    o = this.parse(source);
                    continue;
                }
            }
            source.next();
        }
        return o;
    }

    /*
     * WARNING - void declaration
     */
    public Object parse(Source source) {
        int commentState = 0;
        while (source.hasNext()) {
            char c = source.peek();
            if (commentState == 1) {
                switch (c) {
                    case '/': {
                        commentState = -1;
                        break;
                    }
                    case '*': {
                        commentState = 2;
                    }
                }
            } else if (commentState > 1) {
                switch (c) {
                    case '*': {
                        commentState = 3;
                        break;
                    }
                    case '/': {
                        if (commentState == 3) {
                            commentState = 0;
                            break;
                        }
                        commentState = 2;
                        break;
                    }
                    default: {
                        commentState = 2;
                        break;
                    }
                }
            } else if (commentState < 0) {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        commentState = 0;
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '{': {
                        return this.parseObject(source);
                    }
                    case '[': {
                        return this.parseArray(source);
                    }
                    case '\"': {
                        return this.parseString(source);
                    }
                    case '-': {
                        return this.parseNumber(source);
                    }
                    case 'n': {
                        JSON.complete("null", source);
                        return null;
                    }
                    case 't': {
                        JSON.complete("true", source);
                        return Boolean.TRUE;
                    }
                    case 'f': {
                        JSON.complete("false", source);
                        return Boolean.FALSE;
                    }
                    case 'u': {
                        JSON.complete("undefined", source);
                        return null;
                    }
                    case 'N': {
                        JSON.complete("NaN", source);
                        return null;
                    }
                    case '/': {
                        commentState = 1;
                        break;
                    }
                    default: {
                        void var3_3;
                        if (Character.isDigit(c)) {
                            return this.parseNumber(source);
                        }
                        if (Character.isWhitespace(c)) break;
                        return this.handleUnknown(source, (char)var3_3);
                    }
                }
            }
            source.next();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected Object handleUnknown(Source source, char c) {
        void var1_1;
        void var2_2;
        throw new IllegalStateException("unknown char '" + c + "'(" + (int)var2_2 + ") in " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected Object parseObject(Source source) {
        void var2_2;
        String classname;
        String xclassname;
        if (source.next() != '{') {
            throw new IllegalStateException();
        }
        Map<String, Object> map = this.newMap();
        char next = this.seekTo("\"}", source);
        while (source.hasNext()) {
            if (next == '}') {
                source.next();
                break;
            }
            String name22 = this.parseString(source);
            this.seekTo(':', source);
            source.next();
            Object value = this.contextFor(name22).parse(source);
            map.put(name22, value);
            this.seekTo(",}", source);
            char name22 = source.next();
            if (name22 == '}') break;
            name22 = this.seekTo("\"}", source);
        }
        if ((xclassname = (String)map.get("x-class")) != null) {
            void var3_5;
            Convertor c = this.getConvertorFor(xclassname);
            if (c != null) {
                return c.fromJSON(map);
            }
            LOG.warn("No Convertor for x-class '{}'", new Object[]{var3_5});
        }
        if ((classname = (String)map.get("class")) != null) {
            try {
                void var1_1;
                Class c = Loader.loadClass((String)classname);
                return this.convertTo((Class)var1_1, map);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.warn("No Class for '{}'", new Object[]{classname});
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Object defaultArrayConverter(List<?> list) {
        void var2_2;
        void var1_1;
        Object[] objects = this.newArray(list.size());
        IntStream.range(0, list.size()).forEach(arg_0 -> JSON.lambda$defaultArrayConverter$0(objects, (List)var1_1, arg_0));
        return var2_2;
    }

    protected Object parseArray(Source source) {
        if (source.next() != '[') {
            throw new IllegalStateException();
        }
        int size = 0;
        List<Object> list = null;
        Object item = null;
        boolean comma = true;
        block8: while (source.hasNext()) {
            char c = source.peek();
            switch (c) {
                case ']': {
                    source.next();
                    switch (size) {
                        case 0: {
                            list = Collections.emptyList();
                            break;
                        }
                        case 1: {
                            list = Collections.singletonList(item);
                        }
                    }
                    return this.getArrayConverter().apply(list);
                }
                case ',': {
                    if (comma) {
                        throw new IllegalStateException();
                    }
                    comma = true;
                    source.next();
                    continue block8;
                }
            }
            if (Character.isWhitespace(c)) {
                source.next();
                continue;
            }
            comma = false;
            if (size++ == 0) {
                item = this.contextForArray().parse(source);
                continue;
            }
            if (list == null) {
                list = new ArrayList();
                list.add(item);
                item = this.contextForArray().parse(source);
                list.add(item);
                item = null;
                continue;
            }
            item = this.contextForArray().parse(source);
            list.add(item);
            item = null;
        }
        throw new IllegalStateException("unexpected end of array");
    }

    /*
     * WARNING - void declaration
     */
    protected String parseString(Source source) {
        void var3_3;
        char uc;
        char c;
        if (source.next() != '\"') {
            throw new IllegalStateException();
        }
        boolean escape = false;
        StringBuilder b = null;
        char[] scratch = source.scratchBuffer();
        if (scratch != null) {
            int i = 0;
            block22: while (source.hasNext()) {
                if (i >= scratch.length) {
                    b = new StringBuilder(scratch.length << 1);
                    b.append(scratch, 0, i);
                    break;
                }
                c = source.next();
                if (escape) {
                    escape = false;
                    switch (c) {
                        case '\"': {
                            scratch[i++] = 34;
                            continue block22;
                        }
                        case '\\': {
                            scratch[i++] = 92;
                            continue block22;
                        }
                        case '/': {
                            scratch[i++] = 47;
                            continue block22;
                        }
                        case 'b': {
                            scratch[i++] = 8;
                            continue block22;
                        }
                        case 'f': {
                            scratch[i++] = 12;
                            continue block22;
                        }
                        case 'n': {
                            scratch[i++] = 10;
                            continue block22;
                        }
                        case 'r': {
                            scratch[i++] = 13;
                            continue block22;
                        }
                        case 't': {
                            scratch[i++] = 9;
                            continue block22;
                        }
                        case 'u': {
                            uc = (char)((TypeUtil.convertHexDigit((byte)((byte)source.next())) << 12) + (TypeUtil.convertHexDigit((byte)((byte)source.next())) << 8) + (TypeUtil.convertHexDigit((byte)((byte)source.next())) << 4) + TypeUtil.convertHexDigit((byte)((byte)source.next())));
                            scratch[i++] = uc;
                            continue block22;
                        }
                    }
                    scratch[i++] = uc;
                    continue;
                }
                if (uc == '\\') {
                    escape = true;
                    continue;
                }
                if (uc == '\"') {
                    return this.toString(scratch, 0, i);
                }
                scratch[i++] = uc;
            }
            if (b == null) {
                return this.toString(scratch, 0, i);
            }
        } else {
            b = new StringBuilder(this.getStringBufferSize());
        }
        void builder = var3_3;
        block23: while (source.hasNext()) {
            void var6_7;
            c = source.next();
            if (escape) {
                escape = false;
                switch (c) {
                    case '\"': {
                        builder.append('\"');
                        continue block23;
                    }
                    case '\\': {
                        builder.append('\\');
                        continue block23;
                    }
                    case '/': {
                        builder.append('/');
                        continue block23;
                    }
                    case 'b': {
                        builder.append('\b');
                        continue block23;
                    }
                    case 'f': {
                        builder.append('\f');
                        continue block23;
                    }
                    case 'n': {
                        builder.append('\n');
                        continue block23;
                    }
                    case 'r': {
                        builder.append('\r');
                        continue block23;
                    }
                    case 't': {
                        builder.append('\t');
                        continue block23;
                    }
                    case 'u': {
                        uc = (char)((TypeUtil.convertHexDigit((byte)((byte)source.next())) << 12) + (TypeUtil.convertHexDigit((byte)((byte)source.next())) << 8) + (TypeUtil.convertHexDigit((byte)((byte)source.next())) << 4) + TypeUtil.convertHexDigit((byte)((byte)source.next())));
                        builder.append(uc);
                        continue block23;
                    }
                }
                builder.append((char)var6_7);
                continue;
            }
            if (var6_7 == 92) {
                escape = true;
                continue;
            }
            if (var6_7 == 34) break;
            builder.append((char)var6_7);
        }
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Number parseNumber(Source source) {
        char c;
        boolean minus = false;
        long number = 0L;
        StringBuilder buffer = null;
        block8: while (source.hasNext()) {
            c = source.peek();
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    number = number * 10L + (long)(c - 48);
                    source.next();
                    continue block8;
                }
                case '+': 
                case '-': {
                    if (number != 0L) {
                        throw new IllegalStateException("bad number");
                    }
                    minus = true;
                    source.next();
                    continue block8;
                }
                case '.': 
                case 'E': 
                case 'e': {
                    buffer = new StringBuilder(16);
                    if (minus) {
                        buffer.append('-');
                    }
                    buffer.append(number);
                    buffer.append(c);
                    source.next();
                    break block8;
                }
            }
        }
        if (buffer == null) {
            void var3_3;
            void var2_2;
            return var2_2 != false ? -1L * number : var3_3;
        }
        block9: while (source.hasNext()) {
            c = source.peek();
            switch (c) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'E': 
                case 'e': {
                    buffer.append(c);
                    source.next();
                    continue block9;
                }
            }
            break;
        }
        return Double.valueOf(buffer.toString());
    }

    /*
     * WARNING - void declaration
     */
    protected void seekTo(char seek, Source source) {
        void var1_1;
        while (source.hasNext()) {
            char c = source.peek();
            if (c == seek) {
                return;
            }
            if (!Character.isWhitespace(c)) {
                void var3_3;
                throw new IllegalStateException("Unexpected '" + (char)var3_3 + " while seeking '" + seek + "'");
            }
            source.next();
        }
        throw new IllegalStateException("Expected '" + (char)var1_1 + "'");
    }

    /*
     * WARNING - void declaration
     */
    protected char seekTo(String seek, Source source) {
        void var1_1;
        while (source.hasNext()) {
            char c = source.peek();
            if (seek.indexOf(c) >= 0) {
                return c;
            }
            if (!Character.isWhitespace(c)) {
                void var3_3;
                throw new IllegalStateException("Unexpected '" + (char)var3_3 + "' while seeking one of '" + seek + "'");
            }
            source.next();
        }
        throw new IllegalStateException("Expected one of '" + (String)var1_1 + "'");
    }

    /*
     * WARNING - void declaration
     */
    protected static void complete(String seek, Source source) {
        void var2_2;
        int i = 0;
        while (source.hasNext() && i < seek.length()) {
            void var3_3;
            char c = source.next();
            if (c == seek.charAt(i++)) continue;
            throw new IllegalStateException("Unexpected '" + (char)var3_3 + " while seeking  \"" + seek + "\"");
        }
        if (var2_2 < seek.length()) {
            String string;
            throw new IllegalStateException("Expected \"" + string + "\"");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$defaultArrayConverter$0(Object[] objects, List list, int i) {
        void var2_2;
        void var1_1;
        objects[i] = var1_1.get((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(JSON x0, Appendable x1, String x2) {
        void var2_2;
        void var1_1;
        x0.quotedEscape((Appendable)var1_1, (String)var2_2);
    }

    public static class Literal
    implements Generator {
        private final String _json;

        /*
         * WARNING - void declaration
         */
        public Literal(String json) {
            void var1_1;
            if (LOG.isDebugEnabled()) {
                JSON.parse(json);
            }
            this._json = var1_1;
        }

        public String toString() {
            return this._json;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void addJSON(Appendable buffer) {
            try {
                buffer.append(this._json);
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }
    }

    public static interface Generator {
        public void addJSON(Appendable var1);
    }

    public static interface Convertor {
        public void toJSON(Object var1, Output var2);

        public Object fromJSON(Map var1);
    }

    public static interface Convertible {
        public void toJSON(Output var1);

        public void fromJSON(Map var1);
    }

    public static interface Output {
        public void addClass(Class var1);

        public void add(Object var1);

        public void add(String var1, Object var2);

        public void add(String var1, double var2);

        public void add(String var1, long var2);

        public void add(String var1, boolean var2);
    }

    public static class ReaderSource
    implements Source {
        private Reader _reader;
        private int _next = -1;
        private char[] scratch;

        /*
         * WARNING - void declaration
         */
        public ReaderSource(Reader r) {
            void var1_1;
            this._reader = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setReader(Reader reader) {
            void var1_1;
            this._reader = var1_1;
            this._next = -1;
        }

        @Override
        public boolean hasNext() {
            this.getNext();
            if (this._next < 0) {
                this.scratch = null;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public char next() {
            void var1_1;
            this.getNext();
            char c = (char)this._next;
            this._next = -1;
            return (char)var1_1;
        }

        @Override
        public char peek() {
            this.getNext();
            return (char)this._next;
        }

        /*
         * WARNING - void declaration
         */
        private void getNext() {
            if (this._next < 0) {
                try {
                    this._next = this._reader.read();
                    return;
                }
                catch (IOException e) {
                    void var1_1;
                    throw new RuntimeException((Throwable)var1_1);
                }
            }
        }

        @Override
        public char[] scratchBuffer() {
            if (this.scratch == null) {
                this.scratch = new char[1024];
            }
            return this.scratch;
        }
    }

    public static class StringSource
    implements Source {
        private final String string;
        private int index;
        private char[] scratch;

        /*
         * WARNING - void declaration
         */
        public StringSource(String s) {
            void var1_1;
            this.string = var1_1;
        }

        @Override
        public boolean hasNext() {
            if (this.index < this.string.length()) {
                return true;
            }
            this.scratch = null;
            return false;
        }

        @Override
        public char next() {
            return this.string.charAt(this.index++);
        }

        @Override
        public char peek() {
            return this.string.charAt(this.index);
        }

        public String toString() {
            return this.string.substring(0, this.index) + "|||" + this.string.substring(this.index);
        }

        @Override
        public char[] scratchBuffer() {
            if (this.scratch == null) {
                this.scratch = new char[this.string.length()];
            }
            return this.scratch;
        }
    }

    public static interface Source {
        public boolean hasNext();

        public char next();

        public char peek();

        public char[] scratchBuffer();
    }

    private final class ConvertableOutput
    implements Output {
        private final Appendable _buffer;
        char c = (char)123;

        /*
         * WARNING - void declaration
         */
        private ConvertableOutput(Appendable buffer) {
            void var2_2;
            this._buffer = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void complete() {
            try {
                if (this.c != '{') {
                    if (this.c != '\u0000') {
                        this._buffer.append("}");
                    }
                    return;
                }
                this._buffer.append("{}");
            }
            catch (IOException e) {
                void var1_1;
                throw new RuntimeException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(Object obj) {
            void var1_1;
            if (this.c == '\u0000') {
                throw new IllegalStateException();
            }
            JSON.this.append(this._buffer, (Object)var1_1);
            this.c = '\u0000';
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void addClass(Class type) {
            try {
                if (this.c == '\u0000') {
                    throw new IllegalStateException();
                }
                this._buffer.append(this.c);
                this._buffer.append("\"class\":");
                JSON.this.append(this._buffer, (Object)type.getName());
                this.c = (char)44;
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(String name, Object value) {
            try {
                void var2_3;
                if (this.c == '\u0000') {
                    throw new IllegalStateException();
                }
                this._buffer.append(this.c);
                JSON.access$100(JSON.this, this._buffer, name);
                this._buffer.append(':');
                JSON.this.append(this._buffer, (Object)var2_3);
                this.c = (char)44;
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(String name, double value) {
            try {
                void var2_3;
                if (this.c == '\u0000') {
                    throw new IllegalStateException();
                }
                this._buffer.append(this.c);
                JSON.access$100(JSON.this, this._buffer, name);
                this._buffer.append(':');
                JSON.this.appendNumber(this._buffer, (Number)((double)var2_3));
                this.c = (char)44;
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(String name, long value) {
            try {
                void var2_3;
                if (this.c == '\u0000') {
                    throw new IllegalStateException();
                }
                this._buffer.append(this.c);
                JSON.access$100(JSON.this, this._buffer, name);
                this._buffer.append(':');
                JSON.this.appendNumber(this._buffer, (Number)((long)var2_3));
                this.c = (char)44;
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(String name, boolean value) {
            try {
                void var2_3;
                if (this.c == '\u0000') {
                    throw new IllegalStateException();
                }
                this._buffer.append(this.c);
                JSON.access$100(JSON.this, this._buffer, name);
                this._buffer.append(':');
                JSON.this.appendBoolean(this._buffer, var2_3 != false ? Boolean.TRUE : Boolean.FALSE);
                this.c = (char)44;
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }
    }
}

