/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ajax;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.ajax.JSON;

public class AsyncJSON {
    private static final Object UNSET = new Object();
    private final FrameStack stack = new FrameStack();
    private final NumberBuilder numberBuilder = new NumberBuilder();
    private final Utf8StringBuilder stringBuilder = new Utf8StringBuilder(32);
    private final Factory factory;
    private List<ByteBuffer> chunks;

    /*
     * WARNING - void declaration
     */
    public AsyncJSON(Factory factory) {
        void var1_1;
        this.factory = var1_1;
    }

    boolean isEmpty() {
        return this.stack.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public boolean parse(byte[] bytes) {
        void var1_1;
        return this.parse(bytes, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public boolean parse(byte[] bytes, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.parse(ByteBuffer.wrap((byte[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parse(ByteBuffer buffer) {
        try {
            void var3_5;
            if (this.factory.isDetailedParseException()) {
                if (this.chunks == null) {
                    this.chunks = new ArrayList<ByteBuffer>();
                }
                ByteBuffer copy = buffer.isDirect() ? ByteBuffer.allocateDirect(buffer.remaining()) : ByteBuffer.allocate(buffer.remaining());
                copy.put(buffer).flip();
                this.chunks.add(copy);
                buffer.flip();
            }
            if (this.stack.isEmpty()) {
                FrameStack.access$700(this.stack, State.COMPLETE, UNSET);
            }
            block17: while (true) {
                Frame frame = this.stack.peek();
                State state2 = frame.state;
                switch (state2) {
                    case COMPLETE: {
                        if (frame.value == UNSET) {
                            if (this.parseAny(buffer)) continue block17;
                            return false;
                        }
                        while (buffer.hasRemaining()) {
                            int position = buffer.position();
                            byte state2 = buffer.get(position);
                            if (!AsyncJSON.isWhitespace(state2)) throw this.newInvalidJSON(buffer, "invalid character after JSON data");
                            buffer.position(position + 1);
                        }
                        return true;
                    }
                    case NULL: {
                        if (this.parseNull(buffer)) continue block17;
                        return false;
                    }
                    case TRUE: {
                        if (this.parseTrue(buffer)) continue block17;
                        return false;
                    }
                    case FALSE: {
                        if (this.parseFalse(buffer)) continue block17;
                        return false;
                    }
                    case NUMBER: {
                        if (this.parseNumber(buffer)) continue block17;
                        return false;
                    }
                    case STRING: {
                        if (this.parseString(buffer)) continue block17;
                        return false;
                    }
                    case ESCAPE: {
                        if (this.parseEscape(buffer)) continue block17;
                        return false;
                    }
                    case UNICODE: {
                        if (this.parseUnicode(buffer)) continue block17;
                        return false;
                    }
                    case ARRAY: {
                        if (this.parseArray(buffer)) continue block17;
                        return false;
                    }
                    case OBJECT: {
                        if (this.parseObject(buffer)) continue block17;
                        return false;
                    }
                    case OBJECT_FIELD: {
                        if (this.parseObjectField(buffer)) continue block17;
                        return false;
                    }
                    case OBJECT_FIELD_NAME: {
                        if (this.parseObjectFieldName(buffer)) continue block17;
                        return false;
                    }
                    case OBJECT_FIELD_VALUE: {
                        if (!this.parseObjectFieldValue(buffer)) return false;
                        continue block17;
                    }
                }
                break;
            }
            throw new IllegalStateException("invalid state " + var3_5);
        }
        catch (Throwable x) {
            void var2_4;
            this.reset();
            throw var2_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public <R> R complete() {
        try {
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("no JSON parsed");
            }
            block6: while (true) {
                State state = this.stack.peek().state;
                switch (state) {
                    case NUMBER: {
                        Number value = this.numberBuilder.value();
                        this.stack.pop();
                        Frame.access$1300(this.stack.peek(), value);
                        continue block6;
                    }
                    case COMPLETE: {
                        Number value;
                        if (this.stack.peek().value == UNSET) {
                            throw new IllegalStateException("invalid state " + value);
                        }
                        return (R)this.end();
                    }
                }
                break;
            }
            throw this.newInvalidJSON(BufferUtil.EMPTY_BUFFER, "incomplete JSON");
        }
        catch (Throwable x) {
            void var1_2;
            this.reset();
            throw var1_2;
        }
    }

    protected Map<String, Object> newObject(Context context) {
        return new HashMap<String, Object>();
    }

    protected List<Object> newArray(Context context) {
        return new ArrayList<Object>();
    }

    /*
     * WARNING - void declaration
     */
    private Object end() {
        void var1_1;
        Object result = this.stack.peek().value;
        this.reset();
        return var1_1;
    }

    private void reset() {
        this.stack.clear();
        this.chunks = null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseAny(ByteBuffer buffer) {
        block9: while (buffer.hasRemaining()) {
            void var2_2;
            ByteBuffer byteBuffer = buffer;
            byte peek = byteBuffer.get(byteBuffer.position());
            switch (peek) {
                case 91: {
                    if (!this.parseArray(buffer)) continue block9;
                    return true;
                }
                case 123: {
                    if (!this.parseObject(buffer)) continue block9;
                    return true;
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (!this.parseNumber(buffer)) continue block9;
                    return true;
                }
                case 34: {
                    if (!this.parseString(buffer)) continue block9;
                    return true;
                }
                case 102: {
                    if (!this.parseFalse(buffer)) continue block9;
                    return true;
                }
                case 110: {
                    if (!this.parseNull(buffer)) continue block9;
                    return true;
                }
                case 116: {
                    if (!this.parseTrue(buffer)) continue block9;
                    return true;
                }
            }
            if (AsyncJSON.isWhitespace((byte)var2_2)) {
                buffer.get();
                continue;
            }
            throw this.newInvalidJSON(buffer, "unrecognized JSON value");
        }
        return false;
    }

    private boolean parseNull(ByteBuffer buffer) {
        block5: while (buffer.hasRemaining()) {
            byte by = buffer.get();
            switch (by) {
                case 110: {
                    if (this.stack.peek().state != State.NULL) {
                        FrameStack.access$700(this.stack, State.NULL, 0);
                        this.parseNullCharacter(buffer, 0);
                        continue block5;
                    }
                    throw this.newInvalidJSON(buffer, "invalid 'null' literal");
                }
                case 117: {
                    this.parseNullCharacter(buffer, 1);
                    continue block5;
                }
                case 108: {
                    int index = (Integer)this.stack.peek().value;
                    if (index != 2 && index != 3) {
                        throw this.newInvalidJSON(buffer, "invalid 'null' literal");
                    }
                    this.parseNullCharacter(buffer, index);
                    if (by != 3) continue block5;
                    this.stack.pop();
                    Frame.access$1300(this.stack.peek(), null);
                    return true;
                }
            }
            throw this.newInvalidJSON(buffer, "invalid 'null' literal");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void parseNullCharacter(ByteBuffer buffer, int index) {
        void var1_1;
        void var2_2;
        Frame frame = this.stack.peek();
        int value = (Integer)frame.value;
        if (value == var2_2) {
            void var3_3;
            Frame.access$1002((Frame)var3_3, ++value);
            return;
        }
        throw this.newInvalidJSON((ByteBuffer)var1_1, "invalid 'null' literal");
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseTrue(ByteBuffer buffer) {
        block6: while (buffer.hasRemaining()) {
            void var1_1;
            byte by = buffer.get();
            switch (by) {
                case 116: {
                    if (this.stack.peek().state != State.TRUE) {
                        FrameStack.access$700(this.stack, State.TRUE, 0);
                        this.parseTrueCharacter(buffer, 0);
                        continue block6;
                    }
                    throw this.newInvalidJSON(buffer, "invalid 'true' literal");
                }
                case 114: {
                    this.parseTrueCharacter(buffer, 1);
                    continue block6;
                }
                case 117: {
                    this.parseTrueCharacter(buffer, 2);
                    continue block6;
                }
                case 101: {
                    this.parseTrueCharacter(buffer, 3);
                    this.stack.pop();
                    Frame.access$1300(this.stack.peek(), Boolean.TRUE);
                    return true;
                }
            }
            throw this.newInvalidJSON((ByteBuffer)var1_1, "invalid 'true' literal");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void parseTrueCharacter(ByteBuffer buffer, int index) {
        void var1_1;
        void var2_2;
        Frame frame = this.stack.peek();
        int value = (Integer)frame.value;
        if (value == var2_2) {
            void var3_3;
            Frame.access$1002((Frame)var3_3, ++value);
            return;
        }
        throw this.newInvalidJSON((ByteBuffer)var1_1, "invalid 'true' literal");
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseFalse(ByteBuffer buffer) {
        block7: while (buffer.hasRemaining()) {
            void var1_1;
            byte by = buffer.get();
            switch (by) {
                case 102: {
                    if (this.stack.peek().state != State.FALSE) {
                        FrameStack.access$700(this.stack, State.FALSE, 0);
                        this.parseFalseCharacter(buffer, 0);
                        continue block7;
                    }
                    throw this.newInvalidJSON(buffer, "invalid 'false' literal");
                }
                case 97: {
                    this.parseFalseCharacter(buffer, 1);
                    continue block7;
                }
                case 108: {
                    this.parseFalseCharacter(buffer, 2);
                    continue block7;
                }
                case 115: {
                    this.parseFalseCharacter(buffer, 3);
                    continue block7;
                }
                case 101: {
                    this.parseFalseCharacter(buffer, 4);
                    this.stack.pop();
                    Frame.access$1300(this.stack.peek(), Boolean.FALSE);
                    return true;
                }
            }
            throw this.newInvalidJSON((ByteBuffer)var1_1, "invalid 'false' literal");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void parseFalseCharacter(ByteBuffer buffer, int index) {
        void var1_1;
        void var2_2;
        Frame frame = this.stack.peek();
        int value = (Integer)frame.value;
        if (value == var2_2) {
            void var3_3;
            Frame.access$1002((Frame)var3_3, ++value);
            return;
        }
        throw this.newInvalidJSON((ByteBuffer)var1_1, "invalid 'false' literal");
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseNumber(ByteBuffer buffer) {
        if (this.stack.peek().state != State.NUMBER) {
            FrameStack.access$700(this.stack, State.NUMBER, this.numberBuilder);
        }
        block5: while (buffer.hasRemaining()) {
            void var1_1;
            byte currentByte = buffer.get();
            switch (currentByte) {
                case 43: 
                case 45: {
                    if (NumberBuilder.access$1500(this.numberBuilder, currentByte)) continue block5;
                    throw this.newInvalidJSON(buffer, "invalid number");
                }
                case 46: 
                case 69: 
                case 101: {
                    if (NumberBuilder.access$1600(this.numberBuilder, currentByte)) continue block5;
                    throw this.newInvalidJSON(buffer, "invalid number");
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    void var2_2;
                    NumberBuilder.access$1700(this.numberBuilder, (byte)var2_2);
                    continue block5;
                }
            }
            ByteBuffer byteBuffer = buffer;
            byteBuffer.position(byteBuffer.position() - 1);
            Number value = this.numberBuilder.value();
            this.stack.pop();
            Frame.access$1300(this.stack.peek(), var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseString(ByteBuffer buffer) {
        String result;
        Frame frame = this.stack.peek();
        if (buffer.hasRemaining() && frame.state != State.STRING && (result = this.factory.cached(buffer)) != null) {
            void var2_2;
            Frame.access$1300((Frame)var2_2, result);
            return true;
        }
        block4: while (buffer.hasRemaining()) {
            void var3_4;
            byte currentByte = buffer.get();
            switch (currentByte) {
                case 34: {
                    void var1_1;
                    if (this.stack.peek().state != State.STRING) {
                        FrameStack.access$700(this.stack, State.STRING, this.stringBuilder);
                        continue block4;
                    }
                    String string = this.stringBuilder.toString();
                    this.stringBuilder.reset();
                    this.stack.pop();
                    Frame.access$1300(this.stack.peek(), var1_1);
                    return true;
                }
                case 92: {
                    void var1_1;
                    void v0 = var1_1;
                    v0.position(v0.position() - 1);
                    if (this.parseEscape((ByteBuffer)var1_1)) continue block4;
                    return false;
                }
            }
            this.stringBuilder.append((byte)var3_4);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseEscape(ByteBuffer buffer) {
        block10: while (buffer.hasRemaining()) {
            void var1_1;
            byte currentByte = buffer.get();
            switch (currentByte) {
                case 92: {
                    if (this.stack.peek().state != State.ESCAPE) {
                        FrameStack.access$700(this.stack, State.ESCAPE, this.stringBuilder);
                        continue block10;
                    }
                    return this.parseEscapeCharacter((char)currentByte);
                }
                case 34: 
                case 47: {
                    void var2_2;
                    return this.parseEscapeCharacter((char)var2_2);
                }
                case 98: {
                    return this.parseEscapeCharacter('\b');
                }
                case 102: {
                    return this.parseEscapeCharacter('\f');
                }
                case 110: {
                    return this.parseEscapeCharacter('\n');
                }
                case 114: {
                    return this.parseEscapeCharacter('\r');
                }
                case 116: {
                    return this.parseEscapeCharacter('\t');
                }
                case 117: {
                    FrameStack.access$700(this.stack, State.UNICODE, ByteBuffer.allocate(4));
                    return this.parseUnicode(buffer);
                }
            }
            throw this.newInvalidJSON((ByteBuffer)var1_1, "invalid escape sequence");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseEscapeCharacter(char escape) {
        void var1_1;
        this.stack.pop();
        this.stringBuilder.append((char)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseUnicode(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            void var1_2;
            void var3_4;
            void var2_3;
            byte currentByte = buffer.get();
            ByteBuffer hex = (ByteBuffer)this.stack.peek().value;
            hex.put(this.hexToByte(buffer, (byte)var2_3));
            if (hex.hasRemaining()) continue;
            int result = (hex.get(0) << 12) + (hex.get(1) << 8) + (hex.get(2) << 4) + var3_4.get(3);
            this.stack.pop();
            this.stack.pop();
            this.stringBuilder.append((char)var1_2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private byte hexToByte(ByteBuffer buffer, byte currentByte) {
        try {
            return TypeUtil.convertHexDigit((byte)currentByte);
        }
        catch (Throwable throwable) {
            void var1_1;
            throw this.newInvalidJSON((ByteBuffer)var1_1, "invalid hex digit");
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseArray(ByteBuffer buffer) {
        block5: while (buffer.hasRemaining()) {
            void var2_2;
            void var1_1;
            ByteBuffer byteBuffer = buffer;
            byte peek = byteBuffer.get(byteBuffer.position());
            switch (peek) {
                case 91: {
                    buffer.get();
                    AsyncJSON asyncJSON = this;
                    FrameStack.access$700(this.stack, State.ARRAY, asyncJSON.newArray(asyncJSON.stack));
                    continue block5;
                }
                case 93: {
                    buffer.get();
                    List array = (List)this.stack.peek().value;
                    this.stack.pop();
                    Frame.access$1300(this.stack.peek(), this.convertArray((List<?>)var1_1));
                    return true;
                }
                case 44: {
                    var1_1.get();
                    continue block5;
                }
            }
            if (AsyncJSON.isWhitespace((byte)var2_2)) {
                var1_1.get();
                continue;
            }
            if (this.parseAny((ByteBuffer)var1_1)) continue;
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseObject(ByteBuffer buffer) {
        block5: while (buffer.hasRemaining()) {
            void var2_2;
            void var1_1;
            byte currentByte = buffer.get();
            switch (currentByte) {
                case 123: {
                    if (this.stack.peek().state != State.OBJECT) {
                        AsyncJSON asyncJSON = this;
                        FrameStack.access$700(this.stack, State.OBJECT, asyncJSON.newObject(asyncJSON.stack));
                        continue block5;
                    }
                    throw this.newInvalidJSON(buffer, "invalid object");
                }
                case 125: {
                    Map object = (Map)this.stack.peek().value;
                    this.stack.pop();
                    Frame.access$1300(this.stack.peek(), this.convertObject((Map<String, Object>)var1_1));
                    return true;
                }
                case 44: {
                    continue block5;
                }
            }
            if (AsyncJSON.isWhitespace((byte)var2_2)) continue;
            void v1 = var1_1;
            v1.position(v1.position() - 1);
            if (this.parseObjectField((ByteBuffer)var1_1)) continue;
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseObjectField(ByteBuffer buffer) {
        block3: while (buffer.hasRemaining()) {
            void var2_2;
            ByteBuffer byteBuffer = buffer;
            byte peek = byteBuffer.get(byteBuffer.position());
            switch (peek) {
                case 34: {
                    if (this.stack.peek().state == State.OBJECT) {
                        FrameStack.access$700(this.stack, State.OBJECT_FIELD, UNSET);
                        if (this.parseObjectFieldName(buffer)) continue block3;
                        return false;
                    }
                    return this.parseObjectFieldValue(buffer);
                }
            }
            if (AsyncJSON.isWhitespace((byte)var2_2)) {
                buffer.get();
                continue;
            }
            if (this.stack.peek().state == State.OBJECT_FIELD_VALUE) {
                return this.parseObjectFieldValue(buffer);
            }
            throw this.newInvalidJSON(buffer, "invalid object field");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseObjectFieldName(ByteBuffer buffer) {
        block4: while (buffer.hasRemaining()) {
            void var2_2;
            void var1_1;
            ByteBuffer byteBuffer = buffer;
            byte peek = byteBuffer.get(byteBuffer.position());
            switch (peek) {
                case 34: {
                    if (this.stack.peek().state == State.OBJECT_FIELD) {
                        FrameStack.access$700(this.stack, State.OBJECT_FIELD_NAME, UNSET);
                        if (this.parseString(buffer)) continue block4;
                        return false;
                    }
                    throw this.newInvalidJSON(buffer, "invalid object field");
                }
                case 58: {
                    buffer.get();
                    String fieldName = (String)this.stack.peek().value;
                    this.stack.pop();
                    FrameStack.access$1800(this.stack, (String)var1_1, State.OBJECT_FIELD_VALUE, UNSET);
                    return true;
                }
            }
            if (AsyncJSON.isWhitespace((byte)var2_2)) {
                var1_1.get();
                continue;
            }
            throw this.newInvalidJSON((ByteBuffer)var1_1, "invalid object field");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseObjectFieldValue(ByteBuffer buffer) {
        void var2_2;
        void var1_1;
        if (this.stack.peek().value == UNSET && !this.parseAny(buffer)) {
            return false;
        }
        Frame frame = this.stack.peek();
        Object value = frame.value;
        String name = frame.name;
        this.stack.pop();
        this.stack.pop();
        Map map = (Map)this.stack.peek().value;
        map.put(var1_1, var2_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private Object convertArray(List<?> array) {
        void var1_1;
        return this.factory.getArrayConverter().apply((List<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Object convertObject(Map<String, Object> object) {
        void var2_2;
        Object result = this.convertObject("x-class", object);
        if (result == null && (result = this.convertObject("class", object)) == null) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Object convertObject(String fieldName, Map<String, Object> object) {
        String className = (String)object.get(fieldName);
        if (className == null) {
            return null;
        }
        JSON.Convertible convertible = this.toConvertible(className);
        if (convertible != null) {
            void var3_3;
            convertible.fromJSON(object);
            return var3_3;
        }
        JSON.Convertor convertor = this.factory.getConvertor(className);
        if (convertor != null) {
            void var2_2;
            void var1_1;
            return var1_1.fromJSON((Map)var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private JSON.Convertible toConvertible(String className) {
        try {
            Class klass = Loader.loadClass((String)className);
            if (JSON.Convertible.class.isAssignableFrom(klass)) {
                return (JSON.Convertible)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return null;
        }
        catch (Throwable x) {
            void var1_2;
            throw new IllegalArgumentException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected RuntimeException newInvalidJSON(ByteBuffer buffer, String message) {
        void var3_3;
        void var2_2;
        String string;
        Utf8StringBuilder builder = new Utf8StringBuilder();
        builder.append(System.lineSeparator());
        int position = buffer.position();
        if (this.factory.isDetailedParseException()) {
            this.chunks.forEach(chunk -> {
                void var1_1;
                builder.append((ByteBuffer)var1_1);
            });
        } else {
            buffer.position(0);
            builder.append(buffer);
            buffer.position(position);
        }
        builder.append(System.lineSeparator());
        String indent = "";
        if (position > 1) {
            char[] chars = new char[position - 1];
            Arrays.fill(chars, ' ');
            string = new String((char[])string);
        }
        builder.append(string);
        builder.append("^ ");
        builder.append((String)var2_2);
        return new IllegalArgumentException(var3_3.toString());
    }

    private static boolean isWhitespace(byte ws) {
        switch (ws) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static class FrameStack
    implements Context {
        private final List<Frame> stack = new ArrayList<Frame>();
        private int cursor;

        private FrameStack() {
            this.grow(6);
        }

        private void grow(int grow) {
            for (int i = 0; i < grow; ++i) {
                this.stack.add(new Frame());
            }
        }

        private void clear() {
            while (!this.isEmpty()) {
                this.pop();
            }
        }

        private boolean isEmpty() {
            return this.cursor == 0;
        }

        @Override
        public int depth() {
            return this.cursor - 1;
        }

        private Frame peek() {
            if (this.isEmpty()) {
                throw new IllegalStateException("empty stack");
            }
            return this.stack.get(this.depth());
        }

        /*
         * WARNING - void declaration
         */
        private void push(State state, Object value) {
            void var2_2;
            void var1_1;
            this.push(null, (State)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void push(String name, State state, Object value) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.cursor == this.stack.size()) {
                this.grow(2);
            }
            ++this.cursor;
            Frame frame = this.stack.get(this.depth());
            Frame.access$1902(frame, (String)var1_1);
            Frame.access$902(frame, (State)var2_2);
            Frame.access$1002(frame, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private void pop() {
            void var1_1;
            if (this.isEmpty()) {
                throw new IllegalStateException("empty stack");
            }
            Frame frame = this.stack.get(this.depth());
            --this.cursor;
            Frame.access$1902(frame, null);
            Frame.access$1002(frame, null);
            Frame.access$902((Frame)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$700(FrameStack x0, State x1, Object x2) {
            void var2_2;
            void var1_1;
            x0.push((State)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$1800(FrameStack x0, String x1, State x2, Object x3) {
            void var3_3;
            void var2_2;
            void var1_1;
            x0.push((String)var1_1, (State)var2_2, var3_3);
        }
    }

    private static class NumberBuilder {
        private int integer = 1;
        private long value;
        private StringBuilder builder;

        private NumberBuilder() {
        }

        /*
         * WARNING - void declaration
         */
        private boolean appendSign(byte b) {
            if (this.integer == 0) {
                void var2_2;
                if (this.builder.length() == 0) {
                    this.builder.append((char)b);
                    return true;
                }
                char c = this.builder.charAt(this.builder.length() - 1);
                if (c == 'E' || var2_2 == 101) {
                    this.builder.append((char)b);
                    return true;
                }
                return false;
            }
            if (this.value == 0L) {
                void var1_1;
                if (var1_1 == 45) {
                    if (this.integer == 1) {
                        this.integer = -1;
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private void appendDigit(byte b) {
            void var1_1;
            if (this.integer == 0) {
                this.builder.append((char)b);
                return;
            }
            this.value = this.value * 10L + (long)(var1_1 - 48);
        }

        /*
         * WARNING - void declaration
         */
        private boolean appendAlpha(byte b) {
            if (this.integer == 0) {
                void var2_2;
                char c = this.builder.charAt(this.builder.length() - 1);
                if ('0' <= c && var2_2 <= 57 && this.builder.indexOf("" + (char)b) < 0) {
                    this.builder.append((char)b);
                    return true;
                }
            } else {
                void var1_1;
                if (this.builder == null) {
                    this.builder = new StringBuilder(16);
                }
                if (this.integer == -1) {
                    this.builder.append('-');
                }
                this.integer = 0;
                this.builder.append(this.value);
                this.builder.append((char)var1_1);
                return true;
            }
            return false;
        }

        private Number value() {
            try {
                if (this.integer == 0) {
                    Double d = Double.parseDouble(this.builder.toString());
                    return d;
                }
                Long l = (long)this.integer * this.value;
                return l;
            }
            finally {
                this.reset();
            }
        }

        private void reset() {
            this.integer = 1;
            this.value = 0L;
            if (this.builder != null) {
                this.builder.setLength(0);
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$1500(NumberBuilder x0, byte x1) {
            void var1_1;
            return x0.appendSign((byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$1600(NumberBuilder x0, byte x1) {
            void var1_1;
            return x0.appendAlpha((byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$1700(NumberBuilder x0, byte x1) {
            void var1_1;
            x0.appendDigit((byte)var1_1);
        }
    }

    private static class Frame {
        private String name;
        private State state;
        private Object value;

        private Frame() {
        }

        /*
         * WARNING - void declaration
         */
        private void value(Object value) {
            switch (this.state) {
                case COMPLETE: 
                case STRING: 
                case OBJECT_FIELD_NAME: 
                case OBJECT_FIELD_VALUE: {
                    this.value = value;
                    return;
                }
                case ARRAY: {
                    void var1_1;
                    List list = (List)this.value;
                    list.add(var1_1);
                    return;
                }
            }
            throw new IllegalStateException("invalid state " + (Object)((Object)this.state));
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$1300(Frame x0, Object x1) {
            void var1_1;
            x0.value(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Object access$1002(Frame x0, Object x1) {
            void var1_1;
            x0.value = var1_1;
            return x0.value;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$1902(Frame x0, String x1) {
            void var1_1;
            x0.name = var1_1;
            return x0.name;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ State access$902(Frame x0, State x1) {
            void var1_1;
            x0.state = var1_1;
            return x0.state;
        }
    }

    private static enum State {
        COMPLETE,
        NULL,
        TRUE,
        FALSE,
        NUMBER,
        STRING,
        ESCAPE,
        UNICODE,
        ARRAY,
        OBJECT,
        OBJECT_FIELD,
        OBJECT_FIELD_NAME,
        OBJECT_FIELD_VALUE;

    }

    public static interface Context {
        public int depth();
    }

    public static class Factory {
        private Trie<CachedString> cache;
        private Map<String, JSON.Convertor> convertors;
        private Function<List<?>, Object> arrayConverter = list -> list;
        private boolean detailedParseException;

        public Function<List<?>, Object> getArrayConverter() {
            return this.arrayConverter;
        }

        /*
         * WARNING - void declaration
         */
        public void setArrayConverter(Function<List<?>, Object> arrayConverter) {
            void var1_1;
            this.arrayConverter = (Function)Objects.requireNonNull(var1_1);
        }

        public boolean isDetailedParseException() {
            return this.detailedParseException;
        }

        /*
         * WARNING - void declaration
         */
        public void setDetailedParseException(boolean detailedParseException) {
            void var1_1;
            this.detailedParseException = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean cache(String value) {
            CachedString cached;
            if (this.cache == null) {
                this.cache = new ArrayTernaryTrie.Growing(false, 64, 64);
            }
            if ((cached = new CachedString(value)).isCacheable()) {
                void var1_1;
                this.cache.put(cached.encoded, (Object)var1_1);
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        protected String cached(ByteBuffer buffer) {
            CachedString result;
            if (this.cache != null && (result = (CachedString)this.cache.getBest(buffer, 0, buffer.remaining())) != null) {
                void var2_2;
                void var1_1;
                void v0 = var1_1;
                v0.position(v0.position() + result.encoded.length());
                return ((CachedString)var2_2).value;
            }
            return null;
        }

        public AsyncJSON newAsyncJSON() {
            return new AsyncJSON(this);
        }

        /*
         * WARNING - void declaration
         */
        public void putConvertor(String className, JSON.Convertor convertor) {
            void var2_2;
            void var1_1;
            if (this.convertors == null) {
                this.convertors = new ConcurrentHashMap<String, JSON.Convertor>();
            }
            this.convertors.put((String)var1_1, (JSON.Convertor)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public JSON.Convertor removeConvertor(String className) {
            if (this.convertors != null) {
                void var1_1;
                return this.convertors.remove(var1_1);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public JSON.Convertor getConvertor(String className) {
            void var1_1;
            if (this.convertors == null) {
                return null;
            }
            return this.convertors.get(var1_1);
        }

        private static class CachedString {
            private final String encoded;
            private final String value;

            /*
             * WARNING - void declaration
             */
            private CachedString(String value) {
                void var1_1;
                this.encoded = JSON.toString(value);
                this.value = var1_1;
            }

            private boolean isCacheable() {
                int i = this.encoded.length();
                while (i-- > 0) {
                    char c = this.encoded.charAt(i);
                    if (c <= '\u007f') continue;
                    return false;
                }
                return true;
            }
        }
    }
}

