/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.util.internal.ObjectUtil;

public class SpdySessionStatus
implements Comparable<SpdySessionStatus> {
    public static final SpdySessionStatus OK = new SpdySessionStatus(0, "OK");
    public static final SpdySessionStatus PROTOCOL_ERROR = new SpdySessionStatus(1, "PROTOCOL_ERROR");
    public static final SpdySessionStatus INTERNAL_ERROR = new SpdySessionStatus(2, "INTERNAL_ERROR");
    private final int code;
    private final String statusPhrase;

    public static SpdySessionStatus valueOf(int code) {
        int n;
        switch (code) {
            case 0: {
                return OK;
            }
            case 1: {
                return PROTOCOL_ERROR;
            }
            case 2: {
                return INTERNAL_ERROR;
            }
        }
        return new SpdySessionStatus(code, "UNKNOWN (" + n + ')');
    }

    /*
     * WARNING - void declaration
     */
    public SpdySessionStatus(int code, String statusPhrase) {
        void var1_1;
        void var2_2;
        this.statusPhrase = (String)ObjectUtil.checkNotNull((Object)var2_2, (String)"statusPhrase");
        this.code = var1_1;
    }

    public int code() {
        return this.code;
    }

    public String statusPhrase() {
        return this.statusPhrase;
    }

    public int hashCode() {
        return this.code();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof SpdySessionStatus)) {
            return false;
        }
        return this.code() == ((SpdySessionStatus)var1_1).code();
    }

    public String toString() {
        return this.statusPhrase();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(SpdySessionStatus o) {
        void var1_1;
        return this.code() - var1_1.code();
    }
}

