/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyGoAwayFrame;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyPingFrame;
import io.netty.handler.codec.spdy.SpdyProtocolException;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdySession;
import io.netty.handler.codec.spdy.SpdySessionStatus;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.handler.codec.spdy.SpdyWindowUpdateFrame;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class SpdySessionHandler
extends ChannelDuplexHandler {
    private static final SpdyProtocolException PROTOCOL_EXCEPTION = SpdyProtocolException.newStatic(null, SpdySessionHandler.class, "handleOutboundMessage(...)");
    private static final SpdyProtocolException STREAM_CLOSED = SpdyProtocolException.newStatic("Stream closed", SpdySessionHandler.class, "removeStream(...)");
    private static final int DEFAULT_WINDOW_SIZE = 65536;
    private int initialSendWindowSize = 65536;
    private int initialReceiveWindowSize = 65536;
    private volatile int initialSessionReceiveWindowSize = 65536;
    private final SpdySession spdySession = new SpdySession(this.initialSendWindowSize, this.initialReceiveWindowSize);
    private int lastGoodStreamId;
    private static final int DEFAULT_MAX_CONCURRENT_STREAMS = Integer.MAX_VALUE;
    private int remoteConcurrentStreams = Integer.MAX_VALUE;
    private int localConcurrentStreams = Integer.MAX_VALUE;
    private final AtomicInteger pings = new AtomicInteger();
    private boolean sentGoAwayFrame;
    private boolean receivedGoAwayFrame;
    private ChannelFutureListener closeSessionFutureListener;
    private final boolean server;
    private final int minorVersion;

    /*
     * WARNING - void declaration
     */
    public SpdySessionHandler(SpdyVersion version, boolean server) {
        void var2_2;
        void var1_1;
        this.minorVersion = ((SpdyVersion)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"version"))).getMinorVersion();
        this.server = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionReceiveWindowSize(int sessionReceiveWindowSize) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)sessionReceiveWindowSize, (String)"sessionReceiveWindowSize");
        this.initialSessionReceiveWindowSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            int streamId = spdyDataFrame.streamId();
            int deltaWindowSize = -1 * spdyDataFrame.content().readableBytes();
            int newSessionWindowSize = this.spdySession.updateReceiveWindowSize(0, deltaWindowSize);
            if (newSessionWindowSize < 0) {
                this.issueSessionError(ctx, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            if (newSessionWindowSize <= this.initialSessionReceiveWindowSize / 2) {
                int sessionDeltaWindowSize = this.initialSessionReceiveWindowSize - newSessionWindowSize;
                this.spdySession.updateReceiveWindowSize(0, sessionDeltaWindowSize);
                DefaultSpdyWindowUpdateFrame spdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(0, sessionDeltaWindowSize);
                ctx.writeAndFlush((Object)spdyWindowUpdateFrame);
            }
            if (!this.spdySession.isActiveStream(streamId)) {
                spdyDataFrame.release();
                if (streamId <= this.lastGoodStreamId) {
                    this.issueStreamError(ctx, streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                    return;
                }
                if (!this.sentGoAwayFrame) {
                    this.issueStreamError(ctx, streamId, SpdyStreamStatus.INVALID_STREAM);
                }
                return;
            }
            if (this.spdySession.isRemoteSideClosed(streamId)) {
                spdyDataFrame.release();
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.STREAM_ALREADY_CLOSED);
                return;
            }
            if (!this.isRemoteInitiatedId(streamId) && !this.spdySession.hasReceivedReply(streamId)) {
                spdyDataFrame.release();
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            int newWindowSize = this.spdySession.updateReceiveWindowSize(streamId, deltaWindowSize);
            if (newWindowSize < this.spdySession.getReceiveWindowSizeLowerBound(streamId)) {
                spdyDataFrame.release();
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                return;
            }
            if (newWindowSize < 0) {
                while (spdyDataFrame.content().readableBytes() > this.initialReceiveWindowSize) {
                    DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamId, spdyDataFrame.content().readRetainedSlice(this.initialReceiveWindowSize));
                    ctx.writeAndFlush((Object)partialDataFrame);
                }
            }
            if (newWindowSize <= this.initialReceiveWindowSize / 2 && !spdyDataFrame.isLast()) {
                int streamDeltaWindowSize = this.initialReceiveWindowSize - newWindowSize;
                this.spdySession.updateReceiveWindowSize(streamId, streamDeltaWindowSize);
                DefaultSpdyWindowUpdateFrame spdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(streamId, streamDeltaWindowSize);
                ctx.writeAndFlush((Object)spdyWindowUpdateFrame);
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamId, true, ctx.newSucceededFuture());
            }
        } else if (msg instanceof SpdySynStreamFrame) {
            boolean localSideClosed;
            boolean remoteSideClosed;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamId = spdySynStreamFrame.streamId();
            if (spdySynStreamFrame.isInvalid() || !this.isRemoteInitiatedId(streamId) || this.spdySession.isActiveStream(streamId)) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (streamId <= this.lastGoodStreamId) {
                this.issueSessionError(ctx, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            byte priority = spdySynStreamFrame.priority();
            if (!this.acceptStream(streamId, priority, remoteSideClosed = spdySynStreamFrame.isLast(), localSideClosed = spdySynStreamFrame.isUnidirectional())) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.REFUSED_STREAM);
                return;
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamId = spdySynReplyFrame.streamId();
            if (spdySynReplyFrame.isInvalid() || this.isRemoteInitiatedId(streamId) || this.spdySession.isRemoteSideClosed(streamId)) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (this.spdySession.hasReceivedReply(streamId)) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.STREAM_IN_USE);
                return;
            }
            this.spdySession.receivedReply(streamId);
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamId, true, ctx.newSucceededFuture());
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            this.removeStream(spdyRstStreamFrame.streamId(), ctx.newSucceededFuture());
        } else if (msg instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            int settingsMinorVersion = spdySettingsFrame.getValue(0);
            if (settingsMinorVersion >= 0 && settingsMinorVersion != this.minorVersion) {
                this.issueSessionError(ctx, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            int newConcurrentStreams = spdySettingsFrame.getValue(4);
            if (newConcurrentStreams >= 0) {
                this.remoteConcurrentStreams = newConcurrentStreams;
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            int newInitialWindowSize = spdySettingsFrame.getValue(7);
            if (newInitialWindowSize >= 0) {
                this.updateInitialSendWindowSize(newInitialWindowSize);
            }
        } else if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            if (this.isRemoteInitiatedId(spdyPingFrame.id())) {
                ctx.writeAndFlush((Object)spdyPingFrame);
                return;
            }
            if (this.pings.get() == 0) {
                return;
            }
            this.pings.getAndDecrement();
        } else if (msg instanceof SpdyGoAwayFrame) {
            this.receivedGoAwayFrame = true;
        } else if (msg instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
            int streamId = spdyHeadersFrame.streamId();
            if (spdyHeadersFrame.isInvalid()) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (this.spdySession.isRemoteSideClosed(streamId)) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (spdyHeadersFrame.isLast()) {
                this.halfCloseStream(streamId, true, ctx.newSucceededFuture());
            }
        } else if (msg instanceof SpdyWindowUpdateFrame) {
            void var3_10;
            SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)msg;
            int streamId = spdyWindowUpdateFrame.streamId();
            int deltaWindowSize = var3_10.deltaWindowSize();
            if (streamId != 0 && this.spdySession.isLocalSideClosed(streamId)) {
                return;
            }
            if (this.spdySession.getSendWindowSize(streamId) > Integer.MAX_VALUE - deltaWindowSize) {
                if (streamId == 0) {
                    this.issueSessionError(ctx, SpdySessionStatus.PROTOCOL_ERROR);
                    return;
                }
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                return;
            }
            this.updateSendWindowSize(ctx, streamId, deltaWindowSize);
        }
        var1_1.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        for (Integer streamId : this.spdySession.activeStreams().keySet()) {
            void var3_3;
            this.removeStream(var3_3.intValue(), ctx.newSucceededFuture());
        }
        var1_1.fireChannelInactive();
    }

    /*
     * WARNING - void declaration
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var2_2;
        void var1_1;
        if (cause instanceof SpdyProtocolException) {
            this.issueSessionError(ctx, SpdySessionStatus.PROTOCOL_ERROR);
        }
        var1_1.fireExceptionCaught((Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        this.sendGoAwayFrame((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (msg instanceof SpdyDataFrame || msg instanceof SpdySynStreamFrame || msg instanceof SpdySynReplyFrame || msg instanceof SpdyRstStreamFrame || msg instanceof SpdySettingsFrame || msg instanceof SpdyPingFrame || msg instanceof SpdyGoAwayFrame || msg instanceof SpdyHeadersFrame || msg instanceof SpdyWindowUpdateFrame) {
            this.handleOutboundMessage(ctx, msg, promise);
            return;
        }
        var1_1.write((Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void handleOutboundMessage(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var1_1;
        void var2_2;
        if (msg instanceof SpdyDataFrame) {
            void partialDataFrame2;
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            int streamId = spdyDataFrame.streamId();
            if (this.spdySession.isLocalSideClosed(streamId)) {
                spdyDataFrame.release();
                promise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
            int dataLength = spdyDataFrame.content().readableBytes();
            int sendWindowSize = this.spdySession.getSendWindowSize(streamId);
            int sessionSendWindowSize = this.spdySession.getSendWindowSize(0);
            if ((sendWindowSize = Math.min(sendWindowSize, sessionSendWindowSize)) <= 0) {
                this.spdySession.putPendingWrite(streamId, new SpdySession.PendingWrite(spdyDataFrame, promise));
                return;
            }
            if (sendWindowSize < dataLength) {
                this.spdySession.updateSendWindowSize(streamId, -1 * sendWindowSize);
                this.spdySession.updateSendWindowSize(0, -1 * sendWindowSize);
                DefaultSpdyDataFrame partialDataFrame2 = new DefaultSpdyDataFrame(streamId, spdyDataFrame.content().readRetainedSlice(sendWindowSize));
                this.spdySession.putPendingWrite(streamId, new SpdySession.PendingWrite(spdyDataFrame, promise));
                ChannelHandlerContext context = ctx;
                ctx.write((Object)partialDataFrame2).addListener((GenericFutureListener)new ChannelFutureListener(this, (ChannelHandlerContext)var2_2){
                    final /* synthetic */ ChannelHandlerContext val$context;
                    final /* synthetic */ SpdySessionHandler this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$context = channelHandlerContext;
                    }

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            SpdySessionHandler.access$000(this.this$0, this.val$context, SpdySessionStatus.INTERNAL_ERROR);
                        }
                    }
                });
                return;
            }
            this.spdySession.updateSendWindowSize(streamId, -1 * partialDataFrame2);
            this.spdySession.updateSendWindowSize(0, -1 * partialDataFrame2);
            ChannelHandlerContext context = ctx;
            promise.addListener((GenericFutureListener)new ChannelFutureListener(this, context){
                final /* synthetic */ ChannelHandlerContext val$context;
                final /* synthetic */ SpdySessionHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$context = channelHandlerContext;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        SpdySessionHandler.access$000(this.this$0, this.val$context, SpdySessionStatus.INTERNAL_ERROR);
                    }
                }
            });
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamId, false, (ChannelFuture)promise);
            }
        } else if (var2_2 instanceof SpdySynStreamFrame) {
            boolean localSideClosed;
            boolean remoteSideClosed;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)var2_2;
            int streamId = spdySynStreamFrame.streamId();
            if (this.isRemoteInitiatedId(streamId)) {
                promise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
            byte priority = spdySynStreamFrame.priority();
            if (!this.acceptStream(streamId, priority, remoteSideClosed = spdySynStreamFrame.isUnidirectional(), localSideClosed = spdySynStreamFrame.isLast())) {
                promise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
        } else if (var2_2 instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)var2_2;
            int streamId = spdySynReplyFrame.streamId();
            if (!this.isRemoteInitiatedId(streamId) || this.spdySession.isLocalSideClosed(streamId)) {
                promise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamId, false, (ChannelFuture)promise);
            }
        } else if (var2_2 instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)var2_2;
            this.removeStream(spdyRstStreamFrame.streamId(), (ChannelFuture)promise);
        } else if (var2_2 instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)var2_2;
            int settingsMinorVersion = spdySettingsFrame.getValue(0);
            if (settingsMinorVersion >= 0 && settingsMinorVersion != this.minorVersion) {
                promise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
            int newConcurrentStreams = spdySettingsFrame.getValue(4);
            if (newConcurrentStreams >= 0) {
                this.localConcurrentStreams = newConcurrentStreams;
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            int newInitialWindowSize = spdySettingsFrame.getValue(7);
            if (newInitialWindowSize >= 0) {
                this.updateInitialReceiveWindowSize(newInitialWindowSize);
            }
        } else if (var2_2 instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)var2_2;
            if (this.isRemoteInitiatedId(spdyPingFrame.id())) {
                ctx.fireExceptionCaught((Throwable)new IllegalArgumentException("invalid PING ID: " + spdyPingFrame.id()));
                return;
            }
            this.pings.getAndIncrement();
        } else {
            if (var2_2 instanceof SpdyGoAwayFrame) {
                promise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
            if (var2_2 instanceof SpdyHeadersFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)var2_2;
                int streamId = spdyHeadersFrame.streamId();
                if (this.spdySession.isLocalSideClosed(streamId)) {
                    promise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                    return;
                }
                if (spdyHeadersFrame.isLast()) {
                    this.halfCloseStream(streamId, false, (ChannelFuture)promise);
                }
            } else if (var2_2 instanceof SpdyWindowUpdateFrame) {
                promise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
        }
        var1_1.write((Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void issueSessionError(ChannelHandlerContext ctx, SpdySessionStatus status) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this.sendGoAwayFrame(ctx, (SpdySessionStatus)var2_2).addListener((GenericFutureListener)new ClosingChannelFutureListener((ChannelHandlerContext)v0, v0.newPromise()));
    }

    /*
     * WARNING - void declaration
     */
    private void issueStreamError(ChannelHandlerContext ctx, int streamId, SpdyStreamStatus status) {
        void var3_4;
        boolean fireChannelRead = !this.spdySession.isRemoteSideClosed(streamId);
        ChannelPromise promise = ctx.newPromise();
        this.removeStream(streamId, (ChannelFuture)promise);
        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, (SpdyStreamStatus)var3_4);
        ctx.writeAndFlush((Object)spdyRstStreamFrame, promise);
        if (fireChannelRead) {
            void var2_3;
            void var1_1;
            var1_1.fireChannelRead((Object)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isRemoteInitiatedId(int id) {
        void var1_1;
        boolean serverId = SpdyCodecUtil.isServerId(id);
        return this.server && !serverId || !this.server && var1_1 != false;
    }

    /*
     * WARNING - void declaration
     */
    private void updateInitialSendWindowSize(int newInitialWindowSize) {
        void var2_2;
        void var1_1;
        int deltaWindowSize = newInitialWindowSize - this.initialSendWindowSize;
        this.initialSendWindowSize = var1_1;
        this.spdySession.updateAllSendWindowSizes((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void updateInitialReceiveWindowSize(int newInitialWindowSize) {
        void var2_2;
        void var1_1;
        int deltaWindowSize = newInitialWindowSize - this.initialReceiveWindowSize;
        this.initialReceiveWindowSize = var1_1;
        this.spdySession.updateAllReceiveWindowSizes((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean acceptStream(int streamId, byte priority, boolean remoteSideClosed, boolean localSideClosed) {
        void var3_3;
        void var2_2;
        int maxConcurrentStreams;
        if (this.receivedGoAwayFrame || this.sentGoAwayFrame) {
            return false;
        }
        boolean remote = this.isRemoteInitiatedId(streamId);
        int n = maxConcurrentStreams = remote ? this.localConcurrentStreams : this.remoteConcurrentStreams;
        if (this.spdySession.numActiveStreams(remote) >= maxConcurrentStreams) {
            return false;
        }
        this.spdySession.acceptStream(streamId, (byte)var2_2, (boolean)var3_3, localSideClosed, this.initialSendWindowSize, this.initialReceiveWindowSize, remote);
        if (remote) {
            void var1_1;
            this.lastGoodStreamId = var1_1;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void halfCloseStream(int streamId, boolean remote, ChannelFuture future) {
        if (remote) {
            this.spdySession.closeRemoteSide(streamId, this.isRemoteInitiatedId(streamId));
        } else {
            void var1_1;
            this.spdySession.closeLocalSide(streamId, this.isRemoteInitiatedId((int)var1_1));
        }
        if (this.closeSessionFutureListener != null && this.spdySession.noActiveStreams()) {
            void var3_3;
            var3_3.addListener((GenericFutureListener)this.closeSessionFutureListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeStream(int streamId, ChannelFuture future) {
        void var1_1;
        this.spdySession.removeStream(streamId, STREAM_CLOSED, this.isRemoteInitiatedId((int)var1_1));
        if (this.closeSessionFutureListener != null && this.spdySession.noActiveStreams()) {
            void var2_2;
            var2_2.addListener((GenericFutureListener)this.closeSessionFutureListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateSendWindowSize(ChannelHandlerContext ctx, int streamId, int deltaWindowSize) {
        this.spdySession.updateSendWindowSize(streamId, deltaWindowSize);
        SpdySession.PendingWrite pendingWrite;
        while ((pendingWrite = this.spdySession.getPendingWrite(streamId)) != null) {
            void var3_4;
            SpdyDataFrame spdyDataFrame = pendingWrite.spdyDataFrame;
            int dataFrameSize = spdyDataFrame.content().readableBytes();
            int writeStreamId = spdyDataFrame.streamId();
            int sendWindowSize = this.spdySession.getSendWindowSize(writeStreamId);
            int sessionSendWindowSize = this.spdySession.getSendWindowSize(0);
            if ((sendWindowSize = Math.min(sendWindowSize, sessionSendWindowSize)) <= 0) {
                return;
            }
            if (sendWindowSize < dataFrameSize) {
                this.spdySession.updateSendWindowSize(writeStreamId, -1 * sendWindowSize);
                this.spdySession.updateSendWindowSize(0, -1 * sendWindowSize);
                DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(writeStreamId, spdyDataFrame.content().readRetainedSlice(sendWindowSize));
                ctx.writeAndFlush((Object)var3_4).addListener((GenericFutureListener)new ChannelFutureListener(this, ctx){
                    final /* synthetic */ ChannelHandlerContext val$ctx;
                    final /* synthetic */ SpdySessionHandler this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$ctx = channelHandlerContext;
                    }

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            SpdySessionHandler.access$000(this.this$0, this.val$ctx, SpdySessionStatus.INTERNAL_ERROR);
                        }
                    }
                });
                continue;
            }
            this.spdySession.removePendingWrite(writeStreamId);
            this.spdySession.updateSendWindowSize(writeStreamId, -1 * dataFrameSize);
            this.spdySession.updateSendWindowSize(0, -1 * dataFrameSize);
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(writeStreamId, false, (ChannelFuture)var3_4.promise);
            }
            ctx.writeAndFlush((Object)spdyDataFrame, var3_4.promise).addListener((GenericFutureListener)new ChannelFutureListener(this, ctx){
                final /* synthetic */ ChannelHandlerContext val$ctx;
                final /* synthetic */ SpdySessionHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$ctx = channelHandlerContext;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        SpdySessionHandler.access$000(this.this$0, this.val$ctx, SpdySessionStatus.INTERNAL_ERROR);
                    }
                }
            });
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    private void sendGoAwayFrame(ChannelHandlerContext ctx, ChannelPromise future) {
        void var2_2;
        void var1_1;
        if (!ctx.channel().isActive()) {
            ctx.close(future);
            return;
        }
        ChannelFuture f = this.sendGoAwayFrame(ctx, SpdySessionStatus.OK);
        if (this.spdySession.noActiveStreams()) {
            void var3_3;
            var3_3.addListener((GenericFutureListener)new ClosingChannelFutureListener(ctx, future));
            return;
        }
        this.closeSessionFutureListener = new ClosingChannelFutureListener((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture sendGoAwayFrame(ChannelHandlerContext ctx, SpdySessionStatus status) {
        void var1_1;
        if (!this.sentGoAwayFrame) {
            void var2_2;
            this.sentGoAwayFrame = true;
            DefaultSpdyGoAwayFrame spdyGoAwayFrame = new DefaultSpdyGoAwayFrame(this.lastGoodStreamId, status);
            return ctx.writeAndFlush((Object)var2_2);
        }
        return var1_1.newSucceededFuture();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(SpdySessionHandler x0, ChannelHandlerContext x1, SpdySessionStatus x2) {
        void var2_2;
        void var1_1;
        x0.issueSessionError((ChannelHandlerContext)var1_1, (SpdySessionStatus)var2_2);
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelPromise promise;

        /*
         * WARNING - void declaration
         */
        ClosingChannelFutureListener(ChannelHandlerContext ctx, ChannelPromise promise) {
            void var2_2;
            void var1_1;
            this.ctx = var1_1;
            this.promise = var2_2;
        }

        public final void operationComplete(ChannelFuture sentGoAwayFuture) throws Exception {
            this.ctx.close(this.promise);
        }
    }
}

