/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.util.internal.PlatformDependent;
import java.util.Comparator;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

final class SpdySession {
    private final AtomicInteger activeLocalStreams = new AtomicInteger();
    private final AtomicInteger activeRemoteStreams = new AtomicInteger();
    private final Map<Integer, StreamState> activeStreams = PlatformDependent.newConcurrentHashMap();
    private final StreamComparator streamComparator = new StreamComparator();
    private final AtomicInteger sendWindowSize;
    private final AtomicInteger receiveWindowSize;

    /*
     * WARNING - void declaration
     */
    SpdySession(int sendWindowSize, int receiveWindowSize) {
        void var2_2;
        void var1_1;
        this.sendWindowSize = new AtomicInteger((int)var1_1);
        this.receiveWindowSize = new AtomicInteger((int)var2_2);
    }

    final int numActiveStreams(boolean remote) {
        if (remote) {
            return this.activeRemoteStreams.get();
        }
        return this.activeLocalStreams.get();
    }

    final boolean noActiveStreams() {
        return this.activeStreams.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    final boolean isActiveStream(int streamId) {
        void var1_1;
        return this.activeStreams.containsKey((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final Map<Integer, StreamState> activeStreams() {
        void var1_1;
        TreeMap<Integer, StreamState> streams = new TreeMap<Integer, StreamState>(this.streamComparator);
        streams.putAll(this.activeStreams);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void acceptStream(int streamId, byte priority, boolean remoteSideClosed, boolean localSideClosed, int sendWindowSize, int receiveWindowSize, boolean remote) {
        void var3_4;
        void var2_3;
        void var1_1;
        StreamState streamState;
        if (!(remoteSideClosed && localSideClosed || (streamState = this.activeStreams.put((int)var1_1, new StreamState((byte)var2_3, (boolean)var3_4, localSideClosed, sendWindowSize, receiveWindowSize))) != null)) {
            if (remote) {
                this.activeRemoteStreams.incrementAndGet();
                return;
            }
            this.activeLocalStreams.incrementAndGet();
        }
    }

    /*
     * WARNING - void declaration
     */
    private StreamState removeActiveStream(int streamId, boolean remote) {
        void var1_2;
        StreamState state = this.activeStreams.remove(streamId);
        if (state != null) {
            void var2_3;
            if (var2_3 != false) {
                this.activeRemoteStreams.decrementAndGet();
            } else {
                this.activeLocalStreams.decrementAndGet();
            }
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    final void removeStream(int streamId, Throwable cause, boolean remote) {
        void var3_4;
        StreamState state = this.removeActiveStream(streamId, (boolean)var3_4);
        if (state != null) {
            void var2_3;
            void var1_2;
            var1_2.clearPendingWrites((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean isRemoteSideClosed(int streamId) {
        void var1_2;
        StreamState state = this.activeStreams.get(streamId);
        return state == null || var1_2.isRemoteSideClosed();
    }

    /*
     * WARNING - void declaration
     */
    final void closeRemoteSide(int streamId, boolean remote) {
        StreamState state = this.activeStreams.get(streamId);
        if (state != null) {
            void var3_3;
            state.closeRemoteSide();
            if (var3_3.isLocalSideClosed()) {
                void var2_2;
                void var1_1;
                this.removeActiveStream((int)var1_1, (boolean)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean isLocalSideClosed(int streamId) {
        void var1_2;
        StreamState state = this.activeStreams.get(streamId);
        return state == null || var1_2.isLocalSideClosed();
    }

    /*
     * WARNING - void declaration
     */
    final void closeLocalSide(int streamId, boolean remote) {
        StreamState state = this.activeStreams.get(streamId);
        if (state != null) {
            void var3_3;
            state.closeLocalSide();
            if (var3_3.isRemoteSideClosed()) {
                void var2_2;
                void var1_1;
                this.removeActiveStream((int)var1_1, (boolean)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean hasReceivedReply(int streamId) {
        void var1_2;
        StreamState state = this.activeStreams.get(streamId);
        return state != null && var1_2.hasReceivedReply();
    }

    /*
     * WARNING - void declaration
     */
    final void receivedReply(int streamId) {
        StreamState state = this.activeStreams.get(streamId);
        if (state != null) {
            void var1_2;
            var1_2.receivedReply();
        }
    }

    /*
     * WARNING - void declaration
     */
    final int getSendWindowSize(int streamId) {
        if (streamId == 0) {
            return this.sendWindowSize.get();
        }
        StreamState state = this.activeStreams.get(streamId);
        if (state != null) {
            void var1_2;
            return var1_2.getSendWindowSize();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    final int updateSendWindowSize(int streamId, int deltaWindowSize) {
        if (streamId == 0) {
            return this.sendWindowSize.addAndGet(deltaWindowSize);
        }
        StreamState state = this.activeStreams.get(streamId);
        if (state != null) {
            void var2_3;
            void var1_2;
            return var1_2.updateSendWindowSize((int)var2_3);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    final int updateReceiveWindowSize(int streamId, int deltaWindowSize) {
        void var2_3;
        void var1_2;
        if (streamId == 0) {
            return this.receiveWindowSize.addAndGet(deltaWindowSize);
        }
        StreamState state = this.activeStreams.get(streamId);
        if (state == null) {
            return -1;
        }
        if (deltaWindowSize > 0) {
            state.setReceiveWindowSizeLowerBound(0);
        }
        return var1_2.updateReceiveWindowSize((int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    final int getReceiveWindowSizeLowerBound(int streamId) {
        if (streamId == 0) {
            return 0;
        }
        StreamState state = this.activeStreams.get(streamId);
        if (state != null) {
            void var1_2;
            return var1_2.getReceiveWindowSizeLowerBound();
        }
        return 0;
    }

    final void updateAllSendWindowSizes(int deltaWindowSize) {
        for (StreamState streamState : this.activeStreams.values()) {
            streamState.updateSendWindowSize(deltaWindowSize);
        }
    }

    /*
     * WARNING - void declaration
     */
    final void updateAllReceiveWindowSizes(int deltaWindowSize) {
        for (StreamState state : this.activeStreams.values()) {
            void var3_3;
            state.updateReceiveWindowSize(deltaWindowSize);
            if (deltaWindowSize >= 0) continue;
            var3_3.setReceiveWindowSizeLowerBound(deltaWindowSize);
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean putPendingWrite(int streamId, PendingWrite pendingWrite) {
        void var2_3;
        void var1_2;
        StreamState state = this.activeStreams.get(streamId);
        return state != null && var1_2.putPendingWrite((PendingWrite)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    final PendingWrite getPendingWrite(int streamId) {
        if (streamId == 0) {
            for (Map.Entry<Integer, StreamState> entry : this.activeStreams().entrySet()) {
                PendingWrite pendingWrite;
                StreamState state = entry.getValue();
                if (state.getSendWindowSize() <= 0 || (pendingWrite = state.getPendingWrite()) == null) continue;
                return entry;
            }
            return null;
        }
        StreamState state = this.activeStreams.get(streamId);
        if (state != null) {
            void var1_3;
            return var1_3.getPendingWrite();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    final PendingWrite removePendingWrite(int streamId) {
        StreamState state = this.activeStreams.get(streamId);
        if (state != null) {
            void var1_2;
            return var1_2.removePendingWrite();
        }
        return null;
    }

    public static final class PendingWrite {
        final SpdyDataFrame spdyDataFrame;
        final ChannelPromise promise;

        /*
         * WARNING - void declaration
         */
        PendingWrite(SpdyDataFrame spdyDataFrame, ChannelPromise promise) {
            void var2_2;
            void var1_1;
            this.spdyDataFrame = var1_1;
            this.promise = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        final void fail(Throwable cause) {
            void var1_1;
            this.spdyDataFrame.release();
            this.promise.setFailure((Throwable)var1_1);
        }
    }

    private final class StreamComparator
    implements Comparator<Integer> {
        StreamComparator() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(Integer id1, Integer id2) {
            void var2_2;
            void var1_1;
            StreamState state1 = (StreamState)SpdySession.this.activeStreams.get(id1);
            StreamState state2 = (StreamState)SpdySession.this.activeStreams.get(id2);
            int result = state1.getPriority() - state2.getPriority();
            if (result != 0) {
                void var3_4;
                return (int)var3_4;
            }
            return var1_1.intValue() - var2_2.intValue();
        }
    }

    private static final class StreamState {
        private final byte priority;
        private boolean remoteSideClosed;
        private boolean localSideClosed;
        private boolean receivedReply;
        private final AtomicInteger sendWindowSize;
        private final AtomicInteger receiveWindowSize;
        private int receiveWindowSizeLowerBound;
        private final Queue<PendingWrite> pendingWriteQueue = new ConcurrentLinkedQueue<PendingWrite>();

        /*
         * WARNING - void declaration
         */
        StreamState(byte priority, boolean remoteSideClosed, boolean localSideClosed, int sendWindowSize, int receiveWindowSize) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.priority = var1_1;
            this.remoteSideClosed = var2_2;
            this.localSideClosed = var3_3;
            this.sendWindowSize = new AtomicInteger(sendWindowSize);
            this.receiveWindowSize = new AtomicInteger(receiveWindowSize);
        }

        final byte getPriority() {
            return this.priority;
        }

        final boolean isRemoteSideClosed() {
            return this.remoteSideClosed;
        }

        final void closeRemoteSide() {
            this.remoteSideClosed = true;
        }

        final boolean isLocalSideClosed() {
            return this.localSideClosed;
        }

        final void closeLocalSide() {
            this.localSideClosed = true;
        }

        final boolean hasReceivedReply() {
            return this.receivedReply;
        }

        final void receivedReply() {
            this.receivedReply = true;
        }

        final int getSendWindowSize() {
            return this.sendWindowSize.get();
        }

        /*
         * WARNING - void declaration
         */
        final int updateSendWindowSize(int deltaWindowSize) {
            void var1_1;
            return this.sendWindowSize.addAndGet((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final int updateReceiveWindowSize(int deltaWindowSize) {
            void var1_1;
            return this.receiveWindowSize.addAndGet((int)var1_1);
        }

        final int getReceiveWindowSizeLowerBound() {
            return this.receiveWindowSizeLowerBound;
        }

        /*
         * WARNING - void declaration
         */
        final void setReceiveWindowSizeLowerBound(int receiveWindowSizeLowerBound) {
            void var1_1;
            this.receiveWindowSizeLowerBound = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final boolean putPendingWrite(PendingWrite msg) {
            void var1_1;
            return this.pendingWriteQueue.offer((PendingWrite)var1_1);
        }

        final PendingWrite getPendingWrite() {
            return this.pendingWriteQueue.peek();
        }

        final PendingWrite removePendingWrite() {
            return this.pendingWriteQueue.poll();
        }

        /*
         * WARNING - void declaration
         */
        final void clearPendingWrites(Throwable cause) {
            PendingWrite pendingWrite;
            while ((pendingWrite = this.pendingWriteQueue.poll()) != null) {
                void var2_2;
                var2_2.fail(cause);
            }
        }
    }
}

