/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public class SpdyHttpResponseStreamIdHandler
extends MessageToMessageCodec<Object, HttpMessage> {
    private static final Integer NO_ID = -1;
    private final Queue<Integer> ids = new ArrayDeque<Integer>();

    /*
     * WARNING - void declaration
     */
    public boolean acceptInboundMessage(Object msg) throws Exception {
        void var1_1;
        return msg instanceof HttpMessage || var1_1 instanceof SpdyRstStreamFrame;
    }

    /*
     * WARNING - void declaration
     */
    protected void encode(ChannelHandlerContext ctx, HttpMessage msg, List<Object> out) throws Exception {
        void var2_2;
        void var3_3;
        Integer id = this.ids.poll();
        if (id != null && id.intValue() != NO_ID.intValue() && !msg.headers().contains((CharSequence)SpdyHttpHeaders.Names.STREAM_ID)) {
            void var1_1;
            msg.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, var1_1.intValue());
        }
        var3_3.add(ReferenceCountUtil.retain((Object)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    protected void decode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        void var2_3;
        void var3_4;
        if (msg instanceof HttpMessage) {
            boolean bl = ((HttpMessage)msg).headers().contains((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
            if (!bl) {
                this.ids.add(NO_ID);
            } else {
                this.ids.add(((HttpMessage)msg).headers().getInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID));
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            this.ids.remove(((SpdyRstStreamFrame)msg).streamId());
        }
        var3_4.add(ReferenceCountUtil.retain((Object)var2_3));
    }
}

