/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.AsciiString;
import io.netty.util.internal.ObjectUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpdyHttpEncoder
extends MessageToMessageEncoder<HttpObject> {
    private int currentStreamId;
    private final boolean validateHeaders;
    private final boolean headersToLowerCase;

    /*
     * WARNING - void declaration
     */
    public SpdyHttpEncoder(SpdyVersion version) {
        this((SpdyVersion)var1_1, true, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SpdyHttpEncoder(SpdyVersion version, boolean headersToLowerCase, boolean validateHeaders) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)var1_1, (String)"version");
        this.headersToLowerCase = var2_2;
        this.validateHeaders = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void encode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        boolean bl;
        boolean spdyHeadersFrame22;
        boolean valid = false;
        boolean last = false;
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest22 = (HttpRequest)msg;
            SpdySynStreamFrame spdySynStreamFrame22 = this.createSynStreamFrame(httpRequest22);
            out.add(spdySynStreamFrame22);
            boolean spdySynStreamFrame22 = spdySynStreamFrame22.isLast() || spdySynStreamFrame22.isUnidirectional();
            boolean httpRequest22 = true;
        }
        if (msg instanceof HttpResponse) {
            HttpResponse httpResponse22 = (HttpResponse)msg;
            SpdyHeadersFrame spdyHeadersFrame22 = this.createHeadersFrame(httpResponse22);
            out.add(spdyHeadersFrame22);
            spdyHeadersFrame22 = spdyHeadersFrame22.isLast();
            boolean httpResponse22 = true;
        }
        if (msg instanceof HttpContent && !spdyHeadersFrame22) {
            HttpContent chunk = (HttpContent)msg;
            chunk.content().retain();
            DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(this.currentStreamId, chunk.content());
            if (chunk instanceof LastHttpContent) {
                HttpHeaders trailers = (chunk = (LastHttpContent)chunk).trailingHeaders();
                if (trailers.isEmpty()) {
                    spdyDataFrame.setLast(true);
                    out.add(spdyDataFrame);
                } else {
                    DefaultSpdyHeadersFrame spdyHeadersFrame = new DefaultSpdyHeadersFrame(this.currentStreamId, this.validateHeaders);
                    spdyHeadersFrame.setLast(true);
                    Iterator<Map.Entry<CharSequence, CharSequence>> itr = trailers.iteratorCharSequence();
                    while (itr.hasNext()) {
                        Map.Entry<CharSequence, CharSequence> entry = itr.next();
                        CharSequence headerName = this.headersToLowerCase ? AsciiString.of((CharSequence)entry.getKey()).toLowerCase() : entry.getKey();
                        spdyHeadersFrame.headers().add(headerName, entry.getValue());
                    }
                    out.add(spdyDataFrame);
                    out.add(spdyHeadersFrame);
                }
            } else {
                void var3_7;
                var3_7.add(spdyDataFrame);
            }
            bl = true;
        }
        if (!bl) {
            void var2_6;
            throw new UnsupportedMessageTypeException((Object)var2_6, new Class[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SpdySynStreamFrame createSynStreamFrame(HttpRequest httpRequest) throws Exception {
        void var3_4;
        HttpHeaders httpHeaders = httpRequest.headers();
        int streamId = httpHeaders.getInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        int associatedToStreamId = httpHeaders.getInt((CharSequence)SpdyHttpHeaders.Names.ASSOCIATED_TO_STREAM_ID, 0);
        byte priority = (byte)httpHeaders.getInt((CharSequence)SpdyHttpHeaders.Names.PRIORITY, 0);
        String scheme = httpHeaders.get((CharSequence)SpdyHttpHeaders.Names.SCHEME);
        httpHeaders.remove((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        httpHeaders.remove((CharSequence)SpdyHttpHeaders.Names.ASSOCIATED_TO_STREAM_ID);
        httpHeaders.remove((CharSequence)SpdyHttpHeaders.Names.PRIORITY);
        httpHeaders.remove((CharSequence)SpdyHttpHeaders.Names.SCHEME);
        httpHeaders.remove((CharSequence)HttpHeaderNames.CONNECTION);
        httpHeaders.remove("Keep-Alive");
        httpHeaders.remove("Proxy-Connection");
        httpHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(streamId, associatedToStreamId, priority, this.validateHeaders);
        SpdyHeaders frameHeaders = spdySynStreamFrame.headers();
        frameHeaders.set(SpdyHeaders.HttpNames.METHOD, httpRequest.method().name());
        frameHeaders.set(SpdyHeaders.HttpNames.PATH, httpRequest.uri());
        frameHeaders.set(SpdyHeaders.HttpNames.VERSION, httpRequest.protocolVersion().text());
        String host = httpHeaders.get((CharSequence)HttpHeaderNames.HOST);
        httpHeaders.remove((CharSequence)HttpHeaderNames.HOST);
        frameHeaders.set(SpdyHeaders.HttpNames.HOST, host);
        if (scheme == null) {
            scheme = "https";
        }
        frameHeaders.set(SpdyHeaders.HttpNames.SCHEME, scheme);
        Iterator<Map.Entry<CharSequence, CharSequence>> itr = httpHeaders.iteratorCharSequence();
        while (itr.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = itr.next();
            CharSequence headerName = this.headersToLowerCase ? AsciiString.of((CharSequence)entry.getKey()).toLowerCase() : entry.getKey();
            frameHeaders.add(headerName, entry.getValue());
        }
        this.currentStreamId = spdySynStreamFrame.streamId();
        if (associatedToStreamId == 0) {
            void var1_1;
            spdySynStreamFrame.setLast(SpdyHttpEncoder.isLast((HttpMessage)var1_1));
        } else {
            spdySynStreamFrame.setUnidirectional(true);
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private SpdyHeadersFrame createHeadersFrame(HttpResponse httpResponse) throws Exception {
        void var1_1;
        void var3_3;
        HttpHeaders httpHeaders = httpResponse.headers();
        int streamId = httpHeaders.getInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        httpHeaders.remove((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        httpHeaders.remove((CharSequence)HttpHeaderNames.CONNECTION);
        httpHeaders.remove("Keep-Alive");
        httpHeaders.remove("Proxy-Connection");
        httpHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        DefaultSpdyHeadersFrame spdyHeadersFrame = SpdyCodecUtil.isServerId(streamId) ? new DefaultSpdyHeadersFrame(streamId, this.validateHeaders) : new DefaultSpdySynReplyFrame(streamId, this.validateHeaders);
        SpdyHeaders frameHeaders = spdyHeadersFrame.headers();
        frameHeaders.set(SpdyHeaders.HttpNames.STATUS, httpResponse.status().codeAsText());
        frameHeaders.set(SpdyHeaders.HttpNames.VERSION, httpResponse.protocolVersion().text());
        Iterator<Map.Entry<CharSequence, CharSequence>> itr = httpHeaders.iteratorCharSequence();
        while (itr.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = itr.next();
            CharSequence headerName = this.headersToLowerCase ? AsciiString.of((CharSequence)entry.getKey()).toLowerCase() : entry.getKey();
            spdyHeadersFrame.headers().add(headerName, entry.getValue());
        }
        this.currentStreamId = var3_3;
        spdyHeadersFrame.setLast(SpdyHttpEncoder.isLast((HttpMessage)var1_1));
        return spdyHeadersFrame;
    }

    private static boolean isLast(HttpMessage httpMessage) {
        HttpMessage httpMessage2;
        HttpMessage fullMessage;
        return httpMessage instanceof FullHttpMessage && (fullMessage = (FullHttpMessage)httpMessage).trailingHeaders().isEmpty() && !httpMessage2.content().isReadable();
    }
}

