/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyFrame;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpdyHttpDecoder
extends MessageToMessageDecoder<SpdyFrame> {
    private final int spdyVersion;
    private final int maxContentLength;
    private final Map<Integer, FullHttpMessage> messageMap;
    private final HttpHeadersFactory headersFactory;
    private final HttpHeadersFactory trailersFactory;

    /*
     * WARNING - void declaration
     */
    public SpdyHttpDecoder(SpdyVersion version, int maxContentLength) {
        this((SpdyVersion)var1_1, (int)var2_2, new HashMap<Integer, FullHttpMessage>(), DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public SpdyHttpDecoder(SpdyVersion version, int maxContentLength, boolean validateHeaders) {
        this((SpdyVersion)var1_1, (int)var2_2, new HashMap<Integer, FullHttpMessage>(), (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SpdyHttpDecoder(SpdyVersion version, int maxContentLength, Map<Integer, FullHttpMessage> messageMap) {
        this((SpdyVersion)var1_1, (int)var2_2, (Map<Integer, FullHttpMessage>)var3_3, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected SpdyHttpDecoder(SpdyVersion version, int maxContentLength, Map<Integer, FullHttpMessage> messageMap, boolean validateHeaders) {
        this((SpdyVersion)var1_1, (int)var2_2, (Map<Integer, FullHttpMessage>)var3_3, DefaultHttpHeadersFactory.headersFactory().withValidation(validateHeaders), DefaultHttpHeadersFactory.trailersFactory().withValidation(validateHeaders));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SpdyHttpDecoder(SpdyVersion version, int maxContentLength, Map<Integer, FullHttpMessage> messageMap, HttpHeadersFactory headersFactory, HttpHeadersFactory trailersFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.spdyVersion = ((SpdyVersion)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"version"))).getVersion();
        this.maxContentLength = ObjectUtil.checkPositive((int)var2_2, (String)"maxContentLength");
        this.messageMap = var3_3;
        this.headersFactory = headersFactory;
        this.trailersFactory = trailersFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        for (Map.Entry<Integer, FullHttpMessage> entry : this.messageMap.entrySet()) {
            ReferenceCountUtil.safeRelease((Object)entry.getValue());
        }
        this.messageMap.clear();
        super.channelInactive((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected FullHttpMessage putMessage(int streamId, FullHttpMessage message) {
        void var2_2;
        void var1_1;
        return this.messageMap.put((int)var1_1, (FullHttpMessage)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected FullHttpMessage getMessage(int streamId) {
        void var1_1;
        return this.messageMap.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected FullHttpMessage removeMessage(int streamId) {
        void var1_1;
        return this.messageMap.remove((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void decode(ChannelHandlerContext ctx, SpdyFrame msg, List<Object> out) throws Exception {
        block32: {
            SpdyRstStreamFrame spdyRstStreamFrame;
            SpdyHeadersFrame spdyHeadersFrame;
            SpdySynReplyFrame spdySynReplyFrame;
            SpdySynStreamFrame spdySynStreamFrame;
            if (msg instanceof SpdySynStreamFrame) {
                block31: {
                    spdySynStreamFrame = (SpdySynStreamFrame)msg;
                    int streamId = spdySynStreamFrame.streamId();
                    if (SpdyCodecUtil.isServerId(streamId)) {
                        int associatedToStreamId = spdySynStreamFrame.associatedStreamId();
                        if (associatedToStreamId == 0) {
                            DefaultSpdyRstStreamFrame spdyRstStreamFrame2 = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.INVALID_STREAM);
                            ctx.writeAndFlush((Object)spdyRstStreamFrame2);
                            return;
                        }
                        if (spdySynStreamFrame.isLast()) {
                            DefaultSpdyRstStreamFrame spdyRstStreamFrame3 = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                            ctx.writeAndFlush((Object)spdyRstStreamFrame3);
                            return;
                        }
                        if (spdySynStreamFrame.isTruncated()) {
                            DefaultSpdyRstStreamFrame spdyRstStreamFrame4 = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.INTERNAL_ERROR);
                            ctx.writeAndFlush((Object)spdyRstStreamFrame4);
                            return;
                        }
                        try {
                            FullHttpRequest httpRequestWithEntity = SpdyHttpDecoder.createHttpRequest(spdySynStreamFrame, ctx.alloc());
                            httpRequestWithEntity.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, streamId);
                            httpRequestWithEntity.headers().setInt((CharSequence)SpdyHttpHeaders.Names.ASSOCIATED_TO_STREAM_ID, associatedToStreamId);
                            httpRequestWithEntity.headers().setInt((CharSequence)SpdyHttpHeaders.Names.PRIORITY, spdySynStreamFrame.priority());
                            out.add(httpRequestWithEntity);
                            break block31;
                        }
                        catch (Throwable throwable) {
                            DefaultSpdyRstStreamFrame spdyRstStreamFrame5 = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                            ctx.writeAndFlush((Object)spdyRstStreamFrame5);
                            break block32;
                        }
                    }
                    if (spdySynStreamFrame.isTruncated()) {
                        DefaultSpdySynReplyFrame spdySynReplyFrame2 = new DefaultSpdySynReplyFrame(streamId);
                        spdySynReplyFrame2.setLast(true);
                        SpdyHeaders frameHeaders = spdySynReplyFrame2.headers();
                        frameHeaders.setInt(SpdyHeaders.HttpNames.STATUS, HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE.code());
                        frameHeaders.setObject(SpdyHeaders.HttpNames.VERSION, HttpVersion.HTTP_1_0);
                        ctx.writeAndFlush((Object)spdySynReplyFrame2);
                        return;
                    }
                    try {
                        FullHttpRequest httpRequestWithEntity = SpdyHttpDecoder.createHttpRequest(spdySynStreamFrame, ctx.alloc());
                        httpRequestWithEntity.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, streamId);
                        if (spdySynStreamFrame.isLast()) {
                            out.add(httpRequestWithEntity);
                            break block31;
                        }
                        this.putMessage(streamId, httpRequestWithEntity);
                        break block32;
                    }
                    catch (Throwable throwable) {
                        DefaultSpdySynReplyFrame spdySynReplyFrame3 = new DefaultSpdySynReplyFrame(streamId);
                        spdySynReplyFrame3.setLast(true);
                        SpdyHeaders frameHeaders = spdySynReplyFrame3.headers();
                        frameHeaders.setInt(SpdyHeaders.HttpNames.STATUS, HttpResponseStatus.BAD_REQUEST.code());
                        frameHeaders.setObject(SpdyHeaders.HttpNames.VERSION, HttpVersion.HTTP_1_0);
                        ctx.writeAndFlush((Object)spdySynReplyFrame3);
                    }
                }
                return;
            }
            if (spdySynStreamFrame instanceof SpdySynReplyFrame) {
                block33: {
                    spdySynReplyFrame = (SpdySynReplyFrame)((Object)spdySynStreamFrame);
                    int streamId = spdySynReplyFrame.streamId();
                    if (spdySynReplyFrame.isTruncated()) {
                        DefaultSpdyRstStreamFrame spdyRstStreamFrame6 = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.INTERNAL_ERROR);
                        ctx.writeAndFlush((Object)spdyRstStreamFrame6);
                        return;
                    }
                    try {
                        FullHttpResponse httpResponseWithEntity = this.createHttpResponse(spdySynReplyFrame, ctx.alloc());
                        httpResponseWithEntity.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, streamId);
                        if (spdySynReplyFrame.isLast()) {
                            HttpUtil.setContentLength(httpResponseWithEntity, 0L);
                            out.add(httpResponseWithEntity);
                            break block33;
                        }
                        this.putMessage(streamId, httpResponseWithEntity);
                        break block32;
                    }
                    catch (Throwable throwable) {
                        DefaultSpdyRstStreamFrame spdyRstStreamFrame7 = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                        ctx.writeAndFlush((Object)spdyRstStreamFrame7);
                    }
                }
                return;
            }
            if (spdySynReplyFrame instanceof SpdyHeadersFrame) {
                spdyHeadersFrame = spdySynReplyFrame;
                int streamId = spdyHeadersFrame.streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(streamId);
                if (fullHttpMessage == null) {
                    if (SpdyCodecUtil.isServerId(streamId)) {
                        if (spdyHeadersFrame.isTruncated()) {
                            DefaultSpdyRstStreamFrame spdyRstStreamFrame8 = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.INTERNAL_ERROR);
                            ctx.writeAndFlush((Object)spdyRstStreamFrame8);
                            return;
                        }
                        try {
                            fullHttpMessage = this.createHttpResponse(spdyHeadersFrame, ctx.alloc());
                            fullHttpMessage.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, streamId);
                            if (!spdyHeadersFrame.isLast()) {
                                this.putMessage(streamId, fullHttpMessage);
                                return;
                            }
                            HttpUtil.setContentLength(fullHttpMessage, 0L);
                            out.add(fullHttpMessage);
                        }
                        catch (Throwable throwable) {
                            DefaultSpdyRstStreamFrame spdyRstStreamFrame9 = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                            ctx.writeAndFlush((Object)spdyRstStreamFrame9);
                        }
                    }
                    return;
                }
                if (!spdyHeadersFrame.isTruncated()) {
                    Iterator spdyRstStreamFrame8 = spdyHeadersFrame.headers().iterator();
                    while (spdyRstStreamFrame8.hasNext()) {
                        Map.Entry e = (Map.Entry)spdyRstStreamFrame8.next();
                        fullHttpMessage.headers().add((CharSequence)e.getKey(), e.getValue());
                    }
                }
                if (spdyHeadersFrame.isLast()) {
                    FullHttpMessage fullHttpMessage2 = fullHttpMessage;
                    HttpUtil.setContentLength(fullHttpMessage2, fullHttpMessage2.content().readableBytes());
                    this.removeMessage(streamId);
                    out.add(fullHttpMessage);
                }
                return;
            }
            if (spdyHeadersFrame instanceof SpdyDataFrame) {
                void var1_2;
                SpdyDataFrame spdyDataFrame = (SpdyDataFrame)((Object)spdyHeadersFrame);
                int streamId = spdyDataFrame.streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(streamId);
                if (fullHttpMessage == null) {
                    return;
                }
                ByteBuf content = fullHttpMessage.content();
                if (content.readableBytes() > this.maxContentLength - spdyDataFrame.content().readableBytes()) {
                    this.removeMessage(streamId);
                    throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
                }
                ByteBuf spdyDataFrameData = spdyDataFrame.content();
                int spdyDataFrameDataLen = spdyDataFrameData.readableBytes();
                ByteBuf byteBuf = spdyDataFrameData;
                content.writeBytes(byteBuf, byteBuf.readerIndex(), (int)var1_2);
                if (spdyRstStreamFrame.isLast()) {
                    void var3_4;
                    HttpUtil.setContentLength(fullHttpMessage, content.readableBytes());
                    this.removeMessage(streamId);
                    var3_4.add(fullHttpMessage);
                }
                return;
            }
            if (spdyRstStreamFrame instanceof SpdyRstStreamFrame) {
                spdyRstStreamFrame = spdyRstStreamFrame;
                int streamId = spdyRstStreamFrame.streamId();
                this.removeMessage(streamId);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static FullHttpRequest createHttpRequest(SpdyHeadersFrame requestFrame, ByteBufAllocator alloc) throws Exception {
        SpdyHeaders headers = requestFrame.headers();
        HttpMethod method = HttpMethod.valueOf(headers.getAsString((CharSequence)SpdyHeaders.HttpNames.METHOD));
        String url = headers.getAsString((CharSequence)SpdyHeaders.HttpNames.PATH);
        HttpVersion httpVersion = HttpVersion.valueOf(headers.getAsString((CharSequence)SpdyHeaders.HttpNames.VERSION));
        headers.remove(SpdyHeaders.HttpNames.METHOD);
        headers.remove(SpdyHeaders.HttpNames.PATH);
        headers.remove(SpdyHeaders.HttpNames.VERSION);
        boolean release = true;
        ByteBuf buffer = alloc.buffer();
        try {
            void var3_4;
            Object object;
            DefaultFullHttpRequest req = new DefaultFullHttpRequest(httpVersion, method, url, buffer);
            headers.remove(SpdyHeaders.HttpNames.SCHEME);
            CharSequence host = (CharSequence)headers.get(SpdyHeaders.HttpNames.HOST);
            headers.remove(SpdyHeaders.HttpNames.HOST);
            req.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)host);
            object = object.headers().iterator();
            while (object.hasNext()) {
                void var2_3;
                Map.Entry e = (Map.Entry)object.next();
                req.headers().add((CharSequence)e.getKey(), var2_3.getValue());
            }
            HttpUtil.setKeepAlive(req, true);
            req.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            release = false;
            object = var3_4;
            return object;
        }
        catch (Throwable throwable) {
            if (release) {
                void var1_2;
                var1_2.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private FullHttpResponse createHttpResponse(SpdyHeadersFrame responseFrame, ByteBufAllocator alloc) throws Exception {
        SpdyHeaders headers = responseFrame.headers();
        HttpResponseStatus status = HttpResponseStatus.parseLine((CharSequence)headers.get(SpdyHeaders.HttpNames.STATUS));
        HttpVersion version = HttpVersion.valueOf(headers.getAsString((CharSequence)SpdyHeaders.HttpNames.VERSION));
        headers.remove(SpdyHeaders.HttpNames.STATUS);
        headers.remove(SpdyHeaders.HttpNames.VERSION);
        boolean release = true;
        ByteBuf buffer = alloc.buffer();
        try {
            Object object;
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(version, status, buffer, this.headersFactory, this.trailersFactory);
            object = object.headers().iterator();
            while (object.hasNext()) {
                Map.Entry e = (Map.Entry)object.next();
                res.headers().add((CharSequence)e.getKey(), e.getValue());
            }
            HttpUtil.setKeepAlive(res, true);
            res.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            res.headers().remove((CharSequence)HttpHeaderNames.TRAILER);
            release = false;
            object = res;
            return object;
        }
        catch (Throwable throwable) {
            void var3_5;
            if (var3_5 != false) {
                void var2_3;
                var2_3.release();
            }
            throw throwable;
        }
    }
}

