/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyHeaderBlockRawEncoder;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import java.util.zip.Deflater;

class SpdyHeaderBlockZlibEncoder
extends SpdyHeaderBlockRawEncoder {
    private final Deflater compressor;
    private boolean finished;

    /*
     * WARNING - void declaration
     */
    SpdyHeaderBlockZlibEncoder(SpdyVersion spdyVersion, int compressionLevel) {
        super((SpdyVersion)var1_1);
        void var2_2;
        void var1_1;
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        this.compressor = new Deflater((int)var2_2);
        this.compressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
    }

    /*
     * WARNING - void declaration
     */
    private int setInput(ByteBuf decompressed) {
        void var2_2;
        int len = decompressed.readableBytes();
        if (decompressed.hasArray()) {
            this.compressor.setInput(decompressed.array(), decompressed.arrayOffset() + decompressed.readerIndex(), len);
        } else {
            void var3_3;
            void var1_1;
            byte[] in = new byte[len];
            void v0 = var1_1;
            v0.getBytes(v0.readerIndex(), in);
            this.compressor.setInput(in, 0, ((void)var3_3).length);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf encode(ByteBufAllocator alloc, int len) {
        ByteBuf compressed = alloc.heapBuffer(len);
        boolean release = true;
        try {
            while (this.compressInto(compressed)) {
                ByteBuf byteBuf = compressed;
                byteBuf.ensureWritable(byteBuf.capacity() << 1);
            }
            release = false;
            ByteBuf byteBuf = compressed;
            return byteBuf;
        }
        catch (Throwable throwable) {
            void var2_2;
            if (var2_2 != false) {
                void var1_1;
                var1_1.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Guarded by java version check")
    private boolean compressInto(ByteBuf compressed) {
        void var2_3;
        void var1_1;
        void var3_4;
        void numBytes;
        byte[] out = compressed.array();
        int off = compressed.arrayOffset() + compressed.writerIndex();
        int toWrite = compressed.writableBytes();
        int numBytes2 = PlatformDependent.javaVersion() >= 7 ? this.compressor.deflate(out, off, toWrite, 2) : this.compressor.deflate((byte[])numBytes, (int)var3_4, toWrite);
        void v0 = var1_1;
        v0.writerIndex(v0.writerIndex() + numBytes2);
        return var2_3 == toWrite;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, SpdyHeadersFrame frame) throws Exception {
        void var3_5;
        ByteBuf byteBuf;
        ByteBuf decompressed;
        block4: {
            ByteBuf byteBuf2;
            ObjectUtil.checkNotNullWithIAE((Object)alloc, (String)"alloc");
            ObjectUtil.checkNotNullWithIAE((Object)frame, (String)"frame");
            if (this.finished) {
                return Unpooled.EMPTY_BUFFER;
            }
            decompressed = super.encode(alloc, frame);
            try {
                if (decompressed.isReadable()) break block4;
                byteBuf2 = Unpooled.EMPTY_BUFFER;
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.release();
                throw throwable;
            }
            decompressed.release();
            return byteBuf2;
        }
        int len = this.setInput(decompressed);
        byteBuf = this.encode((ByteBufAllocator)byteBuf, (int)var3_5);
        decompressed.release();
        return byteBuf;
    }

    @Override
    public void end() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.compressor.end();
        super.end();
    }
}

