/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyHeaderBlockRawDecoder;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyProtocolException;
import io.netty.handler.codec.spdy.SpdyVersion;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

final class SpdyHeaderBlockZlibDecoder
extends SpdyHeaderBlockRawDecoder {
    private static final int DEFAULT_BUFFER_CAPACITY = 4096;
    private static final SpdyProtocolException INVALID_HEADER_BLOCK = new SpdyProtocolException("Invalid Header Block");
    private final Inflater decompressor = new Inflater();
    private ByteBuf decompressed;

    /*
     * WARNING - void declaration
     */
    SpdyHeaderBlockZlibDecoder(SpdyVersion spdyVersion, int maxHeaderSize) {
        super((SpdyVersion)var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void decode(ByteBufAllocator alloc, ByteBuf headerBlock, SpdyHeadersFrame frame) throws Exception {
        void var2_2;
        int n;
        int len = this.setInput(headerBlock);
        while ((n = this.decompress(alloc, frame)) > 0) {
        }
        if (this.decompressor.getRemaining() != 0) {
            throw INVALID_HEADER_BLOCK;
        }
        var2_2.skipBytes(len);
    }

    /*
     * WARNING - void declaration
     */
    private int setInput(ByteBuf compressed) {
        void var2_2;
        int len = compressed.readableBytes();
        if (compressed.hasArray()) {
            this.decompressor.setInput(compressed.array(), compressed.arrayOffset() + compressed.readerIndex(), len);
        } else {
            void var3_3;
            void var1_1;
            byte[] in = new byte[len];
            void v0 = var1_1;
            v0.getBytes(v0.readerIndex(), in);
            this.decompressor.setInput(in, 0, ((void)var3_3).length);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int decompress(ByteBufAllocator alloc, SpdyHeadersFrame frame) throws Exception {
        this.ensureBuffer(alloc);
        byte[] out = this.decompressed.array();
        int off = this.decompressed.arrayOffset() + this.decompressed.writerIndex();
        try {
            int numBytes = this.decompressor.inflate(out, off, this.decompressed.writableBytes());
            if (numBytes == 0 && this.decompressor.needsDictionary()) {
                void var3_3;
                void var1_1;
                try {
                    this.decompressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw INVALID_HEADER_BLOCK;
                }
                numBytes = this.decompressor.inflate((byte[])var1_1, (int)var3_3, this.decompressed.writableBytes());
            }
            if (frame != null) {
                void var2_2;
                this.decompressed.writerIndex(this.decompressed.writerIndex() + numBytes);
                SpdyHeaderBlockZlibDecoder spdyHeaderBlockZlibDecoder = this;
                spdyHeaderBlockZlibDecoder.decodeHeaderBlock(spdyHeaderBlockZlibDecoder.decompressed, (SpdyHeadersFrame)var2_2);
                this.decompressed.discardReadBytes();
            }
            return numBytes;
        }
        catch (DataFormatException e) {
            throw new SpdyProtocolException("Received invalid header block", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void ensureBuffer(ByteBufAllocator alloc) {
        if (this.decompressed == null) {
            void var1_1;
            this.decompressed = var1_1.heapBuffer(4096);
        }
        this.decompressed.ensureWritable(1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void endHeaderBlock(SpdyHeadersFrame frame) throws Exception {
        void var1_1;
        super.endHeaderBlock((SpdyHeadersFrame)var1_1);
        this.releaseBuffer();
    }

    @Override
    public final void end() {
        super.end();
        this.releaseBuffer();
        this.decompressor.end();
    }

    private void releaseBuffer() {
        if (this.decompressed != null) {
            this.decompressed.release();
            this.decompressed = null;
        }
    }
}

