/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.internal.ObjectUtil;
import java.util.Iterator;
import java.util.Set;

public class SpdyHeaderBlockRawEncoder
extends SpdyHeaderBlockEncoder {
    private final int version;

    /*
     * WARNING - void declaration
     */
    public SpdyHeaderBlockRawEncoder(SpdyVersion version) {
        void var1_1;
        this.version = ((SpdyVersion)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"version"))).getVersion();
    }

    /*
     * WARNING - void declaration
     */
    private static void setLengthField(ByteBuf buffer, int writerIndex, int length) {
        void var2_2;
        void var1_1;
        buffer.setInt((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeLengthField(ByteBuf buffer, int length) {
        void var1_1;
        buffer.writeInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, SpdyHeadersFrame frame) throws Exception {
        void var1_1;
        Iterator iterator;
        Set names = frame.headers().names();
        int numHeaders = names.size();
        if (numHeaders == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (numHeaders > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        ByteBuf headerBlock = alloc.heapBuffer();
        SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, numHeaders);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            CharSequence name = (CharSequence)iterator.next();
            SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, name.length());
            ByteBufUtil.writeAscii((ByteBuf)headerBlock, (CharSequence)name);
            int savedIndex = headerBlock.writerIndex();
            int valueLength = 0;
            SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, 0);
            for (CharSequence value : frame.headers().getAll(name)) {
                int length = value.length();
                if (length <= 0) continue;
                ByteBufUtil.writeAscii((ByteBuf)headerBlock, (CharSequence)value);
                headerBlock.writeByte(0);
                valueLength += length + 1;
            }
            if (valueLength != 0) {
                --valueLength;
            }
            if (valueLength > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + name);
            }
            if (valueLength <= 0) continue;
            SpdyHeaderBlockRawEncoder.setLengthField(headerBlock, savedIndex, valueLength);
            ByteBuf byteBuf = headerBlock;
            byteBuf.writerIndex(byteBuf.writerIndex() - 1);
        }
        return var1_1;
    }

    @Override
    void end() {
    }
}

