/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.JZlib;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.compression.CompressionException;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyHeaderBlockRawEncoder;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.internal.ObjectUtil;

class SpdyHeaderBlockJZlibEncoder
extends SpdyHeaderBlockRawEncoder {
    private final Deflater z = new Deflater();
    private boolean finished;

    /*
     * WARNING - void declaration
     */
    SpdyHeaderBlockJZlibEncoder(SpdyVersion version, int compressionLevel, int windowBits, int memLevel) {
        super(version);
        void var3_4;
        void var2_3;
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        if (windowBits < 9 || windowBits > 15) {
            throw new IllegalArgumentException("windowBits: " + windowBits + " (expected: 9-15)");
        }
        if (memLevel <= 0 || memLevel > 9) {
            throw new IllegalArgumentException("memLevel: " + memLevel + " (expected: 1-9)");
        }
        int resultCode = this.z.deflateInit((int)var2_3, (int)var3_4, memLevel, JZlib.W_ZLIB);
        if (resultCode != 0) {
            throw new CompressionException("failed to initialize an SPDY header block deflater: " + resultCode);
        }
        resultCode = this.z.deflateSetDictionary(SpdyCodecUtil.SPDY_DICT, SpdyCodecUtil.SPDY_DICT.length);
        if (resultCode != 0) {
            void var1_2;
            throw new CompressionException("failed to set the SPDY dictionary: " + (int)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setInput(ByteBuf decompressed) {
        void var2_3;
        void var1_2;
        void var3_4;
        int offset22;
        byte[] in;
        int len = decompressed.readableBytes();
        if (decompressed.hasArray()) {
            in = decompressed.array();
            offset22 = decompressed.arrayOffset() + decompressed.readerIndex();
        } else {
            void offset22;
            in = new byte[len];
            void v0 = offset22;
            v0.getBytes(v0.readerIndex(), in);
            offset22 = 0;
        }
        this.z.next_in = var3_4;
        this.z.next_in_index = var1_2;
        this.z.avail_in = var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf encode(ByteBufAllocator alloc) {
        boolean release = true;
        ByteBuf out = null;
        try {
            int resultCode;
            int oldNextInIndex = this.z.next_in_index;
            int oldNextOutIndex = this.z.next_out_index;
            int maxOutputLength = (int)Math.ceil((double)this.z.next_in.length * 1.001) + 12;
            out = alloc.heapBuffer(maxOutputLength);
            this.z.next_out = out.array();
            this.z.next_out_index = out.arrayOffset() + out.writerIndex();
            this.z.avail_out = maxOutputLength;
            try {
                resultCode = this.z.deflate(2);
            }
            finally {
                out.skipBytes(this.z.next_in_index - oldNextInIndex);
            }
            if (resultCode != 0) {
                throw new CompressionException("compression failure: " + resultCode);
            }
            int outputLength = this.z.next_out_index - oldNextOutIndex;
            if (outputLength > 0) {
                void var1_2;
                ByteBuf byteBuf = out;
                byteBuf.writerIndex(byteBuf.writerIndex() + var1_2);
            }
            release = false;
            ByteBuf byteBuf = out;
            this.z.next_in = null;
            this.z.next_out = null;
            return byteBuf;
        }
        catch (Throwable throwable) {
            void var2_6;
            this.z.next_in = null;
            this.z.next_out = null;
            if (var2_6 != false && out != null) {
                void var3_7;
                var3_7.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, SpdyHeadersFrame frame) throws Exception {
        ByteBuf byteBuf;
        ByteBuf decompressed;
        block4: {
            ObjectUtil.checkNotNullWithIAE((Object)alloc, (String)"alloc");
            ObjectUtil.checkNotNullWithIAE((Object)frame, (String)"frame");
            if (this.finished) {
                return Unpooled.EMPTY_BUFFER;
            }
            decompressed = super.encode(alloc, frame);
            try {
                if (decompressed.isReadable()) break block4;
                alloc = Unpooled.EMPTY_BUFFER;
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.release();
                throw throwable;
            }
            decompressed.release();
            return alloc;
        }
        this.setInput(decompressed);
        byteBuf = this.encode((ByteBufAllocator)byteBuf);
        decompressed.release();
        return byteBuf;
    }

    @Override
    public void end() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.z.deflateEnd();
        this.z.next_in = null;
        this.z.next_out = null;
    }
}

