/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Set;

public class SpdyFrameEncoder {
    private final int version;

    /*
     * WARNING - void declaration
     */
    public SpdyFrameEncoder(SpdyVersion spdyVersion) {
        void var1_1;
        this.version = ((SpdyVersion)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"spdyVersion"))).getVersion();
    }

    /*
     * WARNING - void declaration
     */
    private void writeControlFrameHeader(ByteBuf buffer, int type, byte flags, int length) {
        void var1_1;
        void var3_3;
        void var2_2;
        buffer.writeShort(this.version | 0x8000);
        buffer.writeShort((int)var2_2);
        buffer.writeByte((int)var3_3);
        var1_1.writeMedium(length);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf encodeDataFrame(ByteBufAllocator allocator, int streamId, boolean last, ByteBuf data) {
        void var1_1;
        void var3_3;
        void var2_2;
        boolean flags = last;
        int length = data.readableBytes();
        ByteBuf frame = allocator.ioBuffer(length + 8).order(ByteOrder.BIG_ENDIAN);
        frame.writeInt(var2_2 & Integer.MAX_VALUE);
        frame.writeByte((int)var3_3);
        frame.writeMedium(length);
        ByteBuf byteBuf = data;
        frame.writeBytes(byteBuf, byteBuf.readerIndex(), length);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf encodeSynStreamFrame(ByteBufAllocator allocator, int streamId, int associatedToStreamId, byte priority, boolean last, boolean unidirectional, ByteBuf headerBlock) {
        void var1_1;
        void var3_3;
        void var2_2;
        byte flags;
        int headerBlockLength = headerBlock.readableBytes();
        byte by = flags = last ? (byte)1 : 0;
        if (unidirectional) {
            flags = (byte)(flags | 2);
        }
        int length = headerBlockLength + 10;
        ByteBuf frame = allocator.ioBuffer(length + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame, 1, flags, length);
        frame.writeInt((int)var2_2);
        frame.writeInt((int)var3_3);
        frame.writeShort((priority & 0xFF) << 13);
        ByteBuf byteBuf = headerBlock;
        frame.writeBytes(byteBuf, byteBuf.readerIndex(), headerBlockLength);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf encodeSynReplyFrame(ByteBufAllocator allocator, int streamId, boolean last, ByteBuf headerBlock) {
        void var1_1;
        void var2_2;
        void var3_3;
        int headerBlockLength = headerBlock.readableBytes();
        boolean flags = last;
        int length = headerBlockLength + 4;
        ByteBuf frame = allocator.ioBuffer(length + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame, 2, (byte)var3_3, length);
        frame.writeInt((int)var2_2);
        ByteBuf byteBuf = headerBlock;
        frame.writeBytes(byteBuf, byteBuf.readerIndex(), headerBlockLength);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf encodeRstStreamFrame(ByteBufAllocator allocator, int streamId, int statusCode) {
        void var1_1;
        void var3_3;
        void var2_2;
        ByteBuf frame = allocator.ioBuffer(16).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame, 3, (byte)0, 8);
        frame.writeInt((int)var2_2);
        frame.writeInt((int)var3_3);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf encodeSettingsFrame(ByteBufAllocator allocator, SpdySettingsFrame spdySettingsFrame) {
        void var1_1;
        Iterator iterator;
        Set<Integer> ids = spdySettingsFrame.ids();
        int numSettings = ids.size();
        byte flags = spdySettingsFrame.clearPreviouslyPersistedSettings() ? (byte)1 : 0;
        int length = 4 + numSettings * 8;
        ByteBuf frame = allocator.ioBuffer(length + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame, 4, flags, length);
        frame.writeInt(numSettings);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Integer id = (Integer)iterator.next();
            flags = 0;
            if (spdySettingsFrame.isPersistValue(id)) {
                flags = 1;
            }
            if (spdySettingsFrame.isPersisted(id)) {
                flags = (byte)(flags | 2);
            }
            frame.writeByte((int)flags);
            frame.writeMedium(id.intValue());
            frame.writeInt(spdySettingsFrame.getValue(id));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf encodePingFrame(ByteBufAllocator allocator, int id) {
        void var1_1;
        void var2_2;
        ByteBuf frame = allocator.ioBuffer(12).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame, 6, (byte)0, 4);
        frame.writeInt((int)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf encodeGoAwayFrame(ByteBufAllocator allocator, int lastGoodStreamId, int statusCode) {
        void var1_1;
        void var3_3;
        void var2_2;
        ByteBuf frame = allocator.ioBuffer(16).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame, 7, (byte)0, 8);
        frame.writeInt((int)var2_2);
        frame.writeInt((int)var3_3);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf encodeHeadersFrame(ByteBufAllocator allocator, int streamId, boolean last, ByteBuf headerBlock) {
        void var1_1;
        void var2_2;
        void var3_3;
        int headerBlockLength = headerBlock.readableBytes();
        boolean flags = last;
        int length = headerBlockLength + 4;
        ByteBuf frame = allocator.ioBuffer(length + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame, 8, (byte)var3_3, length);
        frame.writeInt((int)var2_2);
        ByteBuf byteBuf = headerBlock;
        frame.writeBytes(byteBuf, byteBuf.readerIndex(), headerBlockLength);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf encodeWindowUpdateFrame(ByteBufAllocator allocator, int streamId, int deltaWindowSize) {
        void var1_1;
        void var3_3;
        void var2_2;
        ByteBuf frame = allocator.ioBuffer(16).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame, 9, (byte)0, 8);
        frame.writeInt((int)var2_2);
        frame.writeInt((int)var3_3);
        return var1_1;
    }
}

