/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.netty.handler.codec.spdy.DefaultSpdyPingFrame;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdySettingsFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyFrameDecoder;
import io.netty.handler.codec.spdy.SpdyFrameDecoderDelegate;
import io.netty.handler.codec.spdy.SpdyFrameEncoder;
import io.netty.handler.codec.spdy.SpdyGoAwayFrame;
import io.netty.handler.codec.spdy.SpdyHeaderBlockDecoder;
import io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyPingFrame;
import io.netty.handler.codec.spdy.SpdyProtocolException;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.handler.codec.spdy.SpdyWindowUpdateFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.List;

public class SpdyFrameCodec
extends ByteToMessageDecoder
implements ChannelOutboundHandler,
SpdyFrameDecoderDelegate {
    private static final SpdyProtocolException INVALID_FRAME = new SpdyProtocolException("Received invalid frame");
    private final SpdyFrameDecoder spdyFrameDecoder;
    private final SpdyFrameEncoder spdyFrameEncoder;
    private final SpdyHeaderBlockDecoder spdyHeaderBlockDecoder;
    private final SpdyHeaderBlockEncoder spdyHeaderBlockEncoder;
    private SpdyHeadersFrame spdyHeadersFrame;
    private SpdySettingsFrame spdySettingsFrame;
    private ChannelHandlerContext ctx;
    private boolean read;
    private final boolean validateHeaders;

    /*
     * WARNING - void declaration
     */
    public SpdyFrameCodec(SpdyVersion version) {
        this((SpdyVersion)var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SpdyFrameCodec(SpdyVersion version, boolean validateHeaders) {
        this((SpdyVersion)var1_1, 8192, 16384, 6, 15, 8, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SpdyFrameCodec(SpdyVersion version, int maxChunkSize, int maxHeaderSize, int compressionLevel, int windowBits, int memLevel) {
        this((SpdyVersion)var1_1, (int)var2_2, (int)var3_3, compressionLevel, windowBits, memLevel, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SpdyFrameCodec(SpdyVersion version, int maxChunkSize, int maxHeaderSize, int compressionLevel, int windowBits, int memLevel, boolean validateHeaders) {
        this(version, (int)var2_2, SpdyHeaderBlockDecoder.newInstance(version, (int)var3_3), SpdyHeaderBlockEncoder.newInstance((SpdyVersion)var1_1, compressionLevel, windowBits, memLevel), validateHeaders);
        void var1_1;
        void var3_3;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected SpdyFrameCodec(SpdyVersion version, int maxChunkSize, SpdyHeaderBlockDecoder spdyHeaderBlockDecoder, SpdyHeaderBlockEncoder spdyHeaderBlockEncoder, boolean validateHeaders) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.spdyFrameDecoder = new SpdyFrameDecoder(version, this, (int)var2_2);
        this.spdyFrameEncoder = new SpdyFrameEncoder((SpdyVersion)var1_1);
        this.spdyHeaderBlockDecoder = var3_3;
        this.spdyHeaderBlockEncoder = spdyHeaderBlockEncoder;
        this.validateHeaders = validateHeaders;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        super.handlerAdded(ctx);
        this.ctx = ctx;
        var1_1.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(this){
            final /* synthetic */ SpdyFrameCodec this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public void operationComplete(ChannelFuture future) throws Exception {
                this.this$0.spdyHeaderBlockDecoder.end();
                this.this$0.spdyHeaderBlockEncoder.end();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        void var2_2;
        this.spdyFrameDecoder.decode((ByteBuf)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (!this.read && !ctx.channel().config().isAutoRead()) {
            ctx.read();
        }
        this.read = false;
        super.channelReadComplete((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.bind((SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.connect((SocketAddress)var2_2, (SocketAddress)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.disconnect((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.close((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.deregister((ChannelPromise)var2_2);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var2_5;
        ByteBuf frame;
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            frame = this.spdyFrameEncoder.encodeDataFrame(ctx.alloc(), spdyDataFrame.streamId(), spdyDataFrame.isLast(), spdyDataFrame.content());
            spdyDataFrame.release();
            ctx.write((Object)frame, promise);
            return;
        }
        if (frame instanceof SpdySynStreamFrame) {
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)frame;
            ByteBuf headerBlock = this.spdyHeaderBlockEncoder.encode(ctx.alloc(), spdySynStreamFrame);
            try {
                frame = this.spdyFrameEncoder.encodeSynStreamFrame(ctx.alloc(), spdySynStreamFrame.streamId(), spdySynStreamFrame.associatedStreamId(), spdySynStreamFrame.priority(), spdySynStreamFrame.isLast(), spdySynStreamFrame.isUnidirectional(), headerBlock);
            }
            finally {
                headerBlock.release();
            }
            ctx.write((Object)frame, promise);
            return;
        }
        if (frame instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)frame;
            ByteBuf headerBlock = this.spdyHeaderBlockEncoder.encode(ctx.alloc(), spdySynReplyFrame);
            try {
                frame = this.spdyFrameEncoder.encodeSynReplyFrame(ctx.alloc(), spdySynReplyFrame.streamId(), spdySynReplyFrame.isLast(), headerBlock);
            }
            finally {
                headerBlock.release();
            }
            ctx.write((Object)frame, promise);
            return;
        }
        if (frame instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)frame;
            frame = this.spdyFrameEncoder.encodeRstStreamFrame(ctx.alloc(), spdyRstStreamFrame.streamId(), spdyRstStreamFrame.status().code());
            ctx.write((Object)frame, promise);
            return;
        }
        if (frame instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)frame;
            frame = this.spdyFrameEncoder.encodeSettingsFrame(ctx.alloc(), spdySettingsFrame);
            ctx.write((Object)frame, promise);
            return;
        }
        if (frame instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)frame;
            frame = this.spdyFrameEncoder.encodePingFrame(ctx.alloc(), spdyPingFrame.id());
            ctx.write((Object)frame, promise);
            return;
        }
        if (frame instanceof SpdyGoAwayFrame) {
            SpdyGoAwayFrame spdyGoAwayFrame = (SpdyGoAwayFrame)frame;
            frame = this.spdyFrameEncoder.encodeGoAwayFrame(ctx.alloc(), spdyGoAwayFrame.lastGoodStreamId(), spdyGoAwayFrame.status().code());
            ctx.write((Object)frame, promise);
            return;
        }
        if (frame instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)frame;
            ByteBuf headerBlock = this.spdyHeaderBlockEncoder.encode(ctx.alloc(), spdyHeadersFrame);
            try {
                frame = this.spdyFrameEncoder.encodeHeadersFrame(ctx.alloc(), spdyHeadersFrame.streamId(), spdyHeadersFrame.isLast(), headerBlock);
            }
            finally {
                headerBlock.release();
            }
            ctx.write((Object)frame, promise);
            return;
        }
        if (frame instanceof SpdyWindowUpdateFrame) {
            void var3_6;
            void var1_1;
            SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)frame;
            frame = this.spdyFrameEncoder.encodeWindowUpdateFrame(ctx.alloc(), spdyWindowUpdateFrame.streamId(), spdyWindowUpdateFrame.deltaWindowSize());
            var1_1.write((Object)var2_5, (ChannelPromise)var3_6);
            return;
        }
        throw new UnsupportedMessageTypeException((Object)var2_5, new Class[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readDataFrame(int streamId, boolean last, ByteBuf data) {
        void var1_2;
        void var2_3;
        void var3_4;
        this.read = true;
        DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamId, (ByteBuf)var3_4);
        spdyDataFrame.setLast((boolean)var2_3);
        this.ctx.fireChannelRead((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readSynStreamFrame(int streamId, int associatedToStreamId, byte priority, boolean last, boolean unidirectional) {
        void var1_2;
        void var3_4;
        void var2_3;
        DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(streamId, (int)var2_3, (byte)var3_4, this.validateHeaders);
        spdySynStreamFrame.setLast(last);
        spdySynStreamFrame.setUnidirectional(unidirectional);
        this.spdyHeadersFrame = var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readSynReplyFrame(int streamId, boolean last) {
        void var1_2;
        void var2_3;
        DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamId, this.validateHeaders);
        spdySynReplyFrame.setLast((boolean)var2_3);
        this.spdyHeadersFrame = var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readRstStreamFrame(int streamId, int statusCode) {
        void var1_2;
        void var2_3;
        this.read = true;
        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, (int)var2_3);
        this.ctx.fireChannelRead((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readSettingsFrame(boolean clearPersisted) {
        void var1_1;
        this.read = true;
        this.spdySettingsFrame = new DefaultSpdySettingsFrame();
        this.spdySettingsFrame.setClearPreviouslyPersistedSettings((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readSetting(int id, int value, boolean persistValue, boolean persisted) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.spdySettingsFrame.setValue((int)var1_1, (int)var2_2, (boolean)var3_3, persisted);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readSettingsEnd() {
        void var1_1;
        this.read = true;
        SpdySettingsFrame frame = this.spdySettingsFrame;
        this.spdySettingsFrame = null;
        this.ctx.fireChannelRead((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readPingFrame(int id) {
        void var1_2;
        this.read = true;
        DefaultSpdyPingFrame spdyPingFrame = new DefaultSpdyPingFrame(id);
        this.ctx.fireChannelRead((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readGoAwayFrame(int lastGoodStreamId, int statusCode) {
        void var1_2;
        void var2_3;
        this.read = true;
        DefaultSpdyGoAwayFrame spdyGoAwayFrame = new DefaultSpdyGoAwayFrame(lastGoodStreamId, (int)var2_3);
        this.ctx.fireChannelRead((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readHeadersFrame(int streamId, boolean last) {
        void var2_2;
        void var1_1;
        this.spdyHeadersFrame = new DefaultSpdyHeadersFrame((int)var1_1, this.validateHeaders);
        this.spdyHeadersFrame.setLast((boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readWindowUpdateFrame(int streamId, int deltaWindowSize) {
        void var1_2;
        void var2_3;
        this.read = true;
        DefaultSpdyWindowUpdateFrame spdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(streamId, (int)var2_3);
        this.ctx.fireChannelRead((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readHeaderBlock(ByteBuf headerBlock) {
        try {
            this.spdyHeaderBlockDecoder.decode(this.ctx.alloc(), headerBlock, this.spdyHeadersFrame);
        }
        catch (Exception e) {
            try {
                void var2_2;
                this.ctx.fireExceptionCaught((Throwable)var2_2);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.release();
                throw throwable;
            }
            headerBlock.release();
            return;
        }
        headerBlock.release();
        return;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readHeaderBlockEnd() {
        SpdyHeadersFrame frame = null;
        try {
            this.spdyHeaderBlockDecoder.endHeaderBlock(this.spdyHeadersFrame);
            frame = this.spdyHeadersFrame;
            this.spdyHeadersFrame = null;
        }
        catch (Exception e) {
            void var2_2;
            this.ctx.fireExceptionCaught((Throwable)var2_2);
        }
        if (frame != null) {
            void var1_1;
            this.read = true;
            this.ctx.fireChannelRead((Object)var1_1);
        }
    }

    @Override
    public void readFrameError(String message) {
        this.ctx.fireExceptionCaught((Throwable)INVALID_FRAME);
    }
}

