/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.util.internal.StringUtil;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DefaultSpdySettingsFrame
implements SpdySettingsFrame {
    private boolean clear;
    private final Map<Integer, Setting> settingsMap = new TreeMap<Integer, Setting>();

    @Override
    public Set<Integer> ids() {
        return this.settingsMap.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSet(int id) {
        void var1_1;
        return this.settingsMap.containsKey((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getValue(int id) {
        Setting setting = this.settingsMap.get(id);
        if (setting != null) {
            void var1_2;
            return var1_2.getValue();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpdySettingsFrame setValue(int id, int value) {
        void var2_2;
        void var1_1;
        return this.setValue((int)var1_1, (int)var2_2, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpdySettingsFrame setValue(int id, int value, boolean persistValue, boolean persisted) {
        if (id < 0 || id > 0xFFFFFF) {
            throw new IllegalArgumentException("Setting ID is not valid: " + id);
        }
        Integer key = id;
        Setting setting = this.settingsMap.get(key);
        if (setting != null) {
            setting.setValue(value);
            setting.setPersist(persistValue);
            setting.setPersisted(persisted);
        } else {
            void var3_4;
            void var2_3;
            void var1_2;
            this.settingsMap.put((Integer)var1_2, new Setting((int)var2_3, (boolean)var3_4, persisted));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpdySettingsFrame removeValue(int id) {
        void var1_1;
        this.settingsMap.remove((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isPersistValue(int id) {
        void var1_2;
        Setting setting = this.settingsMap.get(id);
        return setting != null && var1_2.isPersist();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpdySettingsFrame setPersistValue(int id, boolean persistValue) {
        Setting setting = this.settingsMap.get(id);
        if (setting != null) {
            void var2_3;
            void var1_2;
            var1_2.setPersist((boolean)var2_3);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isPersisted(int id) {
        void var1_2;
        Setting setting = this.settingsMap.get(id);
        return setting != null && var1_2.isPersisted();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpdySettingsFrame setPersisted(int id, boolean persisted) {
        Setting setting = this.settingsMap.get(id);
        if (setting != null) {
            void var2_3;
            void var1_2;
            var1_2.setPersisted((boolean)var2_3);
        }
        return this;
    }

    @Override
    public boolean clearPreviouslyPersistedSettings() {
        return this.clear;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpdySettingsFrame setClearPreviouslyPersistedSettings(boolean clear) {
        void var1_1;
        this.clear = var1_1;
        return this;
    }

    private Set<Map.Entry<Integer, Setting>> getSettings() {
        return this.settingsMap.entrySet();
    }

    /*
     * WARNING - void declaration
     */
    private void appendSettings(StringBuilder buf) {
        for (Map.Entry<Integer, Setting> e : this.getSettings()) {
            void var3_3;
            Setting setting = e.getValue();
            buf.append("--> ");
            buf.append(var3_3.getKey());
            buf.append(':');
            buf.append(setting.getValue());
            buf.append(" (persist value: ");
            buf.append(setting.isPersist());
            buf.append("; persisted: ");
            buf.append(setting.isPersisted());
            buf.append(')');
            buf.append(StringUtil.NEWLINE);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder().append(StringUtil.simpleClassName((Object)this)).append(StringUtil.NEWLINE);
        this.appendSettings(buf);
        StringBuilder stringBuilder = buf;
        stringBuilder.setLength(stringBuilder.length() - StringUtil.NEWLINE.length());
        return var1_1.toString();
    }

    private static final class Setting {
        private int value;
        private boolean persist;
        private boolean persisted;

        /*
         * WARNING - void declaration
         */
        Setting(int value, boolean persist, boolean persisted) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.value = var1_1;
            this.persist = var2_2;
            this.persisted = var3_3;
        }

        final int getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        final void setValue(int value) {
            void var1_1;
            this.value = var1_1;
        }

        final boolean isPersist() {
            return this.persist;
        }

        /*
         * WARNING - void declaration
         */
        final void setPersist(boolean persist) {
            void var1_1;
            this.persist = var1_1;
        }

        final boolean isPersisted() {
            return this.persisted;
        }

        /*
         * WARNING - void declaration
         */
        final void setPersisted(boolean persisted) {
            void var1_1;
            this.persisted = var1_1;
        }
    }
}

