/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultSpdyHeaders
extends DefaultHeaders<CharSequence, CharSequence, SpdyHeaders>
implements SpdyHeaders {
    private static final DefaultHeaders.NameValidator<CharSequence> SpdyNameValidator = new DefaultHeaders.NameValidator<CharSequence>(){

        public final void validateName(CharSequence name) {
            SpdyCodecUtil.validateHeaderName(name);
        }
    };

    public DefaultSpdyHeaders() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultSpdyHeaders(boolean validate) {
        super(AsciiString.CASE_INSENSITIVE_HASHER, (ValueConverter)(validate ? HeaderValueConverterAndValidator.INSTANCE : CharSequenceValueConverter.INSTANCE), var1_1 != false ? SpdyNameValidator : DefaultHeaders.NameValidator.NOT_NULL);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getAsString(CharSequence name) {
        void var1_1;
        return HeadersUtils.getAsString((Headers)this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> getAllAsString(CharSequence name) {
        void var1_1;
        return HeadersUtils.getAllAsString((Headers)this, (Object)var1_1);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iteratorAsString() {
        return HeadersUtils.iteratorAsString((Iterable)((Object)this));
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(CharSequence name, CharSequence value) {
        void var2_2;
        void var1_1;
        return this.contains((CharSequence)var1_1, (CharSequence)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.contains(var1_1, var2_2, var3_3 != false ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    private static final class HeaderValueConverterAndValidator
    extends CharSequenceValueConverter {
        public static final HeaderValueConverterAndValidator INSTANCE = new HeaderValueConverterAndValidator();

        private HeaderValueConverterAndValidator() {
        }

        /*
         * WARNING - void declaration
         */
        public final CharSequence convertObject(Object value) {
            void var1_1;
            CharSequence seq = super.convertObject(value);
            SpdyCodecUtil.validateHeaderValue(seq);
            return var1_1;
        }
    }
}

