/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.DefaultSpdyStreamFrame;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;

public class DefaultSpdyDataFrame
extends DefaultSpdyStreamFrame
implements SpdyDataFrame {
    private final ByteBuf data;

    /*
     * WARNING - void declaration
     */
    public DefaultSpdyDataFrame(int streamId) {
        this((int)var1_1, Unpooled.buffer((int)0));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultSpdyDataFrame(int streamId, ByteBuf data) {
        super((int)var1_1);
        void var2_2;
        void var1_1;
        this.data = DefaultSpdyDataFrame.validate((ByteBuf)ObjectUtil.checkNotNull((Object)var2_2, (String)"data"));
    }

    private static ByteBuf validate(ByteBuf data) {
        ByteBuf byteBuf;
        if (data.readableBytes() > 0xFFFFFF) {
            throw new IllegalArgumentException("data payload cannot exceed 16777215 bytes");
        }
        return byteBuf;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpdyDataFrame setStreamId(int streamId) {
        void var1_1;
        super.setStreamId((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpdyDataFrame setLast(boolean last) {
        void var1_1;
        super.setLast((boolean)var1_1);
        return this;
    }

    @Override
    public ByteBuf content() {
        return ByteBufUtil.ensureAccessible((ByteBuf)this.data);
    }

    @Override
    public SpdyDataFrame copy() {
        DefaultSpdyDataFrame defaultSpdyDataFrame = this;
        return defaultSpdyDataFrame.replace(defaultSpdyDataFrame.content().copy());
    }

    @Override
    public SpdyDataFrame duplicate() {
        DefaultSpdyDataFrame defaultSpdyDataFrame = this;
        return defaultSpdyDataFrame.replace(defaultSpdyDataFrame.content().duplicate());
    }

    @Override
    public SpdyDataFrame retainedDuplicate() {
        DefaultSpdyDataFrame defaultSpdyDataFrame = this;
        return defaultSpdyDataFrame.replace(defaultSpdyDataFrame.content().retainedDuplicate());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpdyDataFrame replace(ByteBuf content) {
        void var1_1;
        DefaultSpdyDataFrame frame = new DefaultSpdyDataFrame(this.streamId(), content);
        frame.setLast(this.isLast());
        return var1_1;
    }

    public int refCnt() {
        return this.data.refCnt();
    }

    @Override
    public SpdyDataFrame retain() {
        this.data.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpdyDataFrame retain(int increment) {
        void var1_1;
        this.data.retain((int)var1_1);
        return this;
    }

    @Override
    public SpdyDataFrame touch() {
        this.data.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpdyDataFrame touch(Object hint) {
        void var1_1;
        this.data.touch((Object)var1_1);
        return this;
    }

    public boolean release() {
        return this.data.release();
    }

    /*
     * WARNING - void declaration
     */
    public boolean release(int decrement) {
        void var1_1;
        return this.data.release((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder().append(StringUtil.simpleClassName((Object)this)).append("(last: ").append(this.isLast()).append(')').append(StringUtil.NEWLINE).append("--> Stream-ID = ").append(this.streamId()).append(StringUtil.NEWLINE).append("--> Size = ");
        if (this.refCnt() == 0) {
            buf.append("(freed)");
        } else {
            buf.append(this.content().readableBytes());
        }
        return var1_1.toString();
    }
}

