/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.rtsp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectEncoder;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;

public class RtspEncoder
extends HttpObjectEncoder<HttpMessage> {
    private static final int CRLF_SHORT = 3338;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        void var1_1;
        return super.acceptOutboundMessage(msg) && (msg instanceof HttpRequest || var1_1 instanceof HttpResponse);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpMessage message) throws Exception {
        void var2_2;
        HttpRequest request;
        if (message instanceof HttpRequest) {
            request = (HttpRequest)message;
            ByteBufUtil.copy((AsciiString)request.method().asciiName(), (ByteBuf)buf);
            buf.writeByte(32);
            buf.writeCharSequence((CharSequence)request.uri(), CharsetUtil.UTF_8);
            buf.writeByte(32);
            buf.writeCharSequence((CharSequence)request.protocolVersion().toString(), CharsetUtil.US_ASCII);
            ByteBufUtil.writeShortBE((ByteBuf)buf, (int)3338);
            return;
        }
        if (request instanceof HttpResponse) {
            void var1_1;
            HttpResponse response = (HttpResponse)((Object)request);
            buf.writeCharSequence((CharSequence)response.protocolVersion().toString(), CharsetUtil.US_ASCII);
            buf.writeByte(32);
            ByteBufUtil.copy((AsciiString)response.status().codeAsText(), (ByteBuf)buf);
            buf.writeByte(32);
            buf.writeCharSequence((CharSequence)var2_2.status().reasonPhrase(), CharsetUtil.US_ASCII);
            ByteBufUtil.writeShortBE((ByteBuf)var1_1, (int)3338);
            return;
        }
        throw new UnsupportedMessageTypeException((Object)var2_2, new Class[]{HttpRequest.class, HttpResponse.class});
    }
}

