/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.rtsp;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.rtsp.RtspHeaderNames;
import io.netty.handler.codec.rtsp.RtspMethods;
import io.netty.handler.codec.rtsp.RtspVersions;
import java.util.regex.Pattern;

public class RtspDecoder
extends HttpObjectDecoder {
    private static final HttpResponseStatus UNKNOWN_STATUS = new HttpResponseStatus(999, "Unknown");
    private boolean isDecodingRequest;
    private static final Pattern versionPattern = Pattern.compile("RTSP/\\d\\.\\d");
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 8192;

    public RtspDecoder() {
        this(4096, 8192, 8192);
    }

    /*
     * WARNING - void declaration
     */
    public RtspDecoder(int maxInitialLineLength, int maxHeaderSize, int maxContentLength) {
        super(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)(var3_3 << 1)).setChunkedSupported(false));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public RtspDecoder(int maxInitialLineLength, int maxHeaderSize, int maxContentLength, boolean validateHeaders) {
        super(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)(var3_3 << 1)).setChunkedSupported(false).setValidateHeaders(validateHeaders));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RtspDecoder(HttpDecoderConfig config) {
        super(config.clone().setMaxChunkSize(2 * var1_1.getMaxChunkSize()).setChunkedSupported(false));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected HttpMessage createMessage(String[] initialLine) throws Exception {
        void var1_1;
        if (versionPattern.matcher(initialLine[0]).matches()) {
            this.isDecodingRequest = false;
            return new DefaultHttpResponse(RtspVersions.valueOf(initialLine[0]), new HttpResponseStatus(Integer.parseInt(initialLine[1]), initialLine[2]), this.headersFactory);
        }
        this.isDecodingRequest = true;
        return new DefaultHttpRequest(RtspVersions.valueOf(initialLine[2]), RtspMethods.valueOf(initialLine[0]), (String)var1_1[1], this.headersFactory);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        void var1_1;
        return super.isContentAlwaysEmpty(msg) || !var1_1.headers().contains((CharSequence)RtspHeaderNames.CONTENT_LENGTH);
    }

    @Override
    protected HttpMessage createInvalidMessage() {
        if (this.isDecodingRequest) {
            return new DefaultFullHttpRequest(RtspVersions.RTSP_1_0, RtspMethods.OPTIONS, "/bad-request", Unpooled.buffer((int)0), this.headersFactory, this.trailersFactory);
        }
        return new DefaultFullHttpResponse(RtspVersions.RTSP_1_0, UNKNOWN_STATUS, Unpooled.buffer((int)0), this.headersFactory, this.trailersFactory);
    }

    @Override
    protected boolean isDecodingRequest() {
        return this.isDecodingRequest;
    }
}

