/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateEncoder;
import java.util.List;

class PerMessageDeflateEncoder
extends DeflateEncoder {
    private boolean compressing;

    /*
     * WARNING - void declaration
     */
    PerMessageDeflateEncoder(int compressionLevel, int windowSize, boolean noContext) {
        super((int)var1_1, (int)var2_2, (boolean)var3_3, WebSocketExtensionFilter.NEVER_SKIP);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    PerMessageDeflateEncoder(int compressionLevel, int windowSize, boolean noContext, WebSocketExtensionFilter extensionEncoderFilter) {
        super((int)var1_1, (int)var2_2, (boolean)var3_3, extensionEncoderFilter);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        void var1_1;
        if (!super.acceptOutboundMessage(msg)) {
            return false;
        }
        WebSocketFrame wsFrame = (WebSocketFrame)((Object)msg);
        if (this.extensionEncoderFilter().mustSkip(wsFrame)) {
            if (this.compressing) {
                throw new IllegalStateException("Cannot skip per message deflate encoder, compression in progress");
            }
            return false;
        }
        return (wsFrame instanceof TextWebSocketFrame || wsFrame instanceof BinaryWebSocketFrame) && (wsFrame.rsv() & 4) == 0 || var1_1 instanceof ContinuationWebSocketFrame && this.compressing;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int rsv(WebSocketFrame msg) {
        void var1_1;
        if (msg instanceof TextWebSocketFrame || msg instanceof BinaryWebSocketFrame) {
            return msg.rsv() | 4;
        }
        return var1_1.rsv();
    }

    @Override
    protected boolean removeFrameTail(WebSocketFrame msg) {
        return msg.isFinalFragment();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        void var2_2;
        void var3_3;
        void var1_1;
        super.encode((ChannelHandlerContext)var1_1, msg, (List<Object>)var3_3);
        if (msg.isFinalFragment()) {
            this.compressing = false;
            return;
        }
        if (msg instanceof TextWebSocketFrame || var2_2 instanceof BinaryWebSocketFrame) {
            this.compressing = true;
        }
    }
}

