/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder;
import java.util.List;

class PerMessageDeflateDecoder
extends DeflateDecoder {
    private boolean compressing;

    /*
     * WARNING - void declaration
     */
    PerMessageDeflateDecoder(boolean noContext) {
        super((boolean)var1_1, WebSocketExtensionFilter.NEVER_SKIP);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    PerMessageDeflateDecoder(boolean noContext, WebSocketExtensionFilter extensionDecoderFilter) {
        super((boolean)var1_1, (WebSocketExtensionFilter)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean acceptInboundMessage(Object msg) throws Exception {
        void var1_1;
        if (!super.acceptInboundMessage(msg)) {
            return false;
        }
        WebSocketFrame wsFrame = (WebSocketFrame)((Object)msg);
        if (this.extensionDecoderFilter().mustSkip(wsFrame)) {
            if (this.compressing) {
                throw new IllegalStateException("Cannot skip per message deflate decoder, compression in progress");
            }
            return false;
        }
        return (wsFrame instanceof TextWebSocketFrame || wsFrame instanceof BinaryWebSocketFrame) && (wsFrame.rsv() & 4) > 0 || var1_1 instanceof ContinuationWebSocketFrame && this.compressing;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int newRsv(WebSocketFrame msg) {
        void var1_1;
        if ((msg.rsv() & 4) > 0) {
            return msg.rsv() ^ 4;
        }
        return var1_1.rsv();
    }

    @Override
    protected boolean appendFrameTail(WebSocketFrame msg) {
        return msg.isFinalFragment();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        void var2_2;
        void var3_3;
        void var1_1;
        super.decode((ChannelHandlerContext)var1_1, msg, (List<Object>)var3_3);
        if (msg.isFinalFragment()) {
            this.compressing = false;
            return;
        }
        if (msg instanceof TextWebSocketFrame || var2_2 instanceof BinaryWebSocketFrame) {
            this.compressing = true;
        }
    }
}

