/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilterProvider;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateEncoder;
import io.netty.util.internal.ObjectUtil;
import java.util.Collections;

public final class DeflateFrameServerExtensionHandshaker
implements WebSocketServerExtensionHandshaker {
    static final String X_WEBKIT_DEFLATE_FRAME_EXTENSION = "x-webkit-deflate-frame";
    static final String DEFLATE_FRAME_EXTENSION = "deflate-frame";
    private final int compressionLevel;
    private final WebSocketExtensionFilterProvider extensionFilterProvider;

    public DeflateFrameServerExtensionHandshaker() {
        this(6);
    }

    /*
     * WARNING - void declaration
     */
    public DeflateFrameServerExtensionHandshaker(int compressionLevel) {
        this((int)var1_1, WebSocketExtensionFilterProvider.DEFAULT);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeflateFrameServerExtensionHandshaker(int compressionLevel, WebSocketExtensionFilterProvider extensionFilterProvider) {
        void var2_2;
        void var1_1;
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        this.compressionLevel = var1_1;
        this.extensionFilterProvider = (WebSocketExtensionFilterProvider)ObjectUtil.checkNotNull((Object)var2_2, (String)"extensionFilterProvider");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final WebSocketServerExtension handshakeExtension(WebSocketExtensionData extensionData) {
        if (!X_WEBKIT_DEFLATE_FRAME_EXTENSION.equals(extensionData.name()) && !DEFLATE_FRAME_EXTENSION.equals(extensionData.name())) {
            return null;
        }
        if (extensionData.parameters().isEmpty()) {
            void var1_1;
            return new DeflateFrameServerExtension(this.compressionLevel, var1_1.name(), this.extensionFilterProvider);
        }
        return null;
    }

    private static class DeflateFrameServerExtension
    implements WebSocketServerExtension {
        private final String extensionName;
        private final int compressionLevel;
        private final WebSocketExtensionFilterProvider extensionFilterProvider;

        /*
         * WARNING - void declaration
         */
        DeflateFrameServerExtension(int compressionLevel, String extensionName, WebSocketExtensionFilterProvider extensionFilterProvider) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.extensionName = var2_2;
            this.compressionLevel = var1_1;
            this.extensionFilterProvider = var3_3;
        }

        @Override
        public int rsv() {
            return 4;
        }

        @Override
        public WebSocketExtensionEncoder newExtensionEncoder() {
            return new PerFrameDeflateEncoder(this.compressionLevel, 15, false, this.extensionFilterProvider.encoderFilter());
        }

        @Override
        public WebSocketExtensionDecoder newExtensionDecoder() {
            return new PerFrameDeflateDecoder(false, this.extensionFilterProvider.decoderFilter());
        }

        @Override
        public WebSocketExtensionData newReponseData() {
            return new WebSocketExtensionData(this.extensionName, Collections.<String, String>emptyMap());
        }
    }
}

