/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilterProvider;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateEncoder;
import io.netty.util.internal.ObjectUtil;
import java.util.Collections;

public final class DeflateFrameClientExtensionHandshaker
implements WebSocketClientExtensionHandshaker {
    private final int compressionLevel;
    private final boolean useWebkitExtensionName;
    private final WebSocketExtensionFilterProvider extensionFilterProvider;

    /*
     * WARNING - void declaration
     */
    public DeflateFrameClientExtensionHandshaker(boolean useWebkitExtensionName) {
        this(6, (boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeflateFrameClientExtensionHandshaker(int compressionLevel, boolean useWebkitExtensionName) {
        this((int)var1_1, (boolean)var2_2, WebSocketExtensionFilterProvider.DEFAULT);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeflateFrameClientExtensionHandshaker(int compressionLevel, boolean useWebkitExtensionName, WebSocketExtensionFilterProvider extensionFilterProvider) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        this.compressionLevel = var1_1;
        this.useWebkitExtensionName = var2_2;
        this.extensionFilterProvider = (WebSocketExtensionFilterProvider)ObjectUtil.checkNotNull((Object)var3_3, (String)"extensionFilterProvider");
    }

    @Override
    public final WebSocketExtensionData newRequestData() {
        return new WebSocketExtensionData(this.useWebkitExtensionName ? "x-webkit-deflate-frame" : "deflate-frame", Collections.<String, String>emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final WebSocketClientExtension handshakeExtension(WebSocketExtensionData extensionData) {
        void var1_1;
        if (!"x-webkit-deflate-frame".equals(extensionData.name()) && !"deflate-frame".equals(extensionData.name())) {
            return null;
        }
        if (var1_1.parameters().isEmpty()) {
            return new DeflateFrameClientExtension(this.compressionLevel, this.extensionFilterProvider);
        }
        return null;
    }

    private static class DeflateFrameClientExtension
    implements WebSocketClientExtension {
        private final int compressionLevel;
        private final WebSocketExtensionFilterProvider extensionFilterProvider;

        /*
         * WARNING - void declaration
         */
        DeflateFrameClientExtension(int compressionLevel, WebSocketExtensionFilterProvider extensionFilterProvider) {
            void var2_2;
            void var1_1;
            this.compressionLevel = var1_1;
            this.extensionFilterProvider = var2_2;
        }

        @Override
        public int rsv() {
            return 4;
        }

        @Override
        public WebSocketExtensionEncoder newExtensionEncoder() {
            return new PerFrameDeflateEncoder(this.compressionLevel, 15, false, this.extensionFilterProvider.encoderFilter());
        }

        @Override
        public WebSocketExtensionDecoder newExtensionDecoder() {
            return new PerFrameDeflateDecoder(false, this.extensionFilterProvider.decoderFilter());
        }
    }
}

