/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;

public class WebSocketServerExtensionHandler
extends ChannelDuplexHandler {
    private final List<WebSocketServerExtensionHandshaker> extensionHandshakers;
    private final Queue<List<WebSocketServerExtension>> validExtensions = new ArrayDeque<List<WebSocketServerExtension>>(4);

    /*
     * WARNING - void declaration
     */
    public WebSocketServerExtensionHandler(WebSocketServerExtensionHandshaker ... extensionHandshakers) {
        void var1_1;
        this.extensionHandshakers = Arrays.asList(ObjectUtil.checkNonEmpty((Object[])var1_1, (String)"extensionHandshakers"));
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
            if (msg instanceof DefaultHttpRequest) {
                this.onHttpRequestChannelRead(ctx, (DefaultHttpRequest)msg);
                return;
            }
            if (msg instanceof HttpRequest) {
                this.onHttpRequestChannelRead(ctx, (HttpRequest)msg);
                return;
            }
            super.channelRead(ctx, msg);
            return;
        }
        super.channelRead((ChannelHandlerContext)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void onHttpRequestChannelRead(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        void var2_2;
        void var1_1;
        void var3_3;
        String extensionsHeader;
        List validExtensionsList = null;
        if (WebSocketExtensionUtil.isWebsocketUpgrade(request.headers()) && (extensionsHeader = request.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS)) != null) {
            List<WebSocketExtensionData> extensions = WebSocketExtensionUtil.extractExtensions(extensionsHeader);
            int rsv = 0;
            for (WebSocketExtensionData extensionData : extensions) {
                Object validExtension;
                Iterator<WebSocketServerExtensionHandshaker> extensionHandshakersIterator = this.extensionHandshakers.iterator();
                for (validExtension = null; validExtension == null && extensionHandshakersIterator.hasNext(); validExtension = validExtension.handshakeExtension(extensionData)) {
                    validExtension = extensionHandshakersIterator.next();
                }
                if (validExtension == null || (validExtension.rsv() & rsv) != 0) continue;
                if (validExtensionsList == null) {
                    validExtensionsList = new ArrayList(1);
                }
                rsv |= validExtension.rsv();
                validExtensionsList.add(validExtension);
            }
        }
        if (validExtensionsList == null) {
            validExtensionsList = Collections.emptyList();
        }
        this.validExtensions.offer((List<WebSocketServerExtension>)var3_3);
        super.channelRead((ChannelHandlerContext)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (msg != Unpooled.EMPTY_BUFFER && !(msg instanceof ByteBuf)) {
            if (msg instanceof DefaultHttpResponse) {
                this.onHttpResponseWrite(ctx, (DefaultHttpResponse)msg, promise);
                return;
            }
            if (msg instanceof HttpResponse) {
                this.onHttpResponseWrite(ctx, (HttpResponse)msg, promise);
                return;
            }
            super.write(ctx, msg, promise);
            return;
        }
        super.write((ChannelHandlerContext)var1_1, (Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void onHttpResponseWrite(ChannelHandlerContext ctx, HttpResponse response, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        List<WebSocketServerExtension> validExtensionsList = this.validExtensions.poll();
        if (HttpResponseStatus.SWITCHING_PROTOCOLS.equals(response.status())) {
            this.handlePotentialUpgrade(ctx, promise, response, validExtensionsList);
        }
        super.write((ChannelHandlerContext)var1_1, (Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void handlePotentialUpgrade(ChannelHandlerContext ctx, ChannelPromise promise, HttpResponse httpResponse, List<WebSocketServerExtension> validExtensionsList) {
        HttpHeaders headers = httpResponse.headers();
        if (WebSocketExtensionUtil.isWebsocketUpgrade(headers)) {
            void var1_1;
            void var2_2;
            if (validExtensionsList != null && !validExtensionsList.isEmpty()) {
                String headerValue = headers.getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
                ArrayList<WebSocketExtensionData> extraExtensions = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
                for (WebSocketServerExtension extension : validExtensionsList) {
                    extraExtensions.add(extension.newReponseData());
                }
                String newHeaderValue = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue(headerValue, extraExtensions);
                promise.addListener((GenericFutureListener)new ChannelFutureListener(this, validExtensionsList, ctx){
                    final /* synthetic */ List val$validExtensionsList;
                    final /* synthetic */ ChannelHandlerContext val$ctx;
                    final /* synthetic */ WebSocketServerExtensionHandler this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$validExtensionsList = list;
                        this.val$ctx = channelHandlerContext;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void operationComplete(ChannelFuture future) {
                        if (future.isSuccess()) {
                            for (WebSocketServerExtension extension : this.val$validExtensionsList) {
                                void var2_2;
                                void var3_3;
                                WebSocketExtensionDecoder decoder = extension.newExtensionDecoder();
                                WebSocketExtensionEncoder encoder = extension.newExtensionEncoder();
                                String name = this.val$ctx.name();
                                this.val$ctx.pipeline().addAfter(name, ((Object)((Object)decoder)).getClass().getName(), (ChannelHandler)var3_3).addAfter(name, ((Object)((Object)encoder)).getClass().getName(), (ChannelHandler)var2_2);
                            }
                        }
                    }
                });
                if (newHeaderValue != null) {
                    void var3_3;
                    var3_3.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)newHeaderValue);
                }
            }
            var2_2.addListener((GenericFutureListener)new ChannelFutureListener(this, (ChannelHandlerContext)var1_1){
                final /* synthetic */ ChannelHandlerContext val$ctx;
                final /* synthetic */ WebSocketServerExtensionHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$ctx = channelHandlerContext;
                }

                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        this.val$ctx.pipeline().remove((ChannelHandler)this.this$0);
                    }
                }
            });
        }
    }
}

